/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.Subscription;
import org.objectweb.joram.client.jms.admin.UserMBean;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearSubscription;
import org.objectweb.joram.shared.admin.CreateUserReply;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.DeleteSubscriptionMessage;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.admin.GetSubscription;
import org.objectweb.joram.shared.admin.GetSubscriptionMessage;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIds;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIdsRep;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageRep;
import org.objectweb.joram.shared.admin.GetSubscriptionRep;
import org.objectweb.joram.shared.admin.GetSubscriptions;
import org.objectweb.joram.shared.admin.GetSubscriptionsRep;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettings;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettingsRep;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsg;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsgRep;
import org.objectweb.joram.shared.admin.SetNbMaxMsg;
import org.objectweb.joram.shared.admin.SetUserDMQ;
import org.objectweb.joram.shared.admin.SetUserThreshold;
import org.objectweb.joram.shared.admin.UpdateUser;
import org.objectweb.util.monolog.api.BasicLevel;

public class User
extends AdministeredObject
implements UserMBean {
    private static final long serialVersionUID = 1L;
    String name;
    String proxyId;

    public User() {
    }

    public User(String name, String proxyId) {
        this.name = name;
        this.proxyId = proxyId;
    }

    public String toString() {
        return "User[" + this.name + "]:" + this.proxyId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        return other.proxyId == this.proxyId;
    }

    public static User create(String name, String password, int serverId) throws ConnectException, AdminException {
        User user;
        block2: {
            AdminReply reply = AdminModule.doRequest((AdminRequest)new CreateUserRequest(name, password, serverId));
            user = new User(name, ((CreateUserReply)reply).getProxId());
            try {
                MXWrapper.registerMBean((Object)user, (String)"joramClient", (String)("type=User,name=" + name + "[" + user.getProxyId() + "]"));
            }
            catch (Exception e) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"registerMBean", (Throwable)e);
            }
        }
        return user;
    }

    public static User create(String name, String password) throws ConnectException, AdminException {
        return User.create(name, password, AdminModule.getLocalServerId());
    }

    public void update(String newName, String newPassword) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new UpdateUser(this.name, this.proxyId, newName, newPassword));
        this.name = newName;
    }

    public void delete() throws ConnectException, AdminException {
        block2: {
            AdminModule.doRequest((AdminRequest)new DeleteUser(this.name, this.proxyId));
            try {
                MXWrapper.unregisterMBean((String)"joramClient", (String)("type=User,name=" + this.name + "[" + this.proxyId + "]"));
            }
            catch (Exception e) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"unregisterMBean", (Throwable)e);
            }
        }
    }

    public void setDMQ(DeadMQueue dmq) throws ConnectException, AdminException {
        this.setDMQId(dmq.getName());
    }

    public void setDMQId(String dmqId) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new SetUserDMQ(this.proxyId, dmqId));
    }

    public void setThreshold(int thresh) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new SetUserThreshold(this.proxyId, thresh));
    }

    public DeadMQueue getDMQ() throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(this.proxyId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)AdminModule.doRequest((AdminRequest)request);
        if (reply.getDMQName() == null) {
            return null;
        }
        return new DeadMQueue(reply.getDMQName());
    }

    public String getDMQId() throws ConnectException, AdminException {
        DeadMQueue dmq = this.getDMQ();
        if (dmq == null) {
            return null;
        }
        return dmq.getName();
    }

    public int getThreshold() throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(this.proxyId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)AdminModule.doRequest((AdminRequest)request);
        if (reply.getThreshold() == null) {
            return -1;
        }
        return reply.getThreshold();
    }

    public void setNbMaxMsg(String subName, int nbMaxMsg) throws ConnectException, AdminException {
        Subscription sub = this.getSubscription(subName);
        AdminModule.doRequest((AdminRequest)new SetNbMaxMsg(this.proxyId, nbMaxMsg, subName));
    }

    public int getNbMaxMsg(String subName) throws ConnectException, AdminException {
        Subscription sub = this.getSubscription(subName);
        Monitor_GetNbMaxMsg request = new Monitor_GetNbMaxMsg(this.proxyId, subName);
        Monitor_GetNbMaxMsgRep reply = (Monitor_GetNbMaxMsgRep)AdminModule.doRequest((AdminRequest)request);
        return reply.getNbMaxMsg();
    }

    public Subscription[] getSubscriptions() throws AdminException, ConnectException {
        GetSubscriptionsRep reply = (GetSubscriptionsRep)AdminModule.doRequest((AdminRequest)new GetSubscriptions(this.proxyId));
        String[] subNames = reply.getSubNames();
        String[] topicIds = reply.getTopicIds();
        int[] messageCounts = reply.getMessageCounts();
        boolean[] durable = reply.getDurable();
        Subscription[] res = new Subscription[subNames.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Subscription(subNames[i], topicIds[i], messageCounts[i], durable[i]);
        }
        return res;
    }

    public List getSubscriptionList() throws AdminException, ConnectException {
        Vector<String> list = new Vector<String>();
        Subscription[] sub = this.getSubscriptions();
        for (int i = 0; i < sub.length; ++i) {
            list.add(sub[i].toString());
        }
        return list;
    }

    public Subscription getSubscription(String subName) throws AdminException, ConnectException {
        GetSubscriptionRep reply = (GetSubscriptionRep)AdminModule.doRequest((AdminRequest)new GetSubscription(this.proxyId, subName));
        return new Subscription(subName, reply.getTopicId(), reply.getMessageCount(), reply.getDurable());
    }

    public String getSubscriptionString(String subName) throws AdminException, ConnectException {
        Subscription sub = this.getSubscription(subName);
        return sub.toString();
    }

    public String[] getMessageIds(String subName) throws AdminException, ConnectException {
        GetSubscriptionMessageIdsRep reply = (GetSubscriptionMessageIdsRep)AdminModule.doRequest((AdminRequest)new GetSubscriptionMessageIds(this.proxyId, subName));
        return reply.getMessageIds();
    }

    public Message readMessage(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)AdminModule.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId));
        return Message.wrapMomMessage(null, (org.objectweb.joram.shared.messages.Message)reply.getMessage());
    }

    public void deleteMessage(String subName, String msgId) throws AdminException, ConnectException {
        AdminModule.doRequest((AdminRequest)new DeleteSubscriptionMessage(this.proxyId, subName, msgId));
    }

    public void clearSubscription(String subName) throws AdminException, ConnectException {
        AdminModule.doRequest((AdminRequest)new ClearSubscription(this.proxyId, subName));
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public void toReference(Reference ref) throws NamingException {
        ref.add(new StringRefAddr("user.name", this.name));
        ref.add(new StringRefAddr("user.id", this.proxyId));
    }

    public void fromReference(Reference ref) throws NamingException {
        this.name = (String)ref.get("user.name").getContent();
        this.proxyId = (String)ref.get("user.id").getContent();
    }

    public Hashtable code() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("name", this.name);
        h.put("proxyId", this.proxyId);
        return h;
    }

    public void decode(Hashtable h) {
        this.name = (String)h.get("name");
        this.proxyId = (String)h.get("proxyId");
    }
}

