/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.objectweb.joram.client.jms.tcp.ReliableTcpClient;
import org.ow2.jasmine.jade.resources.joram.JoramOptimizationManager;

public class OptimizedReliableTcpClient
extends ReliableTcpClient {
    private JoramOptimizationManager manager = null;
    private volatile int managerStatus = 1;

    public synchronized void close() {
        if (this.managerStatus != 2) {
            this.managerStatus = 2;
            String location = System.getProperty("location");
            String clusterQueue = System.getProperty("joram.clusterQueue");
            int prodWeight = 0;
            int consWeight = 0;
            try {
                prodWeight = Integer.parseInt(System.getProperty("joram.prodWeight"));
            }
            catch (Exception e) {
                prodWeight = 0;
            }
            try {
                consWeight = Integer.parseInt(System.getProperty("joram.consWeight"));
            }
            catch (Exception e) {
                consWeight = 0;
            }
            if (clusterQueue != null && (prodWeight > 0 || consWeight > 0)) {
                if (this.manager == null) {
                    try {
                        String registryHost = System.getProperty("registry.hostname");
                        Registry reg = LocateRegistry.getRegistry(registryHost);
                        this.manager = (JoramOptimizationManager)reg.lookup("JoramManager");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.manager != null) {
                    try {
                        this.manager.remove(clusterQueue, location, prodWeight, consWeight);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        super.close();
    }
}

