/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import java.net.ConnectException;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.tcp.TcpConnection;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpConnectionFactory
extends ConnectionFactory {
    private static final long serialVersionUID = 1L;

    public TcpConnectionFactory(String host, int port) {
        super(host, port);
    }

    public TcpConnectionFactory() {
    }

    public javax.jms.Connection createConnection(String name, String password) throws JMSException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("TcpConnectionFactory.createConnection(" + name + ',' + password + ") reliableClass=" + this.reliableClass));
        }
        return new Connection(this.params, (RequestChannel)new TcpConnection(this.params, name, password, this.reliableClass));
    }

    public static javax.jms.ConnectionFactory create(String host, int port) {
        return TcpConnectionFactory.create(host, port, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public static javax.jms.ConnectionFactory create(String host, int port, String reliableClass) {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("TcpConnectionFactory.create(" + host + ',' + port + ',' + reliableClass + ')'));
        }
        TcpConnectionFactory cf = new TcpConnectionFactory(host, port);
        cf.setReliableClass(reliableClass);
        return cf;
    }

    public static javax.jms.ConnectionFactory create() throws ConnectException {
        return TcpConnectionFactory.create(AdminModule.getLocalHost(), AdminModule.getLocalPort());
    }
}

