/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fscript.FScript;
import org.objectweb.fractal.fscript.FScriptEngine;
import org.objectweb.fractal.fscript.FScriptException;
import org.objectweb.fractal.fscript.model.Node;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.InterfaceNode;
import org.objectweb.fractal.fscript.model.fractal.NodeFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.ow2.jasmine.jade.resources.joram.JoramElements;
import org.ow2.jasmine.jade.resources.joram.UserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperUtil {
    protected Component myself;
    Component fscript;
    FScriptEngine engine;
    NodeFactory nf;
    protected final int PORT_NUMBER_START = 16020;

    public WrapperUtil() {
        try {
            this.fscript = FScript.newEngine();
            this.engine = FScript.getFScriptEngine((Component)this.fscript);
            this.nf = FScript.getNodeFactory((Component)this.fscript);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LinkedList<Component> getAllServers() {
        ComponentNode n = this.nf.createComponentNode(this.myself);
        LinkedList<Component> res = new LinkedList<Component>();
        try {
            this.engine.setGlobalVariable("myself", (Object)n);
            Set nodes = (Set)this.engine.execute("$myself/parent::*/sibling-or-self::*[starts-with(name(.), 'JoramServer_')]");
            for (Node node : nodes) {
                Component cmp = ((ComponentNode)node).getComponent();
                res.add(cmp);
            }
            return res;
        }
        catch (FScriptException e) {
            e.printStackTrace();
            return res;
        }
    }

    protected Component getServerComponent() throws NoSuchInterfaceException, AdminException {
        try {
            ComponentNode n = this.nf.createComponentNode(this.myself);
            this.engine.setGlobalVariable("myself", (Object)n);
            Set nodes = (Set)this.engine.execute("$myself/parent::*[starts-with(name(.), 'JoramServer_')]");
            Iterator i$ = nodes.iterator();
            if (i$.hasNext()) {
                Node node = (Node)i$.next();
                Component cmp = ((ComponentNode)node).getComponent();
                return cmp;
            }
            return null;
        }
        catch (FScriptException e) {
            throw new AdminException("Unable to find the server wrapper");
        }
    }

    protected UserInterface getUserInterfaceFromName(String name) throws Exception {
        return (UserInterface)this.getInterfaceInAllServers(JoramElements.user, name);
    }

    protected Interface getInterfaceInAllServers(JoramElements itfType, String name) throws NoSuchInterfaceException, AdminException {
        Interface res = null;
        Iterator it = this.getAllServers().iterator();
        while (it.hasNext()) {
            res = this.getInterfaceFromServerCompAndName((Component)it.next(), name, itfType);
            if (res == null) continue;
            return res;
        }
        throw new AdminException("Unable to find the component interface in domain");
    }

    private Interface getInterfaceFromServerCompAndName(Component server, String name, JoramElements itfType) throws NoSuchInterfaceException, AdminException {
        this.engine.setGlobalVariable("name", (Object)name);
        if (itfType == JoramElements.topic) {
            this.engine.setGlobalVariable("itf", (Object)"topic");
        } else if (itfType == JoramElements.queue) {
            this.engine.setGlobalVariable("itf", (Object)"queue");
        } else if (itfType == JoramElements.user) {
            this.engine.setGlobalVariable("itf", (Object)"user");
        }
        this.engine.setGlobalVariable("c", (Object)this.nf.createComponentNode(server));
        try {
            Set res = (Set)this.engine.execute("$c/child::$name/interface::$itf");
            if (res.isEmpty()) {
                return null;
            }
            return ((InterfaceNode)res.iterator().next()).getInterface();
        }
        catch (FScriptException e) {
            e.printStackTrace();
            return null;
        }
    }
}

