/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.connectionFactory;

import java.util.HashSet;
import java.util.Properties;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.ConnectionFactoryInterface;
import org.ow2.jasmine.jade.resources.joram.JndiInterface;
import org.ow2.jasmine.jade.wrapper.joram.WrapperUtil;

public class Wrapper
extends WrapperUtil
implements ConnectionFactoryInterface,
LifeCycleController,
GenericAttributeController,
BindingController {
    private boolean started;
    private Properties serverConfig;
    private javax.jms.ConnectionFactory myConnFact;
    private static final String OPTIMIZED_RELIABLE_TCP_CLIENT = "org.objectweb.joram.client.jms.tcp.OptimizedReliableTcpClient";
    private boolean optimized = false;
    private String name;
    private String[] listAtt = new String[]{"name", "optimized"};
    private Context context;

    private void initializeContext() {
        JndiInterface jndiItf = null;
        try {
            jndiItf = (JndiInterface)Fractal.getBindingController((Component)this.getServerComponent()).lookupFc("jndi");
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        catch (AdminException e1) {
            e1.printStackTrace();
        }
        System.out.println("JNDI: Host " + jndiItf.getHost() + " Port " + jndiItf.getPort());
        Properties jndiprops = new Properties();
        jndiprops.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
        jndiprops.setProperty("java.naming.factory.host", jndiItf.getHost());
        jndiprops.setProperty("java.naming.factory.port", jndiItf.getPort());
        Thread ct = Thread.currentThread();
        ClassLoader cl = ct.getContextClassLoader();
        ct.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.context = new InitialContext(jndiprops);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        ct.setContextClassLoader(cl);
    }

    private void initServerConfig() throws NoSuchInterfaceException, AdminException, NoSuchAttributeException {
        this.serverConfig = new Properties();
        Component server = this.getServerComponent();
        String serverHost = FractalUtil.getGenericAttributeController((Component)server).getAttribute("host");
        if (serverHost.contains("_")) {
            serverHost = serverHost.split("_")[0];
        }
        this.serverConfig.put("hostName", serverHost);
        this.serverConfig.put("port", (Object)(16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"))));
        this.serverConfig.put("sid", FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"));
        this.serverConfig.put("userAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("userAdmin"));
        this.serverConfig.put("passAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("passAdmin"));
    }

    private void registerInJNDI() {
        this.initializeContext();
        try {
            this.context.bind(this.name, (Object)this.myConnFact);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        System.out.println("Connection Factory " + this.name + " registered in Jndi");
    }

    public String getFcState() {
        return this.started ? "STARTED" : "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.initServerConfig();
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
            AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
            this.myConnFact = this.optimized ? (ConnectionFactory)TcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")), OPTIMIZED_RELIABLE_TCP_CLIENT) : (ConnectionFactory)TcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
            System.out.println("Connection Factory " + this.name + " created");
            AdminModule.disconnect();
            this.registerInJNDI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.started = true;
    }

    public void stopFc() throws IllegalLifeCycleException {
        this.started = false;
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("name")) {
            return name;
        }
        if (name.equals("optimized")) {
            return "" + this.optimized;
        }
        throw new NoSuchAttributeException(name);
    }

    public String[] listFcAtt() {
        return this.listAtt;
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.equals("name")) {
            this.name = value;
        } else if (name.equals("optimized")) {
            this.optimized = Boolean.parseBoolean(value);
        } else {
            throw new NoSuchAttributeException(name);
        }
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!itfName.equals("component")) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.myself = (Component)itfValue;
    }

    public String[] listFc() {
        HashSet keys = new HashSet();
        return keys.toArray(new String[keys.size()]);
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("component")) {
            return this.myself;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!itfName.equals("component")) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.myself = null;
    }

    public javax.jms.ConnectionFactory getConnectionFactory() {
        return this.myConnFact;
    }
}

