/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.control.content.clusterconnectionfactory;

import java.util.Properties;
import java.util.Set;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.fscript.FScript;
import org.objectweb.fractal.fscript.FScriptEngine;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.NodeFactory;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.ClusterConnectionFactory;
import org.objectweb.joram.client.jms.admin.OptimizedClusterConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.ConnectionFactoryInterface;
import org.ow2.jasmine.jade.resources.joram.JndiInterface;

public abstract class ClusterConnectionFactoryContentControllerMixin
implements ContentController {
    private Context context;
    private boolean optimized;
    private final int PORT_NUMBER_START = 16020;
    private Component _this_weaveableC;
    private BindingController _this_weaveableBC;
    private NameController _this_weaveableOptNC;

    public void addFcSubComponent(Component connectionFactory) throws IllegalContentException, IllegalLifeCycleException {
        try {
            this.getContext().lookup(this._this_weaveableOptNC.getFcName());
        }
        catch (NamingException e1) {
            this.bindEmptyClusterConnectionFactory();
        }
        try {
            Component rootServer = this.getServerCompFromConnectionFactoryComp(connectionFactory);
            String serverHost = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("host");
            if (serverHost.contains("_")) {
                serverHost = serverHost.split("_")[0];
            }
            int serverPort = 16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid"));
            String serverAdminName = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("userAdmin");
            String serverAdminPass = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("passAdmin");
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(serverHost, serverPort);
            AdminModule.connect(con, serverAdminName, serverAdminPass);
            Thread ct = Thread.currentThread();
            ClassLoader cl = ct.getContextClassLoader();
            ct.setContextClassLoader(this.getClass().getClassLoader());
            try {
                ClusterConnectionFactory clusterConnFact = (ClusterConnectionFactory)this.context.lookup(this._this_weaveableOptNC.getFcName());
                System.out.println("" + clusterConnFact);
                ConnectionFactoryInterface cfItf = (ConnectionFactoryInterface)connectionFactory.getFcInterface("connectionFactory");
                String location = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid");
                clusterConnFact.addConnectionFactory(location, (TcpConnectionFactory)cfItf.getConnectionFactory());
                this.getContext().rebind(this._this_weaveableOptNC.getFcName(), (Object)clusterConnFact);
                System.out.println("Connection Factory " + FractalUtil.getGenericAttributeController((Component)connectionFactory).getAttribute("name") + " added to the Cluster Connection Factory " + this._this_weaveableOptNC.getFcName());
                System.out.println("" + clusterConnFact);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            ct.setContextClassLoader(cl);
            AdminModule.disconnect();
            this._super_addFcSubComponent(connectionFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bindEmptyClusterConnectionFactory() {
        try {
            this.initializeContext();
            this.optimized = Boolean.parseBoolean(FractalUtil.getGenericAttributeController((Component)this._this_weaveableC).getAttribute("optimized"));
            if (this.optimized) {
                this.context.bind(this._this_weaveableOptNC.getFcName(), (Object)new OptimizedClusterConnectionFactory());
            } else {
                this.context.bind(this._this_weaveableOptNC.getFcName(), (Object)new ClusterConnectionFactory());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeContext() {
        JndiInterface jndiItf = null;
        try {
            jndiItf = (JndiInterface)this._this_weaveableBC.lookupFc("jndi");
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        System.out.println("JNDI://" + jndiItf.getHost() + ":" + jndiItf.getPort());
        Properties jndiprops = new Properties();
        jndiprops.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
        jndiprops.setProperty("java.naming.factory.host", jndiItf.getHost());
        jndiprops.setProperty("java.naming.factory.port", jndiItf.getPort());
        Thread ct = Thread.currentThread();
        ClassLoader cl = ct.getContextClassLoader();
        ct.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.context = new InitialContext(jndiprops);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        ct.setContextClassLoader(cl);
    }

    private Context getContext() {
        if (this.context == null) {
            this.initializeContext();
        }
        return this.context;
    }

    private Component getServerCompFromConnectionFactoryComp(Component connectionFactory) throws JadeException {
        NodeFactory nf;
        FScriptEngine engine;
        try {
            Component fscript = FScript.newEngine();
            engine = FScript.getFScriptEngine((Component)fscript);
            nf = FScript.getNodeFactory((Component)fscript);
        }
        catch (Exception e1) {
            return null;
        }
        ComponentNode n = nf.createComponentNode(connectionFactory);
        engine.setGlobalVariable("connectionFactory", (Object)n);
        try {
            Set nodes = (Set)engine.execute("$connectionFactory/parent::*[starts-with(name(.), 'JoramServer_')]");
            if (!nodes.isEmpty()) {
                ComponentNode element = (ComponentNode)nodes.iterator().next();
                return element.getComponent();
            }
            throw new JadeException("Cannot find the server component to which this connection factory belong");
        }
        catch (Exception e) {
            throw new JadeException("Cannot find the server component to which this connection factory belong");
        }
    }

    public abstract void _super_addFcSubComponent(Component var1) throws IllegalContentException, IllegalLifeCycleException;
}

