/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.control.content.clusterqueue;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.fscript.FScript;
import org.objectweb.fractal.fscript.FScriptEngine;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.NodeFactory;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.ClusterQueue;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.JndiInterface;
import org.ow2.jasmine.jade.resources.joram.QueueInterface;

public abstract class ClusterQueueContentControllerMixin
implements ContentController {
    private final int PORT_NUMBER_START = 16020;
    private Context context;
    public static Class toto = QueueInterface.class;
    public Component _this_weaveableC;
    private BindingController _this_weaveableBC;
    private NameController _this_weaveableOptNC;

    private void initializeContext() {
        JndiInterface jndiItf = null;
        try {
            jndiItf = (JndiInterface)this._this_weaveableBC.lookupFc("jndi");
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        System.out.println("JNDI://" + jndiItf.getHost() + ":" + jndiItf.getPort());
        Properties jndiprops = new Properties();
        jndiprops.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
        jndiprops.setProperty("java.naming.factory.host", jndiItf.getHost());
        jndiprops.setProperty("java.naming.factory.port", jndiItf.getPort());
        Thread ct = Thread.currentThread();
        ClassLoader cl = ct.getContextClassLoader();
        ct.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.context = new InitialContext(jndiprops);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        ct.setContextClassLoader(cl);
    }

    private Context getContext() {
        if (this.context == null) {
            this.initializeContext();
        }
        return this.context;
    }

    private void bindEmptyClusterQueue() {
        try {
            Hashtable h = new Hashtable();
            ClusterQueue myClusterQueue = new ClusterQueue(h);
            System.out.println("ClusterQueue Class : " + ((Object)((Object)myClusterQueue)).getClass() + " " + ((Object)((Object)myClusterQueue)).getClass().getClassLoader());
            System.out.println("Object clusterQueue dans Joram " + (Object)((Object)myClusterQueue));
            this.initializeContext();
            this.context.bind(this._this_weaveableOptNC.getFcName(), (Object)myClusterQueue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFcSubComponent(Component queue) throws IllegalContentException, IllegalLifeCycleException {
        try {
            this.getContext().lookup(this._this_weaveableOptNC.getFcName());
        }
        catch (NamingException e1) {
            this.bindEmptyClusterQueue();
        }
        try {
            Object qIt = queue.getFcInterface("queue");
            System.out.println("Queue ::::: " + Fractal.getNameController((Component)queue).getFcName());
            System.out.println("Queue ::::: " + queue);
            Class<?> qitClass = qIt.getClass();
            for (Class<?> it : qitClass.getInterfaces()) {
                System.out.println(it.toString() + " " + it.getClassLoader().toString());
            }
            System.out.println(qIt.getClass().toString());
            System.out.println(qIt.getClass().getClassLoader().toString());
            System.out.println(toto.getClassLoader().toString());
            if (qIt instanceof Component) {
                Object[] its;
                System.out.println("qit ========" + qIt);
                for (Object it2 : its = ((Component)qIt).getFcInterfaces()) {
                    System.out.println(it2);
                }
            }
            QueueInterface qItfToAdd = (QueueInterface)queue.getFcInterface("queue");
            Queue queueToAdd = qItfToAdd.getQueue();
            Component[] queues = this.getFcSubComponents();
            if (queues.length > 0) {
                QueueInterface root = (QueueInterface)queues[0].getFcInterface("queue");
                System.out.println("Adding " + queueToAdd.getAdminName() + " queue to cluster using " + root.getQueue().getAdminName() + " ...");
                Queue rootQueue = root.getQueue();
                Component rootServer = this.getServerCompFromQueueComp(queues[0]);
                String serverHost = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("host");
                if (serverHost.contains("_")) {
                    serverHost = serverHost.split("_")[0];
                }
                int serverPort = 16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid"));
                String serverAdminName = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("userAdmin");
                String serverAdminPass = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("passAdmin");
                TopicConnectionFactory con = TopicTcpConnectionFactory.create(serverHost, serverPort);
                AdminModule.connect(con, serverAdminName, serverAdminPass);
                rootQueue.addClusteredQueue(queueToAdd);
                AdminModule.disconnect();
                System.out.println("Queue " + queueToAdd.getAdminName() + " added to cluster");
            }
            Context ctx = this.getContext();
            ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Object o = ctx.lookup(this._this_weaveableOptNC.getFcName());
            Thread.currentThread().setContextClassLoader(cl1);
            ClusterQueue cq = (ClusterQueue)((Object)o);
            Hashtable cluster = cq.getCluster();
            cluster.put(qItfToAdd.getMyServerSID(), queueToAdd);
            cq.setCluster(cluster);
            System.out.println("Cluster: \n" + cq.getCluster().toString());
            this.getContext().rebind(this._this_weaveableOptNC.getFcName(), (Object)cq);
            this._super_addFcSubComponent(queue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getFcInternalInterface(String arg0) throws NoSuchInterfaceException {
        return this._super_getFcInternalInterface(arg0);
    }

    public Object[] getFcInternalInterfaces() {
        return this._super_getFcInternalInterfaces();
    }

    public Component[] getFcSubComponents() {
        return this._super_getFcSubComponents();
    }

    public void removeFcSubComponent(Component queue) throws IllegalContentException, IllegalLifeCycleException {
        try {
            QueueInterface qItfToRm = (QueueInterface)queue.getFcInterface("queue");
            Queue queueToRm = qItfToRm.getQueue();
            Component[] queues = this.getFcSubComponents();
            if (queues.length > 1) {
                QueueInterface root = this.getRootQueueOtherThanSpecifiedName(Fractal.getNameController((Component)queue).getFcName());
                Queue rootQueue = root.getQueue();
                System.out.println("Removing " + queueToRm.getAdminName() + " queue from cluster using " + rootQueue.getAdminName() + " ...");
                Component rootServer = this.getServerCompFromQueueComp(queues[0]);
                String serverHost = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("host");
                int serverPort = 16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid"));
                String serverAdminName = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("userAdmin");
                String serverAdminPass = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("passAdmin");
                TopicConnectionFactory con = TopicTcpConnectionFactory.create(serverHost, serverPort);
                AdminModule.connect(con, serverAdminName, serverAdminPass);
                rootQueue.removeClusteredQueue(queueToRm);
                AdminModule.disconnect();
                System.out.println("Queue " + queueToRm.getAdminName() + " removed from " + rootQueue.getAdminName() + " cluster");
            }
            Context ctx = this.getContext();
            ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Object o = ctx.lookup(this._this_weaveableOptNC.getFcName());
            Thread.currentThread().setContextClassLoader(cl1);
            ClusterQueue cq = (ClusterQueue)((Object)o);
            Hashtable cluster = cq.getCluster();
            cluster.remove(qItfToRm.getMyServerSID());
            cq.setCluster(cluster);
            System.out.println("Cluster: \n" + cq.getCluster().toString());
            this.getContext().rebind(this._this_weaveableOptNC.getFcName(), (Object)cq);
            this._super_removeFcSubComponent(queue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Component getServerCompFromQueueComp(Component queue) throws JadeException {
        NodeFactory nf;
        FScriptEngine engine;
        try {
            Component fscript = FScript.newEngine();
            engine = FScript.getFScriptEngine((Component)fscript);
            nf = FScript.getNodeFactory((Component)fscript);
        }
        catch (Exception e1) {
            return null;
        }
        ComponentNode n = nf.createComponentNode(queue);
        engine.setGlobalVariable("queue", (Object)n);
        try {
            Set nodes = (Set)engine.execute("$queue/parent::*[starts-with(name(.), 'JoramServer_')]");
            if (!nodes.isEmpty()) {
                ComponentNode element = (ComponentNode)nodes.iterator().next();
                return element.getComponent();
            }
            throw new JadeException("Cannot find the server component to which this topic belong");
        }
        catch (Exception e) {
            throw new JadeException("Cannot find the server component to which this topic belong");
        }
    }

    private QueueInterface getRootQueueOtherThanSpecifiedName(String name) throws JadeException {
        try {
            Component[] queues = this.getFcSubComponents();
            for (int i = 0; i < queues.length; ++i) {
                if (Fractal.getNameController((Component)queues[i]).getFcName().equals(name)) continue;
                return (QueueInterface)queues[i].getFcInterface("queue");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new JadeException("The cluster contains only one queue");
    }

    public abstract Component[] _super_getFcSubComponents();

    public abstract void _super_addFcSubComponent(Component var1) throws IllegalContentException, IllegalLifeCycleException;

    public abstract void _super_removeFcSubComponent(Component var1) throws IllegalContentException, IllegalLifeCycleException;

    public abstract Object _super_getFcInternalInterface(String var1) throws NoSuchInterfaceException;

    public abstract Object[] _super_getFcInternalInterfaces();
}

