/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.control.content.clustertopic;

import java.util.Set;
import javax.jms.TopicConnectionFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.fscript.FScript;
import org.objectweb.fractal.fscript.FScriptEngine;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.NodeFactory;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.TopicInterface;

public abstract class ClusterTopicContentControllerMixin
implements ContentController {
    public Component _this_weaveableC;
    private final int PORT_NUMBER_START = 16020;

    public void addFcSubComponent(Component topic) throws IllegalContentException, IllegalLifeCycleException {
        try {
            TopicInterface tItfToAdd = (TopicInterface)topic.getFcInterface("topic");
            Topic topicToAdd = tItfToAdd.getTopic();
            Component[] topics = this.getFcSubComponents();
            if (topics.length > 0) {
                TopicInterface root = (TopicInterface)topics[0].getFcInterface("topic");
                Topic rootTopic = root.getTopic();
                Component rootServer = this.getServerCompFromTopicComp(topics[0]);
                String serverHost = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("host");
                int serverPort = 16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid"));
                String serverAdminName = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("userAdmin");
                String serverAdminPass = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("passAdmin");
                TopicConnectionFactory con = TopicTcpConnectionFactory.create(serverHost, serverPort);
                AdminModule.connect(con, serverAdminName, serverAdminPass);
                rootTopic.addClusteredTopic(topicToAdd);
                System.out.println("Topic " + topicToAdd.getAdminName() + " added to cluster: " + rootTopic.getClusterFellows());
                AdminModule.disconnect();
            }
            this._super_addFcSubComponent(topic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Component getServerCompFromTopicComp(Component topic) throws JadeException {
        NodeFactory nf;
        FScriptEngine engine;
        try {
            Component fscript = FScript.newEngine();
            engine = FScript.getFScriptEngine((Component)fscript);
            nf = FScript.getNodeFactory((Component)fscript);
        }
        catch (Exception e1) {
            return null;
        }
        ComponentNode n = nf.createComponentNode(topic);
        engine.setGlobalVariable("topic", (Object)n);
        try {
            Set nodes = (Set)engine.execute("$topic/parent::*[starts-with(name(.), 'JoramServer_')]");
            if (!nodes.isEmpty()) {
                ComponentNode element = (ComponentNode)nodes.iterator().next();
                return element.getComponent();
            }
            throw new JadeException("Cannot find the server component to which this topic belong");
        }
        catch (Exception e) {
            throw new JadeException("Cannot find the server component to which this topic belong");
        }
    }

    public Object getFcInternalInterface(String arg0) throws NoSuchInterfaceException {
        return this._super_getFcInternalInterface(arg0);
    }

    public Object[] getFcInternalInterfaces() {
        return this._super_getFcInternalInterfaces();
    }

    public Component[] getFcSubComponents() {
        return this._super_getFcSubComponents();
    }

    public void removeFcSubComponent(Component topic) throws IllegalContentException, IllegalLifeCycleException {
        try {
            TopicInterface tItfToRm = (TopicInterface)topic.getFcInterface("topic");
            Topic topicToRm = tItfToRm.getTopic();
            Component rootServer = this.getServerCompFromTopicComp(topic);
            String serverHost = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("host");
            int serverPort = 16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid"));
            String serverAdminName = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("userAdmin");
            String serverAdminPass = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("passAdmin");
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(serverHost, serverPort);
            AdminModule.connect(con, serverAdminName, serverAdminPass);
            try {
                topicToRm.removeFromCluster();
            }
            catch (AdminException ignored) {
                // empty catch block
            }
            AdminModule.disconnect();
            this._super_removeFcSubComponent(topic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract Component[] _super_getFcSubComponents();

    public abstract void _super_addFcSubComponent(Component var1) throws IllegalContentException, IllegalLifeCycleException;

    public abstract void _super_removeFcSubComponent(Component var1) throws IllegalContentException, IllegalLifeCycleException;

    public abstract Object _super_getFcInternalInterface(String var1) throws NoSuchInterfaceException;

    public abstract Object[] _super_getFcInternalInterfaces();
}

