/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.control.genericattribute.clusterqueue;

import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.fscript.FScript;
import org.objectweb.fractal.fscript.FScriptEngine;
import org.objectweb.fractal.fscript.FScriptException;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.InterfaceNode;
import org.objectweb.fractal.fscript.model.fractal.NodeFactory;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.ClusterQueue;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.JndiInterface;
import org.ow2.jasmine.jade.resources.joram.JoramElements;
import org.ow2.jasmine.jade.resources.joram.UserInterface;

public abstract class ClusterQueueGenericAttributeControllerMixin
implements GenericAttributeController,
Controller {
    private String readers;
    private String writers;
    private Context context;
    private String[] listAtt;
    Properties serverConfig;
    private final int PORT_NUMBER_START = 16020;
    private Component _this_weaveableC;
    private BindingController _this_weaveableBC;
    private NameController _this_weaveableOptNC;

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this.listAtt = new String[2];
        this.listAtt[0] = "readers";
        this.listAtt[1] = "writers";
        this._super_initFcController(ic);
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("readers")) {
            return this.readers;
        }
        if (name.equals("writers")) {
            return this.writers;
        }
        return this._super_getAttribute(name);
    }

    public String[] listFcAtt() {
        LinkedList<String> list = new LinkedList<String>();
        for (String att : this.listAtt) {
            list.add(att);
        }
        if (this._super_listFcAtt() != null) {
            for (String att : this._super_listFcAtt()) {
                if (list.contains(att)) continue;
                list.add(att);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.equals("readers")) {
            try {
                this.setReaders(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.readers = value;
        } else if (name.equals("writers")) {
            try {
                this.setWriters(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.writers = value;
        }
        this._super_setAttribute(name, value);
    }

    private void setReaders(String readers) throws Exception {
        this.initializeContext();
        try {
            this.initServerConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Object o = this.context.lookup(this._this_weaveableOptNC.getFcName());
        Thread.currentThread().setContextClassLoader(cl1);
        ClusterQueue cq = (ClusterQueue)((Object)o);
        TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
        AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
        StringTokenizer st = new StringTokenizer(readers);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("all")) {
                cq.setFreeReading();
                System.out.println(this._this_weaveableOptNC.getFcName() + " cluster is freely writable");
                continue;
            }
            cq.setReader(this.getUserInterfaceFromName(token).getUser());
            System.out.println(token + " added to " + this._this_weaveableOptNC.getFcName() + " readers");
        }
        this.context.rebind(this._this_weaveableOptNC.getFcName(), (Object)cq);
        AdminModule.disconnect();
    }

    private void setWriters(String writers) throws Exception {
        this.initializeContext();
        try {
            this.initServerConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Object o = this.context.lookup(this._this_weaveableOptNC.getFcName());
        Thread.currentThread().setContextClassLoader(cl1);
        ClusterQueue cq = (ClusterQueue)((Object)o);
        TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
        AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
        StringTokenizer st = new StringTokenizer(writers);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("all")) {
                cq.setFreeWriting();
                System.out.println(this._this_weaveableOptNC.getFcName() + " cluster is freely writable");
                continue;
            }
            cq.setWriter(this.getUserInterfaceFromName(token).getUser());
            System.out.println(token + " added to " + this._this_weaveableOptNC.getFcName() + " writers");
        }
        this.context.rebind(this._this_weaveableOptNC.getFcName(), (Object)cq);
        AdminModule.disconnect();
    }

    private void initializeContext() {
        JndiInterface jndiItf = null;
        try {
            jndiItf = (JndiInterface)this._this_weaveableBC.lookupFc("jndi");
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        System.out.println("JNDI://" + jndiItf.getHost() + ":" + jndiItf.getPort());
        Properties jndiprops = new Properties();
        jndiprops.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
        jndiprops.setProperty("java.naming.factory.host", jndiItf.getHost());
        jndiprops.setProperty("java.naming.factory.port", jndiItf.getPort());
        Thread ct = Thread.currentThread();
        ClassLoader cl = ct.getContextClassLoader();
        ct.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.context = new InitialContext(jndiprops);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        ct.setContextClassLoader(cl);
    }

    private Component getGatewayServer() {
        NodeFactory nf;
        FScriptEngine engine;
        try {
            Component fscript = FScript.newEngine();
            engine = FScript.getFScriptEngine((Component)fscript);
            nf = FScript.getNodeFactory((Component)fscript);
        }
        catch (Exception e1) {
            return null;
        }
        ComponentNode n = nf.createComponentNode(this._this_weaveableC);
        engine.setGlobalVariable("self", (Object)n);
        try {
            Set nodes = (Set)engine.execute("$self/sibling::*[starts-with(name(.), 'JoramServer_')]");
            if (!nodes.isEmpty()) {
                ComponentNode cnode = (ComponentNode)nodes.iterator().next();
                return cnode.getComponent();
            }
        }
        catch (FScriptException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    protected UserInterface getUserInterfaceFromName(String name) throws Exception {
        return (UserInterface)this.getInterfaceInAllServers(JoramElements.user, name);
    }

    private Component[] getAllServers() {
        NodeFactory nf;
        FScriptEngine engine;
        try {
            Component fscript = FScript.newEngine();
            engine = FScript.getFScriptEngine((Component)fscript);
            nf = FScript.getNodeFactory((Component)fscript);
        }
        catch (Exception e1) {
            return null;
        }
        ComponentNode n = nf.createComponentNode(this._this_weaveableC);
        engine.setGlobalVariable("self", (Object)n);
        Component[] res = null;
        try {
            Set nodes = (Set)engine.execute("$self/sibling::*[starts-with(name(.), 'JoramServer_')]");
            res = new Component[nodes.size()];
            int i = 0;
            for (ComponentNode element : nodes) {
                res[i] = element.getComponent();
                ++i;
            }
        }
        catch (FScriptException e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    protected Interface getInterfaceInAllServers(JoramElements itfType, String name) throws NoSuchInterfaceException, AdminException {
        Interface res = null;
        for (Component server : this.getAllServers()) {
            res = this.getInterfaceFromServerCompAndName(server, name, itfType);
            if (res == null) continue;
            return res;
        }
        throw new AdminException("Unable to find the component interface in domain");
    }

    private Interface getInterfaceFromServerCompAndName(Component server, String name, JoramElements itfType) throws NoSuchInterfaceException, AdminException {
        NodeFactory nf;
        FScriptEngine engine;
        try {
            Component fscript = FScript.newEngine();
            engine = FScript.getFScriptEngine((Component)fscript);
            nf = FScript.getNodeFactory((Component)fscript);
        }
        catch (Exception e1) {
            return null;
        }
        engine.setGlobalVariable("name", (Object)name);
        if (itfType == JoramElements.topic) {
            engine.setGlobalVariable("itf", (Object)"topic");
        } else if (itfType == JoramElements.queue) {
            engine.setGlobalVariable("itf", (Object)"queue");
        } else if (itfType == JoramElements.user) {
            engine.setGlobalVariable("itf", (Object)"user");
        }
        engine.setGlobalVariable("c", (Object)nf.createComponentNode(server));
        try {
            Set res = (Set)engine.execute("$c/child::$name/interface::$itf");
            if (res.isEmpty()) {
                return null;
            }
            return ((InterfaceNode)res.iterator().next()).getInterface();
        }
        catch (FScriptException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initServerConfig() throws NoSuchInterfaceException, AdminException, NoSuchAttributeException {
        this.serverConfig = new Properties();
        Component server = this.getGatewayServer();
        String serverHost = FractalUtil.getGenericAttributeController((Component)server).getAttribute("host");
        if (serverHost.contains("_")) {
            serverHost = serverHost.split("_")[0];
        }
        this.serverConfig.put("hostName", serverHost);
        this.serverConfig.put("port", (Object)(16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"))));
        this.serverConfig.put("sid", FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"));
        this.serverConfig.put("userAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("userAdmin"));
        this.serverConfig.put("passAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("passAdmin"));
    }

    public abstract String _super_getAttribute(String var1) throws NoSuchAttributeException;

    public abstract String[] _super_listFcAtt();

    public abstract void _super_setAttribute(String var1, String var2) throws NoSuchAttributeException;

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

