/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.control.lifecycle.server;

import fr.dyade.aaa.agent.AgentServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fscript.FScript;
import org.objectweb.fractal.fscript.FScriptEngine;
import org.objectweb.fractal.fscript.FScriptException;
import org.objectweb.fractal.fscript.model.Node;
import org.objectweb.fractal.fscript.model.fractal.ComponentNode;
import org.objectweb.fractal.fscript.model.fractal.NodeFactory;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;

public abstract class JoramServerLifeCycleControllerMixin
implements LifeCycleController {
    private String hostName;
    private String a3File;
    private boolean root;
    private final String SERVER_PREFIX = "JoramServer_";
    private final int PORT_NUMBER_START = 16020;
    private final String STORAGE_DIR_PATH_PREFIX = "/tmp/S";
    private boolean started = false;
    public Component _this_weaveableC;

    private String getAttribute(String attName) {
        try {
            GenericAttributeController gac = (GenericAttributeController)this._this_weaveableC.getFcInterface("generic-attribute-controller");
            return gac.getAttribute(attName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writeConfigFileBeginning() {
        try {
            boolean persistence = Boolean.parseBoolean(this.getAttribute("persistence"));
            String transaction = "";
            transaction = persistence ? "fr.dyade.aaa.util.NTransaction" : "fr.dyade.aaa.util.NullTransaction";
            this.a3File = "<?xml version=\"1.0\"?>\r\n";
            this.a3File = this.a3File + "<config>\r\n";
            this.a3File = this.a3File + "  <property name=\"Transaction\" value=\"" + transaction + "\"/>\r\n";
            this.a3File = this.a3File + "\r\n";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeConfigFileEnding() {
        this.a3File = this.a3File + "</config>";
    }

    private boolean isFirstServer() {
        return this.getGatewayServer() == null;
    }

    private Component getGatewayServer() {
        NodeFactory nf;
        FScriptEngine engine;
        try {
            Component fscript = FScript.newEngine();
            engine = FScript.getFScriptEngine((Component)fscript);
            nf = FScript.getNodeFactory((Component)fscript);
        }
        catch (Exception e1) {
            return null;
        }
        ComponentNode n = nf.createComponentNode(this._this_weaveableC);
        engine.setGlobalVariable("self", (Object)n);
        try {
            Set nodes = (Set)engine.execute("$self/sibling::*[starts-with(name(.), 'JoramServer_')]");
            for (Node node : nodes) {
                try {
                    ComponentNode cnode = (ComponentNode)node;
                    if (Fractal.getNameController((Component)cnode.getComponent()).getFcName().equals("JoramServer_" + this.getAttribute("sid"))) continue;
                    return cnode.getComponent();
                }
                catch (NoSuchInterfaceException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        catch (FScriptException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writea3serverxml() {
        if (!this.isFirstServer()) {
            this.root = false;
            int comPortInDomain = 17000 + Integer.parseInt(this.getAttribute("sid"));
            System.out.println("We have to update the admin module config to add this new server");
            try {
                Component rootServer = this.getGatewayServer();
                Properties gatewayServerConfig = new Properties();
                System.out.println(Fractal.getNameController((Component)rootServer).getFcName() + " is chose as root");
                int gwServerPort = 16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid"));
                String serverHost = FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("host");
                if (serverHost.contains("_")) {
                    serverHost = serverHost.split("_")[0];
                }
                gatewayServerConfig.put("hostName", serverHost);
                gatewayServerConfig.put("port", (Object)gwServerPort);
                gatewayServerConfig.put("sid", FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("sid"));
                gatewayServerConfig.put("userAdmin", FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("userAdmin"));
                gatewayServerConfig.put("passAdmin", FractalUtil.getGenericAttributeController((Component)rootServer).getAttribute("passAdmin"));
                System.out.println(gatewayServerConfig);
                AdminModule.connect(gatewayServerConfig.getProperty("hostName"), gwServerPort, gatewayServerConfig.getProperty("userAdmin"), gatewayServerConfig.getProperty("passAdmin"), 10);
                Integer port = 16020 + Integer.parseInt(this.getAttribute("sid"));
                String[] services = new String[]{"org.objectweb.joram.mom.proxies.tcp.TcpProxyService"};
                String[] args = new String[]{port.toString()};
                AdminModule.addServer(Integer.parseInt(this.getAttribute("sid")), this.hostName, this.getAttribute("domain"), comPortInDomain, "S" + this.getAttribute("sid"), services, args);
                System.out.println(AdminModule.getConfiguration());
                this.updatea3serverxmlFile(AdminModule.getConfiguration());
                AdminModule.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.root = true;
                this.writeConfigFileBeginning();
                this.a3File = this.a3File + this.printServer();
                this.writeConfigFileEnding();
                this.updatea3serverxmlFile(this.a3File);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String printServer() {
        String result = "";
        String sid = this.getAttribute("sid");
        String userAdmin = this.getAttribute("userAdmin");
        int port = 16020 + Integer.parseInt(this.getAttribute("sid"));
        result = result.concat("  <server id=\"" + sid + "\" name=\"" + "S" + this.getAttribute("sid") + "\" hostname=\"" + this.hostName + "\">\r\n");
        result = result.concat("    <service class=\"org.objectweb.joram.mom.proxies.ConnectionManager\"\r\n");
        result = result.concat("             args=\"" + userAdmin + " " + this.getAttribute("passAdmin") + "\"/>\r\n");
        result = result.concat("    <service class=\"org.objectweb.joram.mom.proxies.tcp.TcpProxyService\"\r\n");
        result = result.concat("             args=\"" + port + "\"/>\r\n");
        result = result.concat("  </server>\r\n\r\n");
        return result;
    }

    public String getFcState() {
        return this.started ? "STARTED" : "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            System.out.println("StartFc from Joram server wrapper called ...");
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
            Fractal.getNameController((Component)this._this_weaveableC).setFcName("JoramServer_" + this.getAttribute("sid"));
            this.writea3serverxml();
            String storageDirName = "/tmp/S" + this.getAttribute("sid");
            File storageDir = new File(storageDirName);
            File lockFile = new File(storageDir, "lock");
            lockFile.delete();
            System.out.println("Joram Server sid:" + this.getAttribute("sid") + " starting...");
            AgentServer.init((String[])new String[]{this.getAttribute("sid"), storageDir.getAbsolutePath()});
            AgentServer.start();
            System.out.println("Joram Server sid:" + this.getAttribute("sid") + " [started]");
            this.started = true;
            AdminModule.connect(this.hostName, 16020 + Integer.parseInt(this.getAttribute("sid")), this.getAttribute("userAdmin"), this.getAttribute("passAdmin"), 10);
            System.out.println(AdminModule.getConfiguration());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.root) {
            System.out.println("This server is the first created");
            if (!this.getAttribute("domain").equals("")) {
                System.out.println("A domain has been specified - we have to update the admin module config");
                try {
                    AdminModule.connect(this.getAttribute("hostName"), 16020 + Integer.parseInt(this.getAttribute("sid")), this.getAttribute("userAdmin"), this.getAttribute("passAdmin"), 10);
                    AdminModule.addDomain(this.getAttribute("domain"), Integer.parseInt(this.getAttribute("sid")), 17000 + Integer.parseInt(this.getAttribute("sid")));
                    System.out.println(AdminModule.getConfiguration());
                    this.updatea3serverxmlFile(AdminModule.getConfiguration());
                    AdminModule.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this._super_startFc();
    }

    private void updatea3serverxmlFile(String config) {
        String cfgDir = System.getProperty("fr.dyade.aaa.agent.A3CONF_DIR", AgentServer.DEFAULT_CFG_DIR);
        String cfgFile = System.getProperty("fr.dyade.aaa.agent.A3CONF_FILE", "a3servers.xml");
        File f = new File(cfgDir, cfgFile);
        f.delete();
        try {
            FileOutputStream fout = new FileOutputStream("a3servers.xml");
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter configWriter = new OutputStreamWriter(bout);
            configWriter.write(config);
            configWriter.flush();
            configWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.started = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void _super_startFc() throws IllegalLifeCycleException;
}

