/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.jndi;

import fr.dyade.aaa.agent.AgentServer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.HashSet;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.resources.joram.JndiInterface;

public class Wrapper
implements LifeCycleController,
GenericAttributeController,
BindingController,
JndiInterface {
    private String[] listAtt = new String[]{"jndiPort"};
    private Component myself;
    private boolean started;
    private String hostName;
    private String jndiPort = "16400";
    private String a3File;

    private void generateA3ServerXML() {
        try {
            FileOutputStream fout = new FileOutputStream("a3servers.xml");
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter configWriter = new OutputStreamWriter(bout);
            this.a3File = "<?xml version=\"1.0\"?>\n";
            this.a3File = this.a3File + "<config>" + "\n";
            this.a3File = this.a3File + "<property name=\"Transaction\" value=\"fr.dyade.aaa.util.NullTransaction\"/>\r\n";
            this.a3File = this.a3File + "<server id=\"100\" name=\"S100\" hostname=\"" + this.hostName + "\">" + "\n";
            this.a3File = this.a3File + "<service class=\"fr.dyade.aaa.jndi2.server.JndiServer\" args=\"" + this.jndiPort + "\"/>" + "\n";
            this.a3File = this.a3File + "</server>" + "\n";
            this.a3File = this.a3File + "</config>" + "\n";
            configWriter.write(this.a3File);
            configWriter.flush();
            configWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFcState() {
        return this.started ? "STARTED" : "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        this.started = true;
        try {
            Fractal.getNameController((Component)this.myself).setFcName("JndiRegistry");
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
            this.generateA3ServerXML();
            System.out.println("JNDI server on " + this.hostName + ":" + this.jndiPort + " starting...");
            AgentServer.init((String[])new String[]{"100", "S100"});
            AgentServer.start();
            System.out.println("JNDI server [started]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        this.started = false;
        AgentServer.stop();
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("jndiPort")) {
            return this.jndiPort;
        }
        throw new NoSuchAttributeException(name);
    }

    public String[] listFcAtt() {
        return this.listAtt;
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (!name.equals("jndiPort")) {
            throw new NoSuchAttributeException(name);
        }
        this.jndiPort = value;
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!itfName.equals("component")) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.myself = (Component)itfValue;
    }

    public String[] listFc() {
        HashSet keys = new HashSet();
        return keys.toArray(new String[keys.size()]);
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("component")) {
            return this.myself;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!itfName.equals("component")) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.myself = null;
    }

    public String getHost() {
        return this.hostName;
    }

    public String getPort() {
        return this.jndiPort;
    }
}

