/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.queue;

import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.JndiInterface;
import org.ow2.jasmine.jade.resources.joram.QueueInterface;
import org.ow2.jasmine.jade.wrapper.joram.WrapperUtil;

public class Wrapper
extends WrapperUtil
implements QueueInterface,
BindingController,
GenericAttributeController,
LifeCycleController {
    private String[] listAtt = new String[]{"threshold", "writers", "readers", "period", "producThreshold", "consumThreshold", "autoEvalThreshold", "waitAfterClusterReq", "jndi"};
    private String threshold = "";
    private String writers = "";
    private String readers = "";
    private String period = "100";
    private String producThreshold = "25";
    private String consumThreshold = "2";
    private String autoEvalThreshold = "true";
    private String waitAfterClusterReq = "100";
    private String jndi = "no";
    private final String CLASS_NAME = "org.objectweb.joram.mom.dest.ClusterQueue";
    private Queue myQueue;
    private boolean started;
    private Properties serverConfig;
    private Context context;

    public Queue getQueue() {
        return this.myQueue;
    }

    private void initializeContext() {
        JndiInterface jndiItf = null;
        try {
            jndiItf = (JndiInterface)Fractal.getBindingController((Component)this.getServerComponent()).lookupFc("jndi");
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        catch (AdminException e1) {
            e1.printStackTrace();
        }
        System.out.println("JNDI: Host " + jndiItf.getHost() + " Port " + jndiItf.getPort());
        Properties jndiprops = new Properties();
        jndiprops.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
        jndiprops.setProperty("java.naming.factory.host", jndiItf.getHost());
        jndiprops.setProperty("java.naming.factory.port", jndiItf.getPort());
        Thread ct = Thread.currentThread();
        ClassLoader cl = ct.getContextClassLoader();
        ct.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.context = new InitialContext(jndiprops);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        ct.setContextClassLoader(cl);
    }

    private void initServerConfig() throws NoSuchInterfaceException, AdminException, NoSuchAttributeException {
        this.serverConfig = new Properties();
        Component server = this.getServerComponent();
        String serverHost = FractalUtil.getGenericAttributeController((Component)server).getAttribute("host");
        if (serverHost.contains("_")) {
            serverHost = serverHost.split("_")[0];
        }
        this.serverConfig.put("hostName", serverHost);
        this.serverConfig.put("port", (Object)(16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"))));
        this.serverConfig.put("sid", FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"));
        this.serverConfig.put("userAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("userAdmin"));
        this.serverConfig.put("passAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("passAdmin"));
    }

    private void setAccessRights() throws Exception {
        String token;
        StringTokenizer st = new StringTokenizer(this.writers);
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("all")) {
                this.myQueue.setFreeWriting();
                continue;
            }
            this.myQueue.setWriter(this.getUserInterfaceFromName(token).getUser());
        }
        st = new StringTokenizer(this.readers);
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("all")) {
                this.myQueue.setFreeReading();
                continue;
            }
            this.myQueue.setReader(this.getUserInterfaceFromName(token).getUser());
        }
    }

    public void setProperties() throws JadeException {
        if (this.jndi.equals("yes")) {
            this.initializeContext();
            try {
                this.context.bind(Fractal.getNameController((Component)this.myself).getFcName(), (Object)this.myQueue);
                System.out.println("Queue " + Fractal.getNameController((Component)this.myself).getFcName() + " bound in Jndi context");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JadeException("", e);
            }
        }
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!itfName.equals("component")) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.myself = (Component)itfValue;
    }

    public String[] listFc() {
        HashSet keys = new HashSet();
        return keys.toArray(new String[keys.size()]);
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("component")) {
            return this.myself;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (!itfName.equals("component")) {
            throw new NoSuchInterfaceException(itfName);
        }
        this.myself = null;
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("threshold")) {
            return this.threshold;
        }
        if (name.equals("readers")) {
            return this.readers;
        }
        if (name.equals("writers")) {
            return this.writers;
        }
        if (name.equals("jndi")) {
            return this.jndi;
        }
        if (name.equals("period")) {
            return this.period;
        }
        if (name.equals("producThreshold")) {
            return this.producThreshold;
        }
        if (name.equals("consumThreshold")) {
            return this.consumThreshold;
        }
        if (name.equals("autoEvalThreshold")) {
            return this.autoEvalThreshold;
        }
        if (name.equals("waitAfterClusterReq")) {
            return this.waitAfterClusterReq;
        }
        throw new NoSuchAttributeException(name);
    }

    public String[] listFcAtt() {
        return this.listAtt;
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.equals("threshold")) {
            if (!value.equals("")) {
                this.threshold = value;
            }
        } else if (name.equals("readers")) {
            this.readers = value;
        } else if (name.equals("writers")) {
            this.writers = value;
        } else if (name.equals("jndi")) {
            this.jndi = value;
        } else if (name.equals("period")) {
            this.period = value;
        } else if (name.equals("producThreshold")) {
            this.producThreshold = value;
        } else if (name.equals("consumThreshold")) {
            this.consumThreshold = value;
        } else if (name.equals("autoEvalThreshold")) {
            this.autoEvalThreshold = value;
        } else if (name.equals("waitAfterClusterReq")) {
            this.waitAfterClusterReq = value;
        } else {
            throw new NoSuchAttributeException(name);
        }
    }

    public String getFcState() {
        return this.started ? "STARTED" : "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.initServerConfig();
            Properties queueProp = new Properties();
            queueProp.setProperty("period", this.period);
            queueProp.setProperty("producThreshold", this.producThreshold);
            queueProp.setProperty("consumThreshold", this.consumThreshold);
            queueProp.setProperty("autoEvalThreshold", this.autoEvalThreshold);
            queueProp.setProperty("waitAfterClusterReq", this.waitAfterClusterReq);
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
            AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
            this.myQueue = Queue.create((int)Integer.parseInt(this.serverConfig.getProperty("sid")), (String)Fractal.getNameController((Component)this.myself).getFcName(), (String)"org.objectweb.joram.mom.dest.ClusterQueue", (Properties)queueProp);
            System.out.println("Queue properties" + queueProp.toString());
            this.setAccessRights();
            if (!this.threshold.equals("")) {
                this.myQueue.setThreshold(Integer.parseInt(this.threshold));
            }
            AdminModule.disconnect();
            this.started = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), Integer.parseInt(this.serverConfig.getProperty("port")));
            AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
            this.myQueue.delete();
            AdminModule.disconnect();
            System.out.println("Queue " + Fractal.getNameController((Component)this.myself).getFcName() + " deleted (Joram level)");
            if (this.jndi.equals("yes")) {
                this.context.unbind(Fractal.getNameController((Component)this.myself).getFcName());
                System.out.println("Queue " + Fractal.getNameController((Component)this.myself).getFcName() + " unbound from Jndi context");
            }
            this.started = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.myQueue = null;
    }

    public String getMyServerSID() {
        if (this.serverConfig == null) {
            try {
                this.initServerConfig();
            }
            catch (NoSuchInterfaceException e) {
                e.printStackTrace();
            }
            catch (AdminException e) {
                e.printStackTrace();
            }
            catch (NoSuchAttributeException e) {
                e.printStackTrace();
            }
        }
        return this.serverConfig.getProperty("sid");
    }
}

