/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.joram.topic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.resources.joram.JndiInterface;
import org.ow2.jasmine.jade.resources.joram.TopicInterface;
import org.ow2.jasmine.jade.wrapper.joram.WrapperUtil;

public class Wrapper
extends WrapperUtil
implements TopicInterface,
BindingController,
GenericAttributeController,
LifeCycleController {
    private String[] listAtt = new String[]{"readers", "writers", "jndi"};
    private Topic myTopic;
    private TopicInterface parentRef = null;
    private Hashtable<String, TopicInterface> childRef = new Hashtable();
    private final String PARENT_PREFIX = "parent";
    private Properties serverConfig;
    private String writers = "";
    private String readers = "";
    private String jndi = "no";
    private boolean started;
    private Context context;

    private void initializeContext() {
        JndiInterface jndiItf = null;
        try {
            jndiItf = (JndiInterface)Fractal.getBindingController((Component)this.getServerComponent()).lookupFc("jndi");
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        catch (AdminException e1) {
            e1.printStackTrace();
        }
        System.out.println("JNDI: Host " + jndiItf.getHost() + " Port " + jndiItf.getPort());
        Properties jndiprops = new Properties();
        jndiprops.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
        jndiprops.setProperty("java.naming.factory.host", jndiItf.getHost());
        jndiprops.setProperty("java.naming.factory.port", jndiItf.getPort());
        Thread ct = Thread.currentThread();
        ClassLoader cl = ct.getContextClassLoader();
        ct.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.context = new InitialContext(jndiprops);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        ct.setContextClassLoader(cl);
    }

    public Topic getTopic() {
        return this.myTopic;
    }

    private void setAccessRights() throws Exception {
        String token;
        StringTokenizer st = new StringTokenizer(this.writers);
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("all")) {
                this.myTopic.setFreeWriting();
                continue;
            }
            this.myTopic.setWriter(this.getUserInterfaceFromName(token).getUser());
        }
        st = new StringTokenizer(this.readers);
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("all")) {
                this.myTopic.setFreeReading();
                continue;
            }
            this.myTopic.setReader(this.getUserInterfaceFromName(token).getUser());
        }
    }

    public void setProperties() throws JadeException {
        if (this.jndi.equals("yes")) {
            this.initializeContext();
            try {
                this.context.bind(Fractal.getNameController((Component)this.myself).getFcName(), (Object)this.myTopic);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (NoSuchInterfaceException e) {
                e.printStackTrace();
            }
        }
    }

    private void bindParentJoram() throws JadeException {
        if (this.parentRef != null) {
            try {
                TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
                AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
                Topic t = this.parentRef.getTopic();
                this.myTopic.setParent(t);
                System.out.println("Parent " + this.parentRef.getTopic().getName() + " setted for " + Fractal.getNameController((Component)this.myself).getFcName() + " in startParent");
                this.parentRef.setChildInHierarchy(Fractal.getNameController((Component)this.myself).getFcName(), (TopicInterface)this.myself.getFcInterface("topic"));
                AdminModule.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JadeException("Unable to set the parent " + this.parentRef.getTopic().getName() + " for " + this.myTopic.getName(), e);
            }
        }
    }

    private void unbindParentJoram() throws JadeException {
        try {
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
            AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
            this.myTopic.unsetParent();
            AdminModule.disconnect();
            System.out.println(Fractal.getNameController((Component)this.myself).getFcName() + " has removed its parent (Joram level)");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JadeException("Unable to remove the parent");
        }
    }

    private void initServerConfig() throws NoSuchInterfaceException, AdminException, NoSuchAttributeException {
        this.serverConfig = new Properties();
        Component server = this.getServerComponent();
        String serverHost = FractalUtil.getGenericAttributeController((Component)server).getAttribute("host");
        if (serverHost.contains("_")) {
            serverHost = serverHost.split("_")[0];
        }
        this.serverConfig.put("hostName", serverHost);
        this.serverConfig.put("port", (Object)(16020 + Integer.parseInt(FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"))));
        this.serverConfig.put("sid", FractalUtil.getGenericAttributeController((Component)server).getAttribute("sid"));
        this.serverConfig.put("userAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("userAdmin"));
        this.serverConfig.put("passAdmin", FractalUtil.getGenericAttributeController((Component)server).getAttribute("passAdmin"));
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.initServerConfig();
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
            AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
            this.myTopic = Topic.create((int)Integer.parseInt(this.serverConfig.getProperty("sid")), (String)Fractal.getNameController((Component)this.myself).getFcName());
            System.out.println("Topic " + Fractal.getNameController((Component)this.myself).getFcName() + " created (Joram level)");
            this.setAccessRights();
            AdminModule.disconnect();
            this.started = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalLifeCycleException("Error while starting the service");
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            System.out.println("Topic " + Fractal.getNameController((Component)this.myself).getFcName() + " stopping");
            TopicConnectionFactory con = TopicTcpConnectionFactory.create(this.serverConfig.getProperty("hostName"), 16020 + Integer.parseInt(this.serverConfig.getProperty("sid")));
            this.unbindFc("parent");
            Enumeration<TopicInterface> children = this.childRef.elements();
            while (children.hasMoreElements()) {
                TopicInterface ti = children.nextElement();
                ti.unsetParent();
            }
            AdminModule.connect(con, this.serverConfig.getProperty("userAdmin"), this.serverConfig.getProperty("passAdmin"));
            this.myTopic.delete();
            AdminModule.disconnect();
            if (this.jndi.equals("yes")) {
                this.context.unbind(Fractal.getNameController((Component)this.myself).getFcName());
                System.out.println("Topic " + Fractal.getNameController((Component)this.myself).getFcName() + " unbinded from Jndi context");
            }
            this.started = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalLifeCycleException("Error while stopping the service");
        }
        this.myTopic = null;
    }

    public void unsetParent() {
        if (this.parentRef != null) {
            try {
                this.parentRef = null;
                System.out.println(Fractal.getNameController((Component)this.myself).getFcName() + " has unbound its parent (Fractal level)");
                try {
                    this.unbindParentJoram();
                }
                catch (JadeException e) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchInterfaceException e1) {
                e1.printStackTrace();
            }
        }
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("readers")) {
            return this.readers;
        }
        if (name.equals("writers")) {
            return this.writers;
        }
        if (name.equals("jndi")) {
            return this.jndi;
        }
        throw new NoSuchAttributeException(name);
    }

    public String[] listFcAtt() {
        return this.listAtt;
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.equals("readers")) {
            this.readers = value;
        } else if (name.equals("writers")) {
            this.writers = value;
        } else if (name.equals("jndi")) {
            this.jndi = value;
        } else {
            throw new NoSuchAttributeException(name);
        }
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("parent")) {
            this.parentRef = (TopicInterface)itfValue;
            System.out.println("ParentRef binded for " + Fractal.getNameController((Component)this.myself).getFcName());
            try {
                this.bindParentJoram();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        } else if (itfName.equals("component")) {
            this.myself = (Component)itfValue;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public String[] listFc() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("parent");
        return keys.toArray(new String[keys.size()]);
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("parent")) {
            return this.parentRef;
        }
        if (itfName.equals("component")) {
            return this.myself;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("parent")) {
            if (this.parentRef != null) {
                this.parentRef.unsetChildInHierarchy(Fractal.getNameController((Component)this.myself).getFcName());
                this.parentRef = null;
                System.out.println(Fractal.getNameController((Component)this.myself).getFcName() + " has unbound its parent (Fractal level)");
                try {
                    this.unbindParentJoram();
                }
                catch (JadeException e) {
                    e.printStackTrace();
                }
            }
        } else if (itfName.equals("component")) {
            this.myself = null;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void setChildInHierarchy(String topicName, TopicInterface ti) {
        this.childRef.put(topicName, ti);
    }

    public void unsetChildInHierarchy(String topicName) {
        this.childRef.remove(topicName);
        try {
            System.out.println(Fractal.getNameController((Component)this.myself).getFcName() + " has removed " + topicName + " reference from its sons");
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
    }

    public String getFcState() {
        return this.started ? "STARTED" : "STOPPED";
    }
}

