/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.apache.launcher;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.jasmine.configurator.Configurator;
import org.objectweb.jasmine.launcher.DisplayThread;
import org.objectweb.jasmine.launcher.LaunchException;
import org.objectweb.jasmine.launcher.Launcher;

public class LauncherApacheImpl
implements Launcher {
    static Logger logger = Logger.getLogger(LauncherApacheImpl.class.getName());
    private Configurator configurator;
    ApacheThread apacheThread = null;
    private Boolean started = false;

    public LauncherApacheImpl(Configurator configurator) {
        logger.setLevel(Level.INFO);
        this.configurator = configurator;
    }

    public void configure() throws LaunchException {
    }

    public void start() throws LaunchException {
        if (this.apacheThread == null) {
            this.apacheThread = new ApacheThread();
        }
        this.apacheThread.start();
    }

    public void stop() throws LaunchException {
        System.out.println("Stop APACHE");
        Runtime r = Runtime.getRuntime();
        try {
            StringBuffer command = new StringBuffer(this.configurator.getProperty("instance-apache-home") + "/bin/apachectl stop");
            if (Integer.parseInt(this.configurator.getProperty("server-listen-port").toString()) < 1024) {
                command.insert(0, "sudo ");
            }
            Process s = r.exec(command.toString());
            s.waitFor();
            if (this.apacheThread != null) {
                this.apacheThread.stopMe();
                this.apacheThread.join();
                this.apacheThread = null;
            }
            this.setStarted(false);
        }
        catch (Exception e) {
            throw new LaunchException((Throwable)e);
        }
    }

    private Boolean isStarted() {
        return this.started;
    }

    private void setStarted(Boolean started) {
        this.started = started;
    }

    protected void finalize() throws Throwable {
        if (this.isStarted().booleanValue()) {
            this.stop();
        }
        super.finalize();
    }

    private class ApacheThread
    extends Thread {
        boolean stop = false;
        Process script;
        DisplayThread edt;
        DisplayThread ndt;

        private ApacheThread() {
        }

        public void run() {
            if (LauncherApacheImpl.this.configurator.getProperty("instance-apache-home") == null) {
                return;
            }
            Runtime r = Runtime.getRuntime();
            try {
                StringBuffer command = new StringBuffer(LauncherApacheImpl.this.configurator.getProperty("instance-apache-home") + "/bin/apachectl start");
                if (Integer.parseInt(LauncherApacheImpl.this.configurator.getProperty("server-listen-port").toString()) < 1024) {
                    command.insert(0, "sudo ");
                }
                this.script = r.exec(command.toString());
                InputStream inputstream = this.script.getInputStream();
                this.ndt = new DisplayThread(inputstream, "[apache http server]");
                this.ndt.start();
                InputStream errorstream = this.script.getErrorStream();
                this.edt = new DisplayThread(errorstream, "[apache http server]");
                this.edt.start();
                this.script.waitFor();
                LauncherApacheImpl.this.setStarted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void stopMe() {
            this.stop = true;
            if (this.edt != null) {
                this.edt.setStopped(true);
            }
            if (this.ndt != null) {
                this.ndt.setStopped(true);
            }
            if (this.script != null) {
                this.script.destroy();
            }
        }
    }
}

