/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TopologyBean.java 2560 2008-10-10 12:13:01Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;

/**
 * Bean that represents a topology of servers
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
@Entity(name = "JaDOrT_TopologyBean")
public class TopologyBean implements Serializable {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = 7176306212817449305L;

    /**
     * Auto-generated identifier of the TopologyBean in the database.
     */
    @Id
    @GeneratedValue
    private Integer id;

    /**
     * Servers groups that compose the topology.
     */
    @OneToMany(cascade = CascadeType.ALL)
    private List<GroupBean> groups;

    /**
     * Get the id
     * 
     * @return the id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     * Set the id
     * 
     * @param id the id
     */
    public void setId(final Integer id) {
        this.id = id;
    }

    /**
     * Get the groups
     * 
     * @return the groups
     */
    public List<GroupBean> getGroups() {
        if (this.groups != null) {
            return new ArrayList<GroupBean>(this.groups);
        } else {
            return null;
        }
    }

    /**
     * Set the groups
     * 
     * @param groups The groups list to set
     */
    public void setGroups(final List<GroupBean> groups) {
        this.groups = groups;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[groups='");
        sb.append(this.groups);
        sb.append("']");
        return sb.toString();
    }

    /**
     * {@inheritDoc}
     * 
     * @return true if <code>obj</code> is a {@link TopologyBean} and the
     *         {@link TopologyBean#getId()} is the same for both objects, false
     *         otherwise.
     */
    @Override
    public boolean equals(final Object obj) {
        if (obj != null && obj instanceof TopologyBean) {
            TopologyBean other = (TopologyBean) obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }

        // Else not same type or some parts are null
        return false;
    }

}
