/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;

@Entity(name="JaDOrT_WorkerProgressBean")
public class WorkerProgressBean
implements Serializable {
    private static final long serialVersionUID = -2851071984012556925L;
    @Id
    @GeneratedValue
    private Integer id;
    @Version
    private Integer version;
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private WorkerBean worker;
    private int progress = 0;
    private String log;
    private WorkerProgressState workerProgressState;
    private OperationStateBean.ActionState actionState = OperationStateBean.ActionState.WAITING;

    public WorkerProgressBean() {
        this.workerProgressState = WorkerProgressState.INITIAL;
    }

    public WorkerProgressBean(WorkerBean worker) {
        this();
        this.worker = worker;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public WorkerBean getWorker() {
        return this.worker;
    }

    public void setWorker(WorkerBean worker) {
        this.worker = worker;
    }

    public String getWorkerName() {
        return this.worker.getName();
    }

    public String getState() {
        if (this.actionState.equals(OperationStateBean.ActionState.WAITING)) {
            return "Waiting";
        }
        if (this.actionState.equals(OperationStateBean.ActionState.RUNNING)) {
            return "Running";
        }
        if (this.actionState.equals(OperationStateBean.ActionState.FINISHED_OK)) {
            return "Done OK";
        }
        if (this.actionState.equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
            return "Error !";
        }
        return null;
    }

    public void setState(String state) {
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("Progress is a percentage (between 0 and 100)");
        }
        this.progress = progress;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void appendToLog(String string) {
        if (string != null && string.length() > 0) {
            this.log = this.log == null ? string : this.log + '\n' + string;
        }
    }

    public WorkerProgressState getWorkerProgressState() {
        return this.workerProgressState;
    }

    public void setWorkerProgressState(WorkerProgressState workerProgressState) {
        this.workerProgressState = workerProgressState;
    }

    public OperationStateBean.ActionState getActionState() {
        return this.actionState;
    }

    public void setActionState(OperationStateBean.ActionState actionState) {
        this.actionState = actionState;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[worker='");
        sb.append(this.worker);
        sb.append("']");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof WorkerProgressBean) {
            WorkerProgressBean other = (WorkerProgressBean)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }
        return false;
    }

    public static final class WorkerProgressState
    implements Serializable {
        private static final long serialVersionUID = 2591831000876771633L;
        public static final WorkerProgressState INITIAL = new WorkerProgressState("INITIAL");
        public static final WorkerProgressState START_OK = new WorkerProgressState("START_OK");
        public static final WorkerProgressState STOP_OK = new WorkerProgressState("STOP_OK");
        private static final WorkerProgressState[] values = new WorkerProgressState[]{INITIAL, START_OK, STOP_OK};
        private String workerProgressState;

        private WorkerProgressState(String workerProgressState) {
            this.workerProgressState = workerProgressState;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof WorkerProgressState) {
                WorkerProgressState workerProgressState = (WorkerProgressState)object;
                if (workerProgressState.workerProgressState.equals(this.workerProgressState)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.workerProgressState.hashCode();
        }

        public String toString() {
            return this.workerProgressState;
        }

        public static WorkerProgressState[] values() {
            return values;
        }

        public static WorkerProgressState valueOf(String string) {
            for (WorkerProgressState workerProgressState : values) {
                if (!workerProgressState.workerProgressState.equals(string)) continue;
                return workerProgressState;
            }
            throw new IllegalArgumentException("Unknown value: " + string);
        }
    }
}

