/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GroupBean.java 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;

import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;

/**
 * Bean that represents a group of server (cluster or farm)
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
@Entity(name = "JaDOrT_GroupBean")
public class GroupBean implements Serializable {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -1783631991681445491L;

    /**
     * Auto-generated identifier of the GroupBean in the database.
     */
    @Id
    @GeneratedValue
    private Integer id;

    /**
     * Group name
     */
    private String name;

    /**
     * Whether the group is clustered (i.e. HTTP and EJB sessions are
     * replicated)
     */
    private boolean clustered;

    /**
     * List of servers for this group
     */
    @OneToMany(cascade = CascadeType.ALL)
    private List<ServerBean> servers = new ArrayList<ServerBean>();

    /**
     * List of workers for this group.
     */
    @OneToMany(cascade = CascadeType.ALL)
    private List<WorkerBean> workers = new ArrayList<WorkerBean>();

    /**
     * Application list deployed on the servers of this group
     */
    @OneToMany(cascade = CascadeType.ALL)
    private List<ApplicationBean> applications = new ArrayList<ApplicationBean>();

    /**
     * Get the group id
     * 
     * @return Group id
     */
    public Integer getId() {
        return this.id;
    }

    public void setId(final Integer id) {
        this.id = id;
    }

    /**
     * Get the group name
     * 
     * @return The group name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the group name
     * 
     * @param name New name for the group
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * Get whether the group is clustered (i.e. HTTP and EJB sessions are
     * replicated)
     * 
     * @return Whether the group is clustered (i.e. HTTP and EJB sessions are
     *         replicated)
     */
    public boolean getClustered() {
        return this.clustered;
    }

    /**
     * Set whether the group is clustered (i.e. HTTP and EJB sessions are
     * replicated)
     * 
     * @param clustered Whether the group is clustered (i.e. HTTP and EJB
     *        sessions are replicated)
     */
    public void setClustered(final boolean clustered) {
        this.clustered = clustered;
    }

    /**
     * Get the servers list for this group
     * 
     * @return The servers list for this group
     */
    public List<ServerBean> getServers() {
        return this.servers;
    }

    /**
     * Set the servers list for this group
     * 
     * @param servers The servers list to set for this group
     */
    public void setServers(final List<ServerBean> servers) {
        this.servers = servers;
    }

    /**
     * Get the workers list for this group
     * 
     * @return Workers list for this group
     */
    public List<WorkerBean> getWorkers() {
        return this.workers;
    }

    /**
     * Set the workers list for this group
     * 
     * @param workers The workers list to set for this group
     */
    public void setWorkers(final List<WorkerBean> workers) {
        this.workers = workers;
    }

    /**
     * Get the applications list for this group
     * 
     * @return The applications list for this group
     */
    public List<ApplicationBean> getApplications() {
        return this.applications;
    }

    /**
     * Set the applications list for this group
     * 
     * @param applications The applications list to set for this group
     */
    public void setApplications(final List<ApplicationBean> applications) {
        this.applications = applications;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[name='");
        sb.append(this.name);
        sb.append("', type='");
        sb.append(this.clustered);
        sb.append("']");
        return sb.toString();
    }

    /**
     * {@inheritDoc}
     * 
     * @return true if <code>obj</code> is a {@link GroupBean} and the
     *         {@link GroupBean#getId()} is the same for both objects, false
     *         otherwise.
     */
    @Override
    public boolean equals(final Object obj) {
        if (obj != null && obj instanceof GroupBean) {
            GroupBean other = (GroupBean) obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }

        // Else not same type or some parts are null
        return false;
    }

}
