/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="JaDOrT_ServerProgressBean")
public class ServerProgressBean
extends ProgressBean<ServerProgressState> {
    private static final long serialVersionUID = -2851071984012556925L;
    @Id
    @GeneratedValue
    private Integer id;
    @Version
    private Integer version;
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private ServerBean server;
    @Lob
    @Basic(fetch=FetchType.EAGER)
    private String log;
    private String oldDeploymentItem;
    private String newDeploymentItem;
    @OneToOne(cascade={CascadeType.ALL})
    private VMImageBean vmImage;
    private ServerProgressState serverProgressState;
    private OperationStateBean.ActionState actionState = OperationStateBean.ActionState.WAITING;
    private int progressPercent = 0;

    public ServerProgressBean() {
        this.serverProgressState = ServerProgressState.INITIAL;
    }

    public ServerProgressBean(ServerBean server) {
        this();
        this.server = server;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ServerBean getServer() {
        return this.server;
    }

    public void setServer(ServerBean server) {
        this.server = server;
    }

    public String getServerName() {
        return this.server.getName();
    }

    @Override
    public String getLog() {
        return this.log;
    }

    @Override
    public void setLog(String log) {
        this.log = log;
    }

    public String getOldDeploymentItem() {
        return this.oldDeploymentItem;
    }

    public void setOldDeploymentItem(String oldDeploymentItem) {
        this.oldDeploymentItem = oldDeploymentItem;
    }

    public String getNewDeploymentItem() {
        return this.newDeploymentItem;
    }

    public void setNewDeploymentItem(String newDeploymentItem) {
        this.newDeploymentItem = newDeploymentItem;
    }

    public boolean hasOldDeploymentItem() {
        return this.oldDeploymentItem != null && !this.oldDeploymentItem.equals(this.newDeploymentItem);
    }

    public VMImageBean getVmImage() {
        return this.vmImage;
    }

    public void setVmImage(VMImageBean vmImage) {
        this.vmImage = vmImage;
    }

    @Override
    public ServerProgressState getProgressState() {
        return this.serverProgressState;
    }

    @Override
    public void setProgressState(ServerProgressState serverProgressState) {
        this.serverProgressState = serverProgressState;
    }

    @Override
    public OperationStateBean.ActionState getActionState() {
        return this.actionState;
    }

    @Override
    public void setActionState(OperationStateBean.ActionState actionState) {
        this.actionState = actionState;
    }

    @Override
    public int getProgress() {
        return this.progressPercent;
    }

    @Override
    public void setProgress(int progressPercent) {
        if (progressPercent < 0 || progressPercent > 100) {
            throw new IllegalArgumentException("ProgressPercent is a percentage (between 0 and 100)");
        }
        this.progressPercent = progressPercent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[server='");
        sb.append(this.server);
        sb.append("']");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ServerProgressBean) {
            ServerProgressBean other = (ServerProgressBean)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }
        return false;
    }
}

