/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkerProgressState.java 3492 2009-04-21 10:16:12Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

/**
 * Different possible progress states of a {@link WorkerProgressBean}.
 */
public class WorkerProgressState extends ProgressState {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = 7204146304091547351L;

    public static final WorkerProgressState INITIAL = new WorkerProgressState("INITIAL");

    public static final WorkerProgressState START_OK = new WorkerProgressState("START_OK");

    public static final WorkerProgressState STOP_OK = new WorkerProgressState("STOP_OK");

    private static final WorkerProgressState[] values = new WorkerProgressState[] {WorkerProgressState.INITIAL,
        WorkerProgressState.START_OK, WorkerProgressState.STOP_OK};

    private String workerProgressState;

    /**
     * @param workerProgressState WorkerProgressState.
     */
    private WorkerProgressState(final String workerProgressState) {
        this.workerProgressState = workerProgressState;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(final Object object) {
        if ((object != null) && (object instanceof WorkerProgressState)) {
            WorkerProgressState workerProgressState = (WorkerProgressState) object;
            if (workerProgressState.workerProgressState.equals(this.workerProgressState)) {
                return true;
            }
        }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        return this.workerProgressState.hashCode();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.workerProgressState;
    }

    /**
     * @return All WorkerProgressState values.
     */
    public static WorkerProgressState[] values() {
        return WorkerProgressState.values;
    }

    /**
     * Get the WorkerProgressState for a string.
     * 
     * @param string WorkerProgressState string.
     * @return WorkerProgressState for that string.
     */
    public static WorkerProgressState valueOf(final String string) {
        for (WorkerProgressState workerProgressState : WorkerProgressState.values) {
            if (workerProgressState.workerProgressState.equals(string)) {
                return workerProgressState;
            }
        }

        throw new IllegalArgumentException("Unknown value: " + string);
    }

}
