/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressState;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.TopologyBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationStateBean
implements Serializable {
    private static final long serialVersionUID = -4060088928914512618L;
    private Integer id;
    private Integer version;
    private Date date;
    private String name;
    private TopologyBean topology;
    private List<ServerProgressBean> serverProgressList;
    private List<WorkerProgressBean> workerProgressList;
    private Set<ServerProgressBean> allServerProgressList;
    private Set<WorkerProgressBean> allWorkerProgressList;
    private ApplicationBean application;
    private VMImageBean vmImage;
    private ServerProgressState aimedServerProgressState = ServerProgressState.INITIAL;
    private WorkerProgressState aimedWorkerProgressState = WorkerProgressState.INITIAL;
    private int aimedProgressPercent = 0;
    private Step currentStep = Step.INITIALIZE_TOPOLOGY;
    private boolean canGoToNextStep;
    private boolean canGoToPreviousStep;
    private GroupBean selectedGroup;
    private IJadortService.OperationType type;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ServerProgressState getAimedServerProgressState() {
        return this.aimedServerProgressState;
    }

    public void setAimedServerProgressState(ServerProgressState globalServerProgressState) {
        this.aimedServerProgressState = globalServerProgressState;
    }

    public int getAimedProgressPercent() {
        return this.aimedProgressPercent;
    }

    public void setAimedProgressPercent(int aimedProgressPercent) {
        if (aimedProgressPercent < 0 || aimedProgressPercent > 100) {
            throw new IllegalArgumentException("AimedProgressPercent is a percentage (between 0 and 100)");
        }
        this.aimedProgressPercent = aimedProgressPercent;
    }

    public Step getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(Step step) throws IllegalArgumentException {
        if (Step.SELECT_OPERATION.equals(step)) {
            throw new IllegalArgumentException("You cannot set a real operation's step to " + Step.SELECT_OPERATION);
        }
        this.currentStep = step;
    }

    public boolean getCanGoToNextStep() {
        return this.canGoToNextStep;
    }

    public void setCanGoToNextStep(boolean canGoToNextStep) {
        this.canGoToNextStep = canGoToNextStep;
    }

    public boolean getCanGoToPreviousStep() {
        return this.canGoToPreviousStep;
    }

    public void setCanGoToPreviousStep(boolean canGoToPreviousStep) {
        this.canGoToPreviousStep = canGoToPreviousStep;
    }

    public GroupBean getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(GroupBean selectedGroup) {
        this.selectedGroup = selectedGroup;
    }

    public TopologyBean getTopology() {
        return this.topology;
    }

    public void setTopology(TopologyBean topology) {
        this.topology = topology;
    }

    public List<ServerProgressBean> getServerProgressList() {
        return this.serverProgressList;
    }

    public void setServerProgressList(List<ServerProgressBean> serverProgressList) {
        this.serverProgressList = serverProgressList;
    }

    public IJadortService.OperationType getType() {
        return this.type;
    }

    public void setType(IJadortService.OperationType type) {
        this.type = type;
    }

    public List<WorkerProgressBean> getWorkerProgressList() {
        return this.workerProgressList;
    }

    public void setWorkerProgressList(List<WorkerProgressBean> workerProgressList) {
        this.workerProgressList = workerProgressList;
    }

    public WorkerProgressState getAimedWorkerProgressState() {
        return this.aimedWorkerProgressState;
    }

    public void setAimedWorkerProgressState(WorkerProgressState aimedWorkerProgressState) {
        this.aimedWorkerProgressState = aimedWorkerProgressState;
    }

    public Set<ServerProgressBean> getAllServerProgressList() {
        return this.allServerProgressList;
    }

    public void setAllServerProgressList(Set<ServerProgressBean> allServerProgressList) {
        this.allServerProgressList = allServerProgressList;
    }

    public void addAllServerProgressList(Collection<ServerProgressBean> serverProgressListToAdd) {
        if (this.allServerProgressList == null) {
            this.allServerProgressList = new HashSet<ServerProgressBean>(serverProgressListToAdd);
        } else {
            this.allServerProgressList.addAll(serverProgressListToAdd);
        }
    }

    public void addAllServerProgressList(ServerProgressBean serverProgressToAdd) {
        if (this.allServerProgressList == null) {
            this.allServerProgressList = new HashSet<ServerProgressBean>(1);
        }
        this.allServerProgressList.add(serverProgressToAdd);
    }

    public Set<WorkerProgressBean> getAllWorkerProgressList() {
        return this.allWorkerProgressList;
    }

    public void setAllWorkerProgressList(Set<WorkerProgressBean> allWorkerProgressList) {
        this.allWorkerProgressList = allWorkerProgressList;
    }

    public void addAllWorkerProgressList(Collection<WorkerProgressBean> workerProgressListToAdd) {
        if (this.allWorkerProgressList == null) {
            this.allWorkerProgressList = new HashSet<WorkerProgressBean>(workerProgressListToAdd);
        } else {
            this.allWorkerProgressList.addAll(workerProgressListToAdd);
        }
    }

    public void addAllWorkerProgressList(WorkerProgressBean workerProgressToAdd) {
        if (this.allWorkerProgressList == null) {
            this.allWorkerProgressList = new HashSet<WorkerProgressBean>(1);
        }
        this.allWorkerProgressList.add(workerProgressToAdd);
    }

    public ApplicationBean getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationBean application) {
        this.application = application;
    }

    public VMImageBean getVmImage() {
        return this.vmImage;
    }

    public void setVmImage(VMImageBean vmImage) {
        this.vmImage = vmImage;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[aimedServerProgressState='");
        sb.append(this.aimedServerProgressState);
        sb.append("', currentStep='");
        sb.append(this.currentStep);
        sb.append("']");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof OperationStateBean) {
            OperationStateBean other = (OperationStateBean)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }
        return false;
    }

    public boolean getIsDeletable() {
        return !this.currentStep.equals(Step.EXECUTING_MIGRATION) && !this.currentStep.equals(Step.UNDEPLOY_ERASE_OLD_VERSION) && !this.currentStep.equals(Step.EXECUTING_MIGRATION_OSGI) && !this.currentStep.equals(Step.ERASE_OLD_VERSIONS) && !this.currentStep.equals(Step.SELECT_SERVERS) && !this.currentStep.equals(Step.SELECT_VM_IMAGE_FOR_SERVER) && !this.currentStep.equals(Step.EXECUTING_MAINTENANCE_CLUSTER) && !this.currentStep.equals(Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
    }

    public static final class ActionState
    implements Serializable {
        private static final long serialVersionUID = -4302491945199396705L;
        public static final ActionState WAITING = new ActionState("WAITING");
        public static final ActionState RUNNING = new ActionState("RUNNING");
        public static final ActionState FINISHED_OK = new ActionState("FINISHED_OK");
        public static final ActionState FINISHED_ERROR = new ActionState("FINISHED_ERROR");
        private static final ActionState[] values = new ActionState[]{WAITING, RUNNING, FINISHED_OK, FINISHED_ERROR};
        private String actionState;

        private ActionState(String actionState) {
            this.actionState = actionState;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof ActionState) {
                ActionState actionState = (ActionState)object;
                if (actionState.actionState.equals(this.actionState)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.actionState.hashCode();
        }

        public String toString() {
            return this.actionState;
        }

        public static ActionState[] values() {
            return values;
        }

        public static ActionState valueOf(String string) {
            for (ActionState actionState : values) {
                if (!actionState.actionState.equals(string)) continue;
                return actionState;
            }
            throw new IllegalArgumentException("Unknown value: " + string);
        }
    }

    public static final class Step
    implements Serializable {
        private static final long serialVersionUID = 8454822640970419681L;
        public static final Step SELECT_OPERATION = new Step("SELECT_OPERATION");
        public static final Step INITIALIZE_TOPOLOGY = new Step("INITIALIZE_TOPOLOGY");
        public static final Step SELECT_GROUP = new Step("SELECT_GROUP");
        public static final Step SELECT_OPERATION_TYPE = new Step("SELECT_OPERATION_TYPE");
        public static final Step SELECT_VM_IMAGE = new Step("SELECT_VM_IMAGE");
        public static final Step SELECT_APPLICATION = new Step("SELECT_APPLICATION");
        public static final Step EXECUTING_MIGRATION = new Step("EXECUTING_MIGRATION");
        public static final Step UNDEPLOY_ERASE_OLD_VERSION = new Step("UNDEPLOY_ERASE_OLD_VERSION");
        public static final Step EXECUTING_MIGRATION_OSGI = new Step("EXECUTING_MIGRATION_OSGI");
        public static final Step ERASE_OLD_VERSIONS = new Step("ERASE_OLD_VERSIONS");
        public static final Step SELECT_SERVERS = new Step("SELECT_SERVERS");
        public static final Step SELECT_VM_IMAGE_FOR_SERVER = new Step("SELECT_VM_IMAGE_FOR_SERVER");
        public static final Step EXECUTING_MAINTENANCE_CLUSTER = new Step("EXECUTING_MAINTENANCE_CLUSTER");
        public static final Step EXECUTING_MAINTENANCE_NO_CLUSTER = new Step("EXECUTING_MAINTENANCE_NO_CLUSTER");
        public static final Step DESTROY_OLD_VM_HOSTS = new Step("DESTROY_OLD_VM_HOSTS");
        public static final Step FINISHED = new Step("FINISHED");
        private static final Step[] values = new Step[]{SELECT_OPERATION, INITIALIZE_TOPOLOGY, SELECT_GROUP, SELECT_OPERATION_TYPE, SELECT_VM_IMAGE, SELECT_APPLICATION, EXECUTING_MIGRATION, UNDEPLOY_ERASE_OLD_VERSION, EXECUTING_MIGRATION_OSGI, ERASE_OLD_VERSIONS, SELECT_SERVERS, SELECT_VM_IMAGE_FOR_SERVER, EXECUTING_MAINTENANCE_CLUSTER, EXECUTING_MAINTENANCE_NO_CLUSTER, DESTROY_OLD_VM_HOSTS, FINISHED};
        private String step;

        private Step(String step) {
            this.step = step;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Step) {
                Step step = (Step)object;
                if (step.step.equals(this.step)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.step.hashCode();
        }

        public String toString() {
            return this.step;
        }

        public static Step[] values() {
            return values;
        }

        public static Step valueOf(String string) {
            for (Step step : values) {
                if (!step.step.equals(string)) continue;
                return step;
            }
            throw new IllegalArgumentException("Unknown value: " + string);
        }
    }
}

