/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressState;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerProgressBean
extends ProgressBean<WorkerProgressState> {
    private static final long serialVersionUID = -2851071984012556925L;
    private Integer id;
    private Integer version;
    private WorkerBean worker;
    private String log;
    private WorkerProgressState workerProgressState;
    private OperationStateBean.ActionState actionState = OperationStateBean.ActionState.WAITING;
    private int progressPercent = 0;

    public WorkerProgressBean() {
        this.workerProgressState = WorkerProgressState.INITIAL;
    }

    public WorkerProgressBean(WorkerBean worker) {
        this();
        this.worker = worker;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public WorkerBean getWorker() {
        return this.worker;
    }

    public void setWorker(WorkerBean worker) {
        this.worker = worker;
    }

    public String getWorkerName() {
        return this.worker.getName();
    }

    @Override
    public String getLog() {
        return this.log;
    }

    @Override
    public void setLog(String log) {
        this.log = log;
    }

    @Override
    public WorkerProgressState getProgressState() {
        return this.workerProgressState;
    }

    @Override
    public void setProgressState(WorkerProgressState workerProgressState) {
        this.workerProgressState = workerProgressState;
    }

    @Override
    public OperationStateBean.ActionState getActionState() {
        return this.actionState;
    }

    @Override
    public void setActionState(OperationStateBean.ActionState actionState) {
        this.actionState = actionState;
    }

    @Override
    public int getProgress() {
        return this.progressPercent;
    }

    @Override
    public void setProgress(int progressPercent) {
        if (progressPercent < 0 || progressPercent > 100) {
            throw new IllegalArgumentException("ProgressPercent is a percentage (between 0 and 100)");
        }
        this.progressPercent = progressPercent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[worker='");
        sb.append(this.worker);
        sb.append("']");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof WorkerProgressBean) {
            WorkerProgressBean other = (WorkerProgressBean)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }
        return false;
    }
}

