package org.ow2.jasmine.jadort.api.entities.deployment;

import java.io.Serializable;

// import javax.persistence.Entity;
// import javax.persistence.GeneratedValue;
// import javax.persistence.Id;

/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: 
 * --------------------------------------------------------------------------
 */

/**
 * Bean that represents a VM Image.
 * 
 * @author Malek Chahine
 * @author S. Ali Tokmen
 */
// @Entity(name = "JaDOrT_VMImageBean")
public class VMImageBean implements Serializable {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -8995544046252693883L;

    /**
     * Auto-generated identifier of the VMImageBean in the database.
     */
    // @Id
    // @GeneratedValue
    private Integer id;

    /**
     * VM Image name
     */
    private String uuid;

    /**
     * VM Image name
     */
    private String name;

    public VMImageBean() {
        // Used by the EJB3 container
    }

    public VMImageBean(final String name, final String uuid) {
        this.name = name;
        this.uuid = uuid;
    }

    /**
     * Get the VM Image id
     * 
     * @return the application id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     * Set the VM Image id
     * 
     * @param id the VM Image id
     */
    public void setId(final Integer id) {
        this.id = id;
    }

    /**
     * Name getter
     * 
     * @return VM Image name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Name setter
     * 
     * @param name VM Image name
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[name='");
        sb.append(this.name);
        sb.append("']");
        return sb.toString();
    }

    /**
     * {@inheritDoc}
     * 
     * @return true if <code>obj</code> is an {@link VMImageBean} and the
     *         {@link VMImageBean#getUuid()} is the same for both objects, false
     *         otherwise.
     */
    @Override
    public boolean equals(final Object obj) {
        if (obj != null && obj instanceof VMImageBean) {
            VMImageBean other = (VMImageBean) obj;
            if (this.uuid != null && other.uuid != null) {
                return this.uuid.equals(other.uuid);
            }
        }

        // Else not same type or some parts are null
        return false;
    }

    /**
     * get the VM Image uuid
     * 
     * @return VM Image uuid
     */
    public String getUuid() {
        return this.uuid;
    }

    /**
     * set the uuid de VM Image
     * 
     * @param uuid
     */
    public void setUuid(final String uuid) {
        this.uuid = uuid;
    }

}
