/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerBean
implements Serializable {
    private static final long serialVersionUID = -8338670679543686581L;
    private Integer id;
    private String name;
    private Type type;
    private int capacity;
    private ConnectorBean serverConnector;
    private ConnectorBean managerConnector;
    private VMBean vm;
    private ServerBean target;
    private int activeSessions = 0;
    private boolean processed = false;
    private List<ApplicationBean> applications = new ArrayList<ApplicationBean>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = capacity;
    }

    public ConnectorBean getServerConnector() {
        return this.serverConnector;
    }

    public void setServerConnector(ConnectorBean serverConnector) {
        this.serverConnector = serverConnector;
    }

    public ConnectorBean getManagerConnector() {
        return this.managerConnector;
    }

    public void setManagerConnector(ConnectorBean managerConnector) {
        this.managerConnector = managerConnector;
    }

    public int getActiveSessions() {
        return this.activeSessions;
    }

    public void setActiveSessions(int activeSessions) {
        if (activeSessions < 0) {
            throw new IllegalArgumentException("ActiveSessions must be positive");
        }
        this.activeSessions = activeSessions;
    }

    public boolean getProcessed() {
        return this.processed;
    }

    public ServerBean getTarget() {
        return this.target;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setTarget(ServerBean target) {
        this.target = target;
    }

    public VMBean getVm() {
        return this.vm;
    }

    public void setVm(VMBean vm) {
        this.vm = vm;
    }

    public List<ApplicationBean> getApplications() {
        return this.applications;
    }

    public void setApplications(List<ApplicationBean> applications) {
        this.applications = applications;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[name='");
        sb.append(this.name);
        sb.append("', type='");
        sb.append(this.type);
        sb.append("', hasManager='");
        sb.append(this.managerConnector != null);
        sb.append("']");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ServerBean) {
            ServerBean other = (ServerBean)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }
        return false;
    }

    public static final class Type
    implements Serializable {
        private static final long serialVersionUID = 8006861800369211346L;
        public static final Type JONAS = new Type("JONAS");
        public static final Type JBOSS = new Type("JBOSS");
        public static final Type GLASSFISH = new Type("GLASSFISH");
        public static final Type WEBLOGIC = new Type("WEBLOGIC");
        public static final Type WEBSPHERE = new Type("WEBSPHERE");
        public static final Type OSGI = new Type("OSGI");
        public static final Type DUMMY = new Type("DUMMY");
        private static final Type[] values = new Type[]{JONAS, JBOSS, GLASSFISH, WEBLOGIC, WEBSPHERE, OSGI, DUMMY};
        private String type;

        private Type(String type) {
            this.type = type;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Type) {
                Type type = (Type)object;
                if (type.type.equals(this.type)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type;
        }

        public static Type[] values() {
            return values;
        }

        public static Type valueOf(String string) {
            for (Type type : values) {
                if (!type.type.equals(string)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown value: " + string);
        }
    }
}

