/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectorBean.java 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.io.Serializable;

// import javax.persistence.Entity;
// import javax.persistence.GeneratedValue;
// import javax.persistence.Id;

/**
 * Bean that represents a URL-based connector
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
// @Entity(name = "JaDOrT_ConnectorBean")
public class ConnectorBean implements Serializable {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -8493966892797382963L;

    /**
     * Auto-generated identifier of the JMXConnectorBean in the database.
     */
    // @Id
    // @GeneratedValue
    private Integer id;

    /**
     * URL of the connector
     */
    private String connectorUrl;

    /**
     * connector username
     */
    private String username;

    /**
     * connector password
     */
    private String password;

    /**
     * Get the connector id
     * 
     * @return the connector id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     * Set the connector id
     * 
     * @param id the connector id
     */
    public void setId(final Integer id) {
        this.id = id;
    }

    /**
     * Getter of the connector url
     * 
     * @return connector url
     */
    public String getConnectorUrl() {
        return this.connectorUrl;
    }

    /**
     * Setter of the connector url
     * 
     * @param connectorUrl connector url
     */
    public void setConnectorUrl(final String connectorUrl) {
        this.connectorUrl = connectorUrl;
    }

    /**
     * Getter of the username
     * 
     * @return the username
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * Setter of the username
     * 
     * @param username the username
     */
    public void setUsername(final String username) {
        this.username = username;
    }

    /**
     * Getter of the password
     * 
     * @return the password
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * Setter of the password
     * 
     * @param password the password
     */
    public void setPassword(final String password) {
        this.password = password;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[connectorUrl='");
        sb.append(this.connectorUrl);
        sb.append("']");
        return sb.toString();
    }

    /**
     * {@inheritDoc}
     * 
     * @return true if <code>obj</code> is a {@link ConnectorBean} and the
     *         {@link ConnectorBean#getId()} is the same for both objects, false
     *         otherwise.
     */
    @Override
    public boolean equals(final Object obj) {
        if (obj != null && obj instanceof ConnectorBean) {
            ConnectorBean other = (ConnectorBean) obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }

        // Else not same type or some parts are null
        return false;
    }

}
