/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: VMBean.java 3183 2009-03-20 15:06:50Z chahinem $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.io.Serializable;

// import javax.persistence.CascadeType;
// import javax.persistence.Entity;
// import javax.persistence.GeneratedValue;
// import javax.persistence.Id;
// import javax.persistence.OneToOne;

/**
 * Bean represents a VM. In the XSD, each instance of this object is a Balancer.
 * 
 * @author Malek Chahine
 * @author S. Ali Tokmen
 */
// @Entity(name = "JaDOrT_VMBean")
public class VMBean implements Serializable {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -8338670679543686581L;

    /**
     * Auto-generated identifier of the VMBean in the database.
     */
    // @Id
    // @GeneratedValue
    private Integer id;

    /**
     * VM's name
     */
    private String name;

    /**
     * VM name associated with this VM
     */
    private String vmm;

    /**
     * VM connector
     */
    // @OneToOne(cascade = CascadeType.ALL)
    private ConnectorBean connector;

    /**
     * Get the VM id
     * 
     * @return the VM id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     * Set the VM id
     * 
     * @param id the VM id
     */
    public void setId(final Integer id) {
        this.id = id;
    }

    /**
     * Get the VM's name
     * 
     * @return the VM's name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the VM's name
     * 
     * @param name the VM's name
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * Get the VMM connector
     * 
     * @return the VMM connector
     */
    public ConnectorBean getConnector() {
        return this.connector;
    }

    /**
     * Set the VMM connector
     * 
     * @param connector the VMM connector
     */
    public void setConnector(final ConnectorBean connector) {
        this.connector = connector;
    }

    /**
     * Set the VM Manager
     * 
     * @param vmm le VM manager
     */
    public void setVmm(final String vmm) {
        this.vmm = vmm;
    }

    /**
     * get the VM Manager
     */
    public String getVmm() {
        return this.vmm;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[name='");
        sb.append(this.name);
        sb.append("', connector='");
        sb.append(this.connector);
        sb.append("']");
        return sb.toString();
    }

    /**
     * {@inheritDoc}
     * 
     * @return true if <code>obj</code> is a {@link VMBean} and the
     *         {@link VMBean#getId()} is the same for both objects, false
     *         otherwise.
     */
    @Override
    public boolean equals(final Object obj) {
        if (obj != null && obj instanceof VMBean) {
            VMBean other = (VMBean) obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }

        // Else not same type or some parts are null
        return false;
    }

}
