/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.client.console;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadortCommand {
    private IJadortService jadortService;

    public JadortCommand(IJadortService jadortService) {
        this.jadortService = jadortService;
    }

    public OperationStateBean createNewOperation(String newOperationName) throws Exception {
        this.jadortService.createNewOperation(newOperationName);
        return this.jadortService.getCurrentOperation();
    }

    public List<OperationStateBean> getOperationsList() throws Exception {
        return this.jadortService.getOperationsList();
    }

    public void selectOperation(OperationStateBean operation) throws Exception {
        this.jadortService.selectOperation(operation);
    }

    public void deleteOperation(OperationStateBean operation) throws Exception {
        this.jadortService.deleteOperation(operation);
    }

    public void loadTopology(File xmlTopoFile) throws Exception {
        this.jadortService.loadTopology(xmlTopoFile);
        this.jadortService.next();
    }

    public List<GroupBean> getGroups() throws Exception {
        return this.jadortService.getGroups();
    }

    public void selectGroup(GroupBean selectedGroup, IJadortService.OperationType operationType) throws Exception {
        this.jadortService.selectGroup(selectedGroup, operationType);
        this.jadortService.next();
    }

    public void selectServers(List<ServerBean> selectedServers) throws Exception {
        this.jadortService.selectServers(selectedServers);
        this.jadortService.next();
    }

    public GroupBean getSelectedGroup() throws Exception {
        return this.jadortService.getSelectedGroup();
    }

    public Integer getActiveSessions() throws Exception {
        return this.jadortService.getActiveSessions();
    }

    public ApplicationBean createApplication(URL url) throws Exception {
        this.jadortService.createApplication(url);
        ApplicationBean ret = this.jadortService.getApplication();
        this.jadortService.next();
        return ret;
    }

    public OperationStateBean.Step getCurrentStep() throws Exception {
        return this.jadortService.getCurrentStep();
    }

    public boolean canGoToNextStep() throws Exception {
        return this.jadortService.canGoToNextStep();
    }

    public void next() throws Exception {
        this.jadortService.next();
    }

    public boolean canGoToPreviousStep() throws Exception {
        return this.jadortService.canGoToPreviousStep();
    }

    public void previous() throws Exception {
        this.jadortService.previous();
    }

    public List<ServerProgressBean> getServerProgressList() throws Exception {
        return this.jadortService.getServerProgressList();
    }

    public List<WorkerProgressBean> getWorkerProgressList() throws Exception {
        return this.jadortService.getWorkerProgressList();
    }

    public void restartServer(ServerBean server) throws Exception {
        this.jadortService.restartServer(server);
    }

    public void ignoreServer(ServerBean server) throws Exception {
        this.jadortService.ignoreServer(server);
    }

    public boolean checkServer(ServerBean server) throws Exception {
        return this.jadortService.checkServer(server);
    }

    public void restartWorker(WorkerBean worker) throws Exception {
        this.jadortService.restartWorker(worker);
    }

    public void ignoreWorker(WorkerBean worker) throws Exception {
        this.jadortService.ignoreWorker(worker);
    }

    public boolean checkWorker(WorkerBean worker) throws Exception {
        return this.jadortService.checkWorker(worker);
    }
}

