/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.client.console;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.client.console.JadortCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadortConsole {
    private static final String UC_CREATE_NEW_OPERATION = "createNewOperation";
    private static final String UC_GET_OPERATION_LIST = "getOperationsList";
    private static final String UC_DELETE_OPERATION = "deleteOperation";
    private static final String UC_LOAD_TOPOLOGY = "loadTopology";
    private static final String UC_GET_GROUPS = "getGroups";
    private static final String UC_SELECT_GROUP = "selectGroup";
    private static final String UC_SELECT_SERVERS = "selectServers";
    private static final String UC_GET_CURRENT_STEP = "getCurrentStep";
    private static final String UC_CAN_GO_NEXT = "canGoToNextStep";
    private static final String UC_NEXT = "next";
    private static final String UC_CAN_GO_PREVIOUS = "canGoToPreviousStep";
    private static final String UC_PREVIOUS = "previous";
    private static final String UC_GET_SERVER_PROGRESS_LIST = "getServerProgressList";
    private static final String UC_GET_WORKER_PROGRESS_LIST = "getWorkerProgressList";
    private static final String UC_GET_SELECTED_GROUP = "getSelectedGroup";
    private static final String UC_GET_ACTIVE_SESSIONS = "getActiveSessions";
    private static final String UC_RESTART_SERVER = "restartServer";
    private static final String UC_IGNORE_SERVER = "ignoreServer";
    private static final String UC_CHECK_SERVER = "checkServer";
    private static final String UC_RESTART_WORKER = "restartWorker";
    private static final String UC_IGNORE_WORKER = "ignoreWorker";
    private static final String UC_CHECK_WORKER = "checkWorker";
    private static final String UC_CREATE_APPLICATION = "createApplication";
    private static final String CI_CREATE_NEW_OPERATION = "createNewOperation";
    private static final String CI_GET_OPERATION_LIST = "getOperationsList";
    private static final String CI_DELETE_OPERATION = "deleteOperation";
    private static final String CI_LOAD_TOPOLOGY = "loadTopology";
    private static final String CI_GET_GROUPS = "getGroups";
    private static final String CI_SELECT_GROUP = "selectGroup";
    private static final String CI_SELECT_SERVERS = "selectServers";
    private static final String CI_GET_CURRENT_STEP = "getCurrentStep";
    private static final String CI_CAN_GO_NEXT = "canGoToNextStep";
    private static final String CI_NEXT = "next";
    private static final String CI_CAN_GO_PREVIOUS = "canGoToPreviousStep";
    private static final String CI_PREVIOUS = "previous";
    private static final String CI_GET_SERVER_PROGRESS_LIST = "getServerProgressList";
    private static final String CI_GET_WORKER_PROGRESS_LIST = "getWorkerProgressList";
    private static final String CI_GET_SELECTED_GROUP = "getSelectedGroup";
    private static final String CI_GET_ACTIVE_SESSIONS = "getActiveSessions";
    private static final String CI_RESTART_SERVER = "restartServer";
    private static final String CI_IGNORE_SERVER = "ignoreServer";
    private static final String CI_CHECK_SERVER = "checkServer";
    private static final String CI_RESTART_WORKER = "restartWorker";
    private static final String CI_IGNORE_WORKER = "ignoreWorker";
    private static final String CI_CHECK_WORKER = "checkWorker";
    private static final String CI_CREATE_APPLICATION = "createApplication";
    private static Map<String, Class<?>[]> methods = new HashMap<String, Class<?>[]>();
    private static Map<String, Method> commands;
    private static Map<Method, Boolean> methodsNeedOperationNumber;
    public static Map<String, Method> output;

    public static void main(String[] args) {
        try {
            IJadortService iJadort = JadortConsole.initEJBConnection();
            JadortCommand JadortConsoleInterface = new JadortCommand(iJadort);
            CommandArgs commandArgs = JadortConsole.parseForCmd(args, JadortConsoleInterface);
            Method command = commandArgs.getCommand();
            List<Object> arguments = JadortConsole.parseForArgs(commandArgs, JadortConsoleInterface);
            Object resultat = JadortConsole.callRemoteMehod(arguments, command, JadortConsoleInterface);
            Method handler = output.get(command.getName());
            if (handler != null) {
                Object res = handler.invoke(null, resultat);
                JadortConsole.returnValueToConsole(res);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void returnValueToConsole(Object res) {
        int ret = 0;
        if (res != null) {
            if (res instanceof Integer) {
                ret = (Integer)res;
            } else if (res instanceof Boolean) {
                Boolean bRes = (Boolean)res;
                ret = bRes.booleanValue() ? 1 : 0;
            } else if (res instanceof OperationStateBean) {
                ret = ((OperationStateBean)res).getId();
            }
        }
        System.exit(ret);
    }

    private static Object callRemoteMehod(List<Object> arguments, Method cmd, JadortCommand iCommand) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        System.out.println("method = " + cmd);
        System.out.println(arguments.toArray());
        return cmd.invoke((Object)iCommand, arguments.toArray());
    }

    private static IJadortService initEJBConnection() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", MultiOrbInitialContextFactory.class.getName());
        InitialContext context = new InitialContext(env);
        return (IJadortService)context.lookup("ow2.jasmine.jadort.ServiceSFB");
    }

    private static void setSelectedOperation(Integer opID, JadortCommand JadortConsoleInterface) throws Exception {
        OperationStateBean op = JadortConsole.getOperationByID(opID, JadortConsoleInterface);
        if (op != null) {
            JadortConsoleInterface.selectOperation(op);
        } else {
            JadortConsole.usage("Unable to find the operation with " + opID + " as id");
        }
    }

    private static CommandArgs parseForCmd(String[] args, JadortCommand JadortConsoleInterface) throws Exception {
        String userCommand;
        CommandArgs ret = new CommandArgs();
        Method command = null;
        int nbNonArgs = 1;
        if (args.length < nbNonArgs) {
            JadortConsole.usage("No command provided!");
        }
        if ((command = commands.get(userCommand = args[0])) == null) {
            JadortConsole.usage("Unknow command.");
        }
        ret.setCommand(command);
        if (methodsNeedOperationNumber.get(command) != null) {
            if (args.length < ++nbNonArgs) {
                JadortConsole.usage("No operation Id provided. This field is mandatory.");
            }
            try {
                Integer operationId = new Integer(args[1]);
                JadortConsole.setSelectedOperation(operationId, JadortConsoleInterface);
            }
            catch (NumberFormatException e) {
                JadortConsole.usage("Unable to parse " + args[1] + " as operation Id. It must be a Integer");
            }
        }
        ArrayList<String> argsTmp = new ArrayList<String>();
        for (int i = nbNonArgs; i < args.length; ++i) {
            argsTmp.add(args[i]);
        }
        ret.setArgs(argsTmp);
        return ret;
    }

    private static List<Object> parseForArgs(CommandArgs cmdArgs, JadortCommand JadortConsoleInterface) throws Exception {
        ArrayList<Object> ret;
        block19: {
            ret = new ArrayList<Object>();
            Class<?>[] signature = methods.get(cmdArgs.getCommand().getName());
            if (signature.length != cmdArgs.getArgs().size() && !cmdArgs.getCommand().getName().equals("selectServers")) {
                JadortConsole.usage("To much arguments on the command line");
            }
            try {
                if (signature.length <= 0) break block19;
                for (int i = 0; i < signature.length; ++i) {
                    if (signature[i] != String.class) {
                        ServerBean s;
                        if (signature[i] == OperationStateBean.class) {
                            Integer idOp = new Integer(cmdArgs.getArgs().get(i));
                            OperationStateBean op = JadortConsole.getOperationByID(idOp, JadortConsoleInterface);
                            if (op != null) {
                                ret.add(op);
                                continue;
                            }
                            JadortConsole.usage("Unable to find the operation with " + idOp + " as id");
                            continue;
                        }
                        if (signature[i] == URL.class) {
                            URL url;
                            try {
                                url = new URL(cmdArgs.getArgs().get(i));
                            }
                            catch (MalformedURLException e) {
                                url = new File(cmdArgs.getArgs().get(i)).toURI().toURL();
                            }
                            ret.add(url);
                            continue;
                        }
                        if (signature[i] == File.class) {
                            ret.add(new File(cmdArgs.getArgs().get(i)));
                            continue;
                        }
                        if (signature[i] == ServerBean.class) {
                            Integer idServer = new Integer(cmdArgs.getArgs().get(i));
                            s = JadortConsole.getServerByID(idServer, JadortConsole.getServers(JadortConsoleInterface));
                            if (s != null) {
                                ret.add(s);
                                continue;
                            }
                            JadortConsole.usage("Unable to find the server associated with " + idServer + " as id");
                            continue;
                        }
                        if (signature[i] == WorkerBean.class) {
                            Integer idWorker = new Integer(cmdArgs.getArgs().get(i));
                            s = JadortConsole.getWorkerByID(idWorker, JadortConsole.getWorkers(JadortConsoleInterface));
                            if (s != null) {
                                ret.add(s);
                                continue;
                            }
                            JadortConsole.usage("Unable to find the server associated with " + idWorker + " as id");
                            continue;
                        }
                        if (signature[i] == GroupBean.class) {
                            GroupBean group = JadortConsole.getGroupByName(cmdArgs.getArgs().get(i), JadortConsoleInterface);
                            ret.add(group);
                            continue;
                        }
                        if (signature[i] == List.class) {
                            if (!cmdArgs.getCommand().getName().equals("selectServers")) continue;
                            ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
                            while (i < cmdArgs.getArgs().size()) {
                                ServerBean server = JadortConsole.getServerByName(cmdArgs.getArgs().get(i), JadortConsoleInterface);
                                servers.add(server);
                                ++i;
                            }
                            ret.add(servers);
                            continue;
                        }
                        if (signature[i] == IJadortService.OperationType.class) {
                            IJadortService.OperationType opType = IJadortService.OperationType.valueOf((String)cmdArgs.getArgs().get(i));
                            ret.add(opType);
                            continue;
                        }
                        throw new IllegalArgumentException("Devolopment error : type " + signature[i] + " unparsed");
                    }
                    ret.add(cmdArgs.getArgs().get(i));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                JadortConsole.usage("Not enough arguments provided on the command line");
            }
        }
        return ret;
    }

    private static OperationStateBean getOperationByID(Integer id, JadortCommand JadortConsoleInterface) throws Exception {
        List<OperationStateBean> operations = JadortConsole.getOperations(JadortConsoleInterface);
        if (operations != null) {
            for (OperationStateBean op : operations) {
                if (op.getId().compareTo(id) != 0) continue;
                return op;
            }
            return null;
        }
        return null;
    }

    private static List<OperationStateBean> getOperations(JadortCommand JadortConsoleInterface) throws Exception {
        return JadortConsoleInterface.getOperationsList();
    }

    private static ServerBean getServerByID(Integer id, List<ServerBean> servers) {
        if (servers != null) {
            for (ServerBean s : servers) {
                if (s.getId().compareTo(id) != 0) continue;
                return s;
            }
            return null;
        }
        return null;
    }

    private static WorkerBean getWorkerByID(Integer id, List<WorkerBean> workers) {
        if (workers != null) {
            for (WorkerBean w : workers) {
                if (w.getId().compareTo(id) != 0) continue;
                return w;
            }
            return null;
        }
        return null;
    }

    private static List<ServerBean> getServers(JadortCommand JadortConsoleInterface) throws Exception {
        return JadortConsoleInterface.getSelectedGroup().getServers();
    }

    private static List<WorkerBean> getWorkers(JadortCommand JadortConsoleInterface) throws Exception {
        return JadortConsoleInterface.getSelectedGroup().getWorkers();
    }

    public static GroupBean getGroupByName(String name, JadortCommand JadortConsoleInterface) throws Exception {
        List<GroupBean> groups = JadortConsole.getGroups(JadortConsoleInterface);
        for (GroupBean g : groups) {
            if (g.getName().compareTo(name) != 0) continue;
            return g;
        }
        return null;
    }

    public static ServerBean getServerByName(String name, JadortCommand JadortConsoleInterface) throws Exception {
        List<ServerBean> servers = JadortConsole.getServers(JadortConsoleInterface);
        for (ServerBean s : servers) {
            if (s.getName().compareTo(name) != 0) continue;
            return s;
        }
        return null;
    }

    public static List<GroupBean> getGroups(JadortCommand JadortConsoleInterface) throws Exception {
        return JadortConsoleInterface.getGroups();
    }

    public static OperationStateBean handleCreateOperation(OperationStateBean op) {
        System.out.println("New operation created with id = " + op.getId());
        return op;
    }

    public static void handleOperationsList(List<OperationStateBean> operations) {
        System.out.println("\nList of existing opeations : ");
        System.out.println("\tID \t name \t date");
        for (OperationStateBean op : operations) {
            System.out.print("\t " + op.getId());
            System.out.print("\t " + op.getName());
            System.out.println("\t " + op.getDate());
        }
    }

    public static void handleGroupsList(List<GroupBean> groups) {
        System.out.println("Group list : ");
        System.out.println("--------------------------------");
        for (GroupBean g : groups) {
            JadortConsole.printGroup(g);
            System.out.println("--------------------------------\n");
        }
    }

    public static void handleGroup(GroupBean group) {
        System.out.println("\nSelected group : ");
        JadortConsole.printGroup(group);
    }

    private static void printGroup(GroupBean group) {
        if (group == null) {
            System.out.println("No group");
        } else {
            System.out.println("ID : " + group.getId());
            System.out.println("Name : " + group.getName());
            System.out.println("\n");
            System.out.println("Servers on this group :");
            System.out.println("\tID \tName \tCapacity");
            for (ServerBean s : group.getServers()) {
                System.out.print("\t" + s.getId());
                System.out.print("\t" + s.getName());
                System.out.println("\t" + s.getCapacity());
            }
            System.out.println("\n");
            System.out.println("Applications on this group :");
            System.out.println("\tID \tName \tVersion \tState \tPolicy");
            for (ApplicationBean a : group.getApplications()) {
                System.out.print("\t" + a.getId());
                System.out.print("\t" + a.getName());
                System.out.print("\t" + a.getVersion());
                System.out.print("\t" + a.getState());
                System.out.println("\t" + a.getPolicy());
            }
        }
    }

    public static void handleServerProgressList(List<ServerProgressBean> serverProgresss) {
        System.out.println("\nList of serverProgresss : ");
        System.out.println("--------------------------------");
        System.out.println("\tID \t server name \t state \t progress \t log \t old application \t new application");
        for (ServerProgressBean dep : serverProgresss) {
            System.out.print("\t " + dep.getId());
            System.out.print("\t " + dep.getServer().getName());
            System.out.print("\t " + dep.getState());
            System.out.print("\t " + dep.getProgress());
            System.out.print("\t " + dep.getLog());
            System.out.print("\t " + dep.getOldApplication());
            System.out.println("\t " + dep.getNewApplication());
        }
    }

    public static void handleWorkerProgressList(List<WorkerProgressBean> workerProgresss) {
        System.out.println("\nList of workerProgresss : ");
        System.out.println("--------------------------------");
        System.out.println("\tID \t worker name \t state \t progress \t log");
        for (WorkerProgressBean dep : workerProgresss) {
            System.out.print("\t " + dep.getId());
            System.out.print("\t " + dep.getWorker().getName());
            System.out.print("\t " + dep.getState());
            System.out.print("\t " + dep.getProgress());
            System.out.print("\t " + dep.getLog());
        }
    }

    public static Integer handleBoolean(Boolean bool) {
        System.out.println("Value : " + bool);
        if (bool.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public static Integer handleInteger(Integer integer) {
        System.out.println("Value : " + integer);
        return integer;
    }

    public static void handleStep(OperationStateBean.Step step) {
        System.out.println("The current step is : " + step);
    }

    private static void usage(String info) {
        StringBuilder message = new StringBuilder();
        message.append("Unvalid syntax\n");
        message.append(info + "\n");
        message.append("Usage : cmd [operationId] [args,...]\n");
        message.append("List of commands : \n");
        message.append("\t- createNewOperation {new operation name}\n");
        message.append("\t- getOperationsList\n");
        message.append("\t- deleteOperation {operation id}\n");
        message.append("\t- loadTopology {operation id} {file path}\n");
        message.append("\t- getGroups {operation id}\n");
        message.append("\t- selectGroup {operation id} {group name} {operation type}\n");
        message.append("\t- selectServers {operation id} {server1} {server2} ...\n");
        message.append("\t- getCurrentStep {operation id}\n");
        message.append("\t- canGoToNextStep {operation id}\n");
        message.append("\t- next {operation id}\n");
        message.append("\t- canGoToPreviousStep {operation id}\n");
        message.append("\t- previous {operation id}\n");
        message.append("\t- getServerProgressList {operation id}\n");
        message.append("\t- getWorkerProgressList {operation id}\n");
        message.append("\t- getSelectedGroup {operation id}\n");
        message.append("\t- restartServer {operation id} {server id}\n");
        message.append("\t- ignoreServer {operation id} {server id}\n");
        message.append("\t- checkServer {operation id} {server id}\n");
        message.append("\t- restartWorker {operation id} {worker id}\n");
        message.append("\t- ignoreWorker {operation id} {worker id}\n");
        message.append("\t- checkWorker {operation id} {worker id}\n");
        message.append("\t- createApplication {operation id} {archive path}\n");
        throw new IllegalArgumentException(message.toString());
    }

    static {
        methods.put("createNewOperation", new Class[]{String.class});
        methods.put("getOperationsList", new Class[0]);
        methods.put("deleteOperation", new Class[]{OperationStateBean.class});
        methods.put("loadTopology", new Class[]{File.class});
        methods.put("getGroups", new Class[0]);
        methods.put("selectGroup", new Class[]{GroupBean.class, IJadortService.OperationType.class});
        methods.put("selectServers", new Class[]{List.class});
        methods.put("getCurrentStep", new Class[0]);
        methods.put("canGoToNextStep", new Class[0]);
        methods.put("next", new Class[0]);
        methods.put("canGoToPreviousStep", new Class[0]);
        methods.put("previous", new Class[0]);
        methods.put("getServerProgressList", new Class[0]);
        methods.put("getWorkerProgressList", new Class[0]);
        methods.put("getSelectedGroup", new Class[0]);
        methods.put("getActiveSessions", new Class[0]);
        methods.put("restartServer", new Class[]{ServerBean.class});
        methods.put("ignoreServer", new Class[]{ServerBean.class});
        methods.put("checkServer", new Class[]{ServerBean.class});
        methods.put("restartWorker", new Class[]{WorkerBean.class});
        methods.put("ignoreWorker", new Class[]{WorkerBean.class});
        methods.put("checkWorker", new Class[]{WorkerBean.class});
        methods.put("createApplication", new Class[]{URL.class});
        commands = new HashMap<String, Method>();
        try {
            String key = "createNewOperation";
            commands.put("createNewOperation", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "getOperationsList";
            commands.put("getOperationsList", JadortCommand.class.getMethod(key, new Class[0]));
            key = "deleteOperation";
            commands.put("deleteOperation", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "loadTopology";
            commands.put("loadTopology", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "getGroups";
            commands.put("getGroups", JadortCommand.class.getMethod(key, new Class[0]));
            key = "selectGroup";
            commands.put("selectGroup", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "selectServers";
            commands.put("selectServers", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "getSelectedGroup";
            commands.put("getSelectedGroup", JadortCommand.class.getMethod(key, new Class[0]));
            key = "getActiveSessions";
            commands.put("getActiveSessions", JadortCommand.class.getMethod(key, new Class[0]));
            key = "createApplication";
            commands.put("createApplication", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "getCurrentStep";
            commands.put("getCurrentStep", JadortCommand.class.getMethod(key, new Class[0]));
            key = "canGoToNextStep";
            commands.put("canGoToNextStep", JadortCommand.class.getMethod(key, new Class[0]));
            key = "next";
            commands.put("next", JadortCommand.class.getMethod(key, new Class[0]));
            key = "canGoToPreviousStep";
            commands.put("canGoToPreviousStep", JadortCommand.class.getMethod(key, new Class[0]));
            key = "previous";
            commands.put("previous", JadortCommand.class.getMethod(key, new Class[0]));
            key = "getServerProgressList";
            commands.put("getServerProgressList", JadortCommand.class.getMethod(key, new Class[0]));
            key = "getWorkerProgressList";
            commands.put("getWorkerProgressList", JadortCommand.class.getMethod(key, new Class[0]));
            key = "restartServer";
            commands.put("restartServer", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "restartWorker";
            commands.put("restartWorker", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "ignoreServer";
            commands.put("ignoreServer", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "ignoreWorker";
            commands.put("ignoreWorker", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "checkServer";
            commands.put("checkServer", JadortCommand.class.getMethod(key, methods.get(key)));
            key = "checkWorker";
            commands.put("checkWorker", JadortCommand.class.getMethod(key, methods.get(key)));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        methodsNeedOperationNumber = new HashMap<Method, Boolean>();
        methodsNeedOperationNumber.put(commands.get("loadTopology"), true);
        methodsNeedOperationNumber.put(commands.get("getCurrentStep"), true);
        methodsNeedOperationNumber.put(commands.get("canGoToNextStep"), true);
        methodsNeedOperationNumber.put(commands.get("next"), true);
        methodsNeedOperationNumber.put(commands.get("canGoToPreviousStep"), true);
        methodsNeedOperationNumber.put(commands.get("previous"), true);
        methodsNeedOperationNumber.put(commands.get("getGroups"), true);
        methodsNeedOperationNumber.put(commands.get("selectGroup"), true);
        methodsNeedOperationNumber.put(commands.get("selectServers"), true);
        methodsNeedOperationNumber.put(commands.get("getServerProgressList"), true);
        methodsNeedOperationNumber.put(commands.get("getWorkerProgressList"), true);
        methodsNeedOperationNumber.put(commands.get("getSelectedGroup"), true);
        methodsNeedOperationNumber.put(commands.get("getActiveSessions"), true);
        methodsNeedOperationNumber.put(commands.get("restartServer"), true);
        methodsNeedOperationNumber.put(commands.get("ignoreServer"), true);
        methodsNeedOperationNumber.put(commands.get("restartWorker"), true);
        methodsNeedOperationNumber.put(commands.get("ignoreWorker"), true);
        methodsNeedOperationNumber.put(commands.get("checkServer"), true);
        methodsNeedOperationNumber.put(commands.get("checkWorker"), true);
        methodsNeedOperationNumber.put(commands.get("createApplication"), true);
        try {
            output = new HashMap<String, Method>();
            output.put("getCurrentStep", JadortConsole.class.getMethod("handleStep", OperationStateBean.Step.class));
            output.put("canGoToNextStep", JadortConsole.class.getMethod("handleBoolean", Boolean.class));
            output.put("next", null);
            output.put("canGoToPreviousStep", JadortConsole.class.getMethod("handleBoolean", Boolean.class));
            output.put("previous", null);
            output.put("loadTopology", null);
            output.put("getGroups", JadortConsole.class.getMethod("handleGroupsList", List.class));
            output.put("selectServers", null);
            output.put("getServerProgressList", JadortConsole.class.getMethod("handleServerProgressList", List.class));
            output.put("getWorkerProgressList", JadortConsole.class.getMethod("handleWorkerProgressList", List.class));
            output.put("getSelectedGroup", JadortConsole.class.getMethod("handleGroup", GroupBean.class));
            output.put("getActiveSessions", JadortConsole.class.getMethod("handleInteger", Integer.class));
            output.put("restart", null);
            output.put("ignoreServer", null);
            output.put("checkServer", JadortConsole.class.getMethod("handleBoolean", Boolean.class));
            output.put("createApplication", null);
            output.put("getOperationsList", JadortConsole.class.getMethod("handleOperationsList", List.class));
            output.put("selectOperation", null);
            output.put("createNewOperation", JadortConsole.class.getMethod("handleCreateOperation", OperationStateBean.class));
            output.put("deleteOperation", null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandArgs {
        private Method command;
        private List<String> args = new ArrayList<String>();

        public Method getCommand() {
            return this.command;
        }

        public void setCommand(Method command) {
            this.command = command;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args = args;
        }
    }
}

