/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.client.console;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadortCommand {
    private IJadortService jadortService;

    public JadortCommand(IJadortService jadortService) {
        this.jadortService = jadortService;
    }

    public OperationStateBean createNewOperation(String newOperationName) throws Exception {
        this.jadortService.createNewOperation(newOperationName);
        return this.jadortService.getCurrentOperation();
    }

    public List<OperationStateBean> getOperationsList() throws Exception {
        return this.jadortService.getOperationsList();
    }

    public void selectOperation(OperationStateBean operation) throws Exception {
        this.jadortService.selectOperation(operation);
    }

    public void deleteOperation(OperationStateBean operation) throws Exception {
        this.jadortService.deleteOperation(operation);
    }

    public void loadTopology(File xmlTopoFile) throws Exception {
        this.jadortService.loadTopology(xmlTopoFile);
        this.jadortService.next();
    }

    public List<GroupBean> getGroups() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null && currentOperation.getTopology() != null) {
            return currentOperation.getTopology().getGroups();
        }
        return null;
    }

    public void selectGroup(GroupBean selectedGroup) throws Exception {
        this.jadortService.selectGroup(selectedGroup);
        this.jadortService.next();
    }

    public void selectOperationType(IJadortService.OperationType operationType) throws Exception {
        this.jadortService.selectOperationType(operationType);
        this.jadortService.next();
    }

    public void selectVMImage(VMImageBean vmImage) throws Exception {
        this.jadortService.selectVMImage(vmImage);
        this.jadortService.next();
    }

    public void selectVMImage(VMImageBean vmImage, ServerBean server) throws Exception {
        this.jadortService.selectVMImage(vmImage, server);
        this.jadortService.next();
    }

    public List<VMImageBean> getVMImages() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null && currentOperation.getSelectedGroup() != null) {
            return currentOperation.getSelectedGroup().getVmImages();
        }
        return null;
    }

    public void selectServers(List<ServerBean> selectedServers) throws Exception {
        this.jadortService.selectServers(selectedServers);
        this.jadortService.next();
    }

    public GroupBean getSelectedGroup() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null) {
            return currentOperation.getSelectedGroup();
        }
        return null;
    }

    public Integer getActiveSessions() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null && currentOperation.getSelectedGroup() != null) {
            int sessions = 0;
            for (ServerBean server : currentOperation.getSelectedGroup().getServers()) {
                sessions += server.getActiveSessions();
            }
            return sessions;
        }
        return 0;
    }

    public ApplicationBean selectApplication(URL url) throws Exception {
        this.jadortService.selectApplication(url);
        this.jadortService.next();
        return this.jadortService.getCurrentOperation().getApplication();
    }

    public OperationStateBean.Step getCurrentStep() throws Exception {
        return this.jadortService.getCurrentStep();
    }

    public boolean canGoToNextStep() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null) {
            return currentOperation.getCanGoToNextStep();
        }
        return false;
    }

    public void next() throws Exception {
        this.jadortService.next();
    }

    public boolean canGoToPreviousStep() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null) {
            return currentOperation.getCanGoToPreviousStep();
        }
        return false;
    }

    public void previous() throws Exception {
        this.jadortService.previous();
    }

    public List<ServerProgressBean> getServerProgressList() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null) {
            return currentOperation.getServerProgressList();
        }
        return null;
    }

    public List<WorkerProgressBean> getWorkerProgressList() throws Exception {
        OperationStateBean currentOperation = this.jadortService.getCurrentOperation();
        if (currentOperation != null) {
            return currentOperation.getWorkerProgressList();
        }
        return null;
    }

    public void restartServer(ServerBean server) throws Exception {
        this.jadortService.restartServer(server);
    }

    public void ignoreServer(ServerBean server) throws Exception {
        this.jadortService.ignoreServer(server);
    }

    public boolean checkServer(ServerBean server) throws Exception {
        return this.jadortService.checkServer(server);
    }

    public void restartWorker(WorkerBean worker) throws Exception {
        this.jadortService.restartWorker(worker);
    }

    public void ignoreWorker(WorkerBean worker) throws Exception {
        this.jadortService.ignoreWorker(worker);
    }

    public boolean checkWorker(WorkerBean worker) throws Exception {
        return this.jadortService.checkWorker(worker);
    }
}

