/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.filters;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ow2.jasmine.jadort.filters.OnlyAllowUsersWithSessionFilterMBean;

public final class OnlyAllowUsersWithSessionFilter
implements Filter,
OnlyAllowUsersWithSessionFilterMBean {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private boolean active = false;
    private MBeanServer mBeanServer;
    private ObjectName filterON;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            ObjectName j2eeServer = null;
            ArrayList<Object> mBeanServers = new ArrayList<Object>();
            try {
                mBeanServers.addAll(MBeanServerFactory.findMBeanServer(null));
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                InitialContext ctx = new InitialContext();
                Object webLogicMBeanServer = ctx.lookup("java:comp/env/jmx/runtime");
                if (webLogicMBeanServer != null) {
                    mBeanServers.add(webLogicMBeanServer);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (mBeanServers.size() == 0) {
                throw new IllegalStateException("Cannot find any MBeanServer!");
            }
            Iterator i = mBeanServers.iterator();
            while (i.hasNext()) {
                MBeanServer server = (MBeanServer)i.next();
                Set<ObjectName> j2eeServerNames = server.queryNames(new ObjectName("*:j2eeType=J2EEServer,*"), null);
                if (j2eeServerNames.size() > 0) {
                    j2eeServer = j2eeServerNames.iterator().next();
                    this.mBeanServer = server;
                    break;
                }
                j2eeServerNames = server.queryNames(new ObjectName("*:Type=ServerRuntime,*"), null);
                if (j2eeServerNames.size() <= 0) continue;
                j2eeServer = j2eeServerNames.iterator().next();
                this.mBeanServer = server;
                break;
            }
            if (this.mBeanServer == null) {
                throw new IllegalStateException("Cannot locate the J2EEServer or ServerRuntime MBean in any MBeanServer");
            }
            ServletContext context = filterConfig.getServletContext();
            Method getContextPath = context.getClass().getMethod("getContextPath", null);
            String contextPath = (String)getContextPath.invoke((Object)context, null);
            if (contextPath == null || contextPath.length() < 1) {
                contextPath = "/";
            }
            this.filterON = new ObjectName(j2eeServer.getDomain() + ":type=J2EEFilter,path=" + contextPath);
            this.mBeanServer.registerMBean(this, this.filterON);
            this.log.fine("OnlyAllowUsersWithSessionFilter MBean has been successfully registered on MBeanServer " + this.mBeanServer + " with the ObjectName " + this.filterON);
        }
        catch (Exception e) {
            throw new ServletException("Cannot instanciate the OnlyAllowUsersWithSessionFilter", (Throwable)e);
        }
    }

    public void destroy() {
        try {
            this.mBeanServer.unregisterMBean(this.filterON);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Failed unregistering the OnlyAllowUsersWithSessionFilter MBean", e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.active && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            HttpSession session = req.getSession(false);
            if (session == null) {
                resp.sendError(503, "This server is going down for maintenance.\nPlease use another server in our server farm or try again later.");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public boolean getactive() {
        return this.active;
    }

    public void setactive(boolean active) {
        this.active = active;
    }
}

