/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MyStoreBeanImpl.java 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.samples;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.ejb.Stateful;

@Stateful
public class MyStoreBeanImpl implements MyStoreBean {

	private Map<String, Integer> products;
	private Map<String, Integer> cart;

	@PostConstruct
	public void initialize() {
		products = new HashMap<String, Integer>(6);
		products.put("Christmas CDs collection", 20);
		products.put("Collector DVD collection", 25);
		products.put("Forgetting Sarah DVD", 10);
		products.put("My favorite Elvis songs", 10);
		products.put("New York Fair 1939", 5);

		cart = new HashMap<String, Integer>();
	}

	public Map<String, Integer> getProducts() {
		return products;
	}

	public void addItem(String item) {
		if (item != null && products.containsKey(item)) {
			Integer quantity;
			if (cart.containsKey(item)) {
				quantity = cart.get(item) + 1;
			} else {
				quantity = new Integer(1);
			}
			cart.put(item, quantity);
		}
	}

	public void removeItem(String item) {
		if (item != null && products.containsKey(item)) {
			Integer quantity = cart.get(item) - 1;
			if (quantity > 0) {
				cart.put(item, quantity);
			} else {
				cart.remove(item);
			}
		}
	}

	public Map<String, Integer> getCart() {
		return cart;
	}

	public Integer getValue() {
		int result = 0;
		for (Integer i : cart.values()) {
			result += i;
		}
		return result;
	}

}
