/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ModProxyBalancerWorkerAction.java 2854 2008-12-03 16:09:32Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.jadort.service.action;

import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Balancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.ModProxyBalancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Worker;

/**
 * Tests the mod_proxy_balancer manager.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class ModProxyBalancerWorkerAction extends WorkerAction {

    private String name;

    private String balancerName;

    private String balancerMemberName;

    private ModProxyBalancer modProxyBalancer;

    protected ModProxyBalancerWorkerAction(final WorkerBean worker) {
        this.name = worker.getName();
        this.balancerName = worker.getWorkerName();
        this.balancerMemberName = worker.getServerName();
        this.modProxyBalancer = new ModProxyBalancer(worker.getConnector().getConnectorUrl(), worker.getConnector()
            .getUsername(), worker.getConnector().getPassword());

        this.appendToLog("Created ModProxyBalancerWorkerAction for worker '" + this.name + "'");
    }

    @Override
    public void activate() throws Exception {
        this.appendToLog("Starting worker '" + this.name + "'");
        this.modProxyBalancer.activateWorker(this.balancerName, this.balancerMemberName);
        this.appendToLog("Worker '" + this.name + "' has been succesufully started");
    }

    @Override
    public void disable() throws Exception {
        this.appendToLog("Disabling worker '" + this.name + "'");
        this.modProxyBalancer.deactivateWorker(this.balancerName, this.balancerMemberName);
        this.appendToLog("Worker '" + this.name + "' has  been succesufully disabled");
    }

    @Override
    public void stop() throws Exception {
        this.disable();
    }

    @Override
    public State getState() throws Exception {
        this.appendToLog("Getting worker state");
        State state = null;
        Worker currentworker = null;
        for (Balancer balancer : this.modProxyBalancer.getBalancers()) {
            if (balancer.getName().equals(this.balancerName)) {
                for (Worker worker : balancer.getWorkers()) {
                    if (worker.getUrl().equals(this.balancerMemberName)) {
                        currentworker = worker;
                    }
                }
            }
        }
        if (currentworker == null) {
            throw new IllegalStateException("Worker '" + this.balancerName + "' not found on balancer '"
                + this.balancerMemberName + "'");
        }
        if (currentworker.isEnabled()) {
            state = State.ACTIVE;
        } else if (currentworker.isEnabled()) {
            state = State.DISABLED;
        } else {
            throw new IllegalStateException("Unknown activation state");
        }

        this.appendToLog("Worker state is " + state);
        return state;
    }
}
