/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JkActionParser.java 2507 2008-10-01 16:17:13Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.service.action.modJK;

import org.apache.jk.status.JkStatus;
import org.apache.jk.status.JkStatusParser;
import org.apache.tomcat.util.digester.Digester;

/**
 * Parses responses from the mod_jk manager.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class JkActionParser extends JkStatusParser {

    /**
     * The descriptive information about this implementation.
     */
    private static final String info = "org.apache.jk.status.JkActionParser/1.1";

    /**
     * Action digester.
     */
    protected static Digester actionDigester;

    /**
     * Return descriptive information about this implementation and the
     * corresponding version number, in the format
     * <code>&lt;description&gt;/&lt;version&gt;</code>.
     */
    @Override
    public String getInfo() {
        return JkActionParser.info;
    }

    /**
     * @return The action digester we will be using for setup mod_jk jk action
     *         result page.
     */
    public static Digester getActionDigester() {
        if (JkActionParser.actionDigester == null) {
            JkActionParser.actionDigester = JkActionParser.createActionDigester();
        }
        return JkActionParser.actionDigester;
    }

    /**
     * Create and configure the Digester we will be using for setup mod_jk jk
     * action result page.
     */
    protected static Digester createActionDigester() {
        // Initialize the digester
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(JkStatus.class.getClassLoader());

        // Parse status
        digester.addObjectCreate("jk:status", "org.apache.jk.status.JkStatus", "className");
        digester.addSetProperties("jk:status");

        digester.addObjectCreate("jk:status/jk:server", "org.apache.jk.status.JkServer", "className");
        digester.addSetProperties("jk:status/jk:server");
        digester.addSetNext("jk:status/jk:server", "setServer", "org.apache.jk.status.JkServer");

        digester.addObjectCreate("jk:status/jk:result", "org.apache.jk.status.JkResult", "className");
        digester.addSetProperties("jk:status/jk:result");
        digester.addSetNext("jk:status/jk:result", "setResult", "org.apache.jk.status.JkResult");

        return digester;
    }
}
