/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Balancer.java 2854 2008-12-03 16:09:32Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.service.action.modProxyBalancer;

import java.util.ArrayList;
import java.util.List;

/**
 * A mod_proxy_balancer balancer.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class Balancer {

    private String name;

    private List<Worker> workers;

    public Balancer(final String name) {
        super();
        this.name = name;
        this.workers = new ArrayList<Worker>();
    }

    public Balancer(final String name, final List<Worker> workers) {
        super();
        this.name = name;
        this.workers = workers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public List<Worker> getWorkers() {
        return this.workers;
    }

    public void setWorkers(final List<Worker> workers) {
        this.workers = workers;
    }

    public void addWorker(final Worker worker) {

        this.workers.add(worker);
    }

    public void removeWorker(final Worker worker) {

        this.workers.remove(worker);
    }
}
