/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;

@Entity(name="JaDOrT_ServerProgressBean")
public class ServerProgressBean
implements Serializable {
    private static final long serialVersionUID = -2851071984012556925L;
    @Id
    @GeneratedValue
    private Integer id;
    @Version
    private Integer version;
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private ServerBean server;
    private String oldApplication;
    private String newApplication;
    private int progress = 0;
    private String log;
    private ServerProgressState serverProgressState;
    private OperationStateBean.ActionState actionState = OperationStateBean.ActionState.WAITING;

    public ServerProgressBean() {
        this.serverProgressState = ServerProgressState.INITIAL;
    }

    public ServerProgressBean(ServerBean server) {
        this();
        this.server = server;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ServerBean getServer() {
        return this.server;
    }

    public void setServer(ServerBean server) {
        this.server = server;
    }

    public String getServerName() {
        return this.server.getName();
    }

    public String getState() {
        if (this.actionState.equals(OperationStateBean.ActionState.WAITING)) {
            return "Waiting";
        }
        if (this.actionState.equals(OperationStateBean.ActionState.RUNNING)) {
            return "Running";
        }
        if (this.actionState.equals(OperationStateBean.ActionState.FINISHED_OK)) {
            return "Done OK";
        }
        if (this.actionState.equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
            return "Error !";
        }
        return null;
    }

    public void setState(String state) {
    }

    public String getOldApplication() {
        return this.oldApplication;
    }

    public void setOldApplication(String oldApplication) {
        this.oldApplication = oldApplication;
    }

    public boolean hasOldVersion() {
        return this.oldApplication != null && !this.oldApplication.equals(this.newApplication);
    }

    public String getNewApplication() {
        return this.newApplication;
    }

    public void setNewApplication(String newApplication) {
        this.newApplication = newApplication;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("Progress is a percentage (between 0 and 100)");
        }
        this.progress = progress;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void appendToLog(String string) {
        if (string != null && string.length() > 0) {
            this.log = this.log == null ? string : this.log + '\n' + string;
        }
    }

    public ServerProgressState getServerProgressState() {
        return this.serverProgressState;
    }

    public void setServerProgressState(ServerProgressState serverProgressState) {
        this.serverProgressState = serverProgressState;
    }

    public OperationStateBean.ActionState getActionState() {
        return this.actionState;
    }

    public void setActionState(OperationStateBean.ActionState actionState) {
        this.actionState = actionState;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[server='");
        sb.append(this.server);
        sb.append("']");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ServerProgressBean) {
            ServerProgressBean other = (ServerProgressBean)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }
        return false;
    }

    public static final class ServerProgressState
    implements Serializable {
        private static final long serialVersionUID = 6491848606792309527L;
        public static final ServerProgressState INITIAL = new ServerProgressState("INITIAL");
        public static final ServerProgressState UPLOAD_OK = new ServerProgressState("UPLOAD_OK");
        public static final ServerProgressState DEPLOY_OK = new ServerProgressState("DEPLOY_OK");
        public static final ServerProgressState SET_DEFAULT_OK = new ServerProgressState("SET_DEFAULT_OK");
        public static final ServerProgressState UNDEPLOY_OK = new ServerProgressState("UNDEPLOY_OK");
        public static final ServerProgressState ERASE_OK = new ServerProgressState("ERASE_OK");
        public static final ServerProgressState START_OK = new ServerProgressState("START_OK");
        public static final ServerProgressState MAINTAIN_OK = new ServerProgressState("MAINTAIN_OK");
        public static final ServerProgressState STOP_OK = new ServerProgressState("STOP_OK");
        public static final ServerProgressState DISABLE_APPLICATIONS_OK = new ServerProgressState("DISABLE_APPLICATIONS_OK");
        private static final ServerProgressState[] values = new ServerProgressState[]{INITIAL, UPLOAD_OK, DEPLOY_OK, SET_DEFAULT_OK, UNDEPLOY_OK, ERASE_OK, START_OK, MAINTAIN_OK, STOP_OK, DISABLE_APPLICATIONS_OK};
        private String serverProgressState;

        private ServerProgressState(String serverProgressState) {
            this.serverProgressState = serverProgressState;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof ServerProgressState) {
                ServerProgressState serverProgressState = (ServerProgressState)object;
                if (serverProgressState.serverProgressState.equals(this.serverProgressState)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.serverProgressState.hashCode();
        }

        public String toString() {
            return this.serverProgressState;
        }

        public static ServerProgressState[] values() {
            return values;
        }

        public static ServerProgressState valueOf(String string) {
            for (ServerProgressState serverProgressState : values) {
                if (!serverProgressState.serverProgressState.equals(string)) continue;
                return serverProgressState;
            }
            throw new IllegalArgumentException("Unknown value: " + string);
        }
    }
}

