/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Balancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.ModProxyBalancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Worker;

public class ModProxyBalancerWorkerAction
extends WorkerAction {
    private String name;
    private String balancerName;
    private String balancerMemberName;
    private ModProxyBalancer modProxyBalancer;

    protected ModProxyBalancerWorkerAction(WorkerBean worker) {
        this.name = worker.getName();
        this.balancerName = worker.getWorkerName();
        this.balancerMemberName = worker.getServerName();
        this.modProxyBalancer = new ModProxyBalancer(worker.getConnector().getConnectorUrl(), worker.getConnector().getUsername(), worker.getConnector().getPassword());
        this.appendToLog("Created ModProxyBalancerWorkerAction for worker '" + this.name + "'");
    }

    public void activate() throws Exception {
        this.appendToLog("Starting worker '" + this.name + "'");
        this.modProxyBalancer.activateWorker(this.balancerName, this.balancerMemberName);
        this.appendToLog("Worker '" + this.name + "' has been succesufully started");
    }

    public void disable() throws Exception {
        this.appendToLog("Disabling worker '" + this.name + "'");
        this.modProxyBalancer.deactivateWorker(this.balancerName, this.balancerMemberName);
        this.appendToLog("Worker '" + this.name + "' has  been succesufully disabled");
    }

    public void stop() throws Exception {
        this.disable();
    }

    public WorkerAction.State getState() throws Exception {
        this.appendToLog("Getting worker state");
        WorkerAction.State state = null;
        Worker currentworker = null;
        for (Balancer balancer : this.modProxyBalancer.getBalancers()) {
            if (!balancer.getName().equals(this.balancerName)) continue;
            for (Worker worker : balancer.getWorkers()) {
                if (!worker.getUrl().equals(this.balancerMemberName)) continue;
                currentworker = worker;
            }
        }
        if (currentworker == null) {
            throw new IllegalStateException("Worker '" + this.balancerName + "' not found on balancer '" + this.balancerMemberName + "'");
        }
        if (currentworker.isEnabled()) {
            state = WorkerAction.State.ACTIVE;
        } else if (currentworker.isEnabled()) {
            state = WorkerAction.State.DISABLED;
        } else {
            throw new IllegalStateException("Unknown activation state");
        }
        this.appendToLog("Worker state is " + (Object)((Object)state));
        return state;
    }
}

