/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSphereServerAction
extends ServerAction {
    private static final String WEBSPHERE_ROOT = "WAS_INSTALL_ROOT";
    private String name;
    private String url;
    private String username;
    private String password;
    private ObjectName j2eeServer;
    private MBeanServerConnection mbscnx = null;

    protected WebSphereServerAction(ServerBean server) {
        this.name = server.getName();
        this.url = server.getServerConnector().getConnectorUrl();
        this.username = server.getServerConnector().getUsername();
        this.password = server.getServerConnector().getPassword();
        this.appendToLog("Created WebSphereServerAction for server '" + this.name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkJMXConnection() throws Exception {
        if (this.mbscnx != null) {
            try {
                this.mbscnx.getMBeanCount();
            }
            catch (IOException e) {
                this.mbscnx = null;
                this.appendToLog("Connection dropped, reconnecting to JMX server on URL '" + this.url + "'");
            }
        }
        if (this.mbscnx == null) {
            this.appendToLog("Trying to connect to JMX server on URL '" + this.url + "'");
            String root = System.getenv(WEBSPHERE_ROOT);
            if (root == null) {
                root = System.getProperty(WEBSPHERE_ROOT);
            }
            ArrayList<URL> files = new ArrayList<URL>();
            if (root != null) {
                File runtimes = new File(root, "runtimes");
                for (File file : runtimes.listFiles()) {
                    if (file.getName().startsWith("com.ibm.ws.admin.client")) {
                        files.add(file.toURI().toURL());
                        continue;
                    }
                    if (!file.getName().startsWith("com.ibm.ws.orb")) continue;
                    files.add(file.toURI().toURL());
                }
            }
            if (files.size() == 0) {
                throw new Exception("You need to set the environment variable WAS_INSTALL_ROOT to a valid license in order to connect to a WebSphere server.\nCurrently, WAS_INSTALL_ROOT is set to \"" + root + "\"");
            }
            URL[] urls = new URL[files.size()];
            urls = files.toArray(urls);
            URLClassLoader cl = new URLClassLoader(urls, this.getClass().getClassLoader());
            ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(cl);
                HashMap<String, String> env = new HashMap<String, String>();
                if (this.username != null && this.password != null) {
                    env.put("java.naming.security.principal", this.username);
                    env.put("java.naming.security.credentials", this.password);
                }
                env.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                JMXConnector c = JMXConnectorFactory.connect(new JMXServiceURL(this.url), env);
                this.mbscnx = c.getMBeanServerConnection();
                String serverObjectName = "WebSphere:j2eeType=J2EEServer,type=Server,*";
                this.j2eeServer = this.mbscnx.queryNames(new ObjectName(serverObjectName), null).iterator().next();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxCL);
            }
            this.appendToLog("JMX server connection OK for server '" + this.name + "', J2EEServer is '" + this.j2eeServer + "'");
        }
    }

    @Override
    public void deploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public boolean enableOrDisableApplications(boolean enable) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Enabling or disabling all applications on this server");
        boolean failed = false;
        for (ObjectName app : this.mbscnx.queryNames(new ObjectName("WebSphere:type=SessionManager,*"), null)) {
            ObjectName filter;
            String path = app.getKeyProperty("mbeanIdentifier");
            if (path != null) {
                path = path.substring(path.indexOf("/"));
            }
            try {
                filter = this.mbscnx.queryNames(new ObjectName("WebSphere:type=J2EEFilter,path=" + path), null).iterator().next();
            }
            catch (NoSuchElementException e) {
                this.appendToLog("\tApplication on path '" + path + "' doesn't have the OnlyAllowUsersWithSessionFilter filter! Please " + "import the filter JAR from the jadort-samples package and set it in the application's descriptor");
                failed = true;
                continue;
            }
            this.mbscnx.setAttribute(filter, new Attribute("active", !enable));
            this.appendToLog("\tFilter for application on path '" + path + "' has been set as " + (enable ? "in" : "") + "active, application is therefore " + (enable ? "enabled" : "disabled"));
        }
        if (failed) {
            this.appendToLog("At least one application on this server couldn't be " + (enable ? "enabled" : "disabled"));
            return false;
        }
        this.appendToLog("All applications on this server are now " + (enable ? "enabled" : "disabled"));
        return true;
    }

    @Override
    public void erase(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public int getActiveSessions(String appName) throws Exception {
        this.checkJMXConnection();
        Long totalActiveSessions = new Long(0L);
        Set<ObjectName> managers = this.mbscnx.queryNames(new ObjectName("WebSphere:type=SessionManager,*"), null);
        for (ObjectName manager : managers) {
            Object stats = this.mbscnx.getAttribute(manager, "stats");
            Class[] paramTypes = new Class[]{String.class};
            Method m = stats.getClass().getMethod("getStatistic", paramTypes);
            Object liveCount = m.invoke(stats, "LiveCount");
            m = liveCount.getClass().getMethod("getCurrent", new Class[0]);
            totalActiveSessions = totalActiveSessions + (Long)m.invoke(liveCount, new Object[0]);
        }
        return totalActiveSessions.intValue();
    }

    @Override
    public int getActiveSessions() throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public ApplicationBean getApplicationBean(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public boolean isStarted() throws Exception {
        this.appendToLog("Checking server state via JMX");
        boolean result = true;
        try {
            this.checkJMXConnection();
        }
        catch (IOException e) {
            result = false;
        }
        this.appendToLog("Server.started is '" + result + "'");
        return result;
    }

    @Override
    public List<ApplicationBean> listOfApplications() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Getting list of applications");
        ArrayList<ApplicationBean> applications = new ArrayList<ApplicationBean>();
        Set<ObjectName> managers = this.mbscnx.queryNames(new ObjectName("WebSphere:type=SessionManager,*"), null);
        for (ObjectName manager : managers) {
            String name = manager.getKeyProperty("mbeanIdentifier");
            if (name == null) continue;
            if ((name = name.substring(name.indexOf("/") + 1)).length() == 0) {
                name = "[ ROOT ]";
            }
            ApplicationBean applicationBean = new ApplicationBean(name, null);
            applicationBean.setState("Deployed");
            applications.add(applicationBean);
        }
        this.appendToLog("Got the list of applications");
        return applications;
    }

    @Override
    public void maintain() throws Exception {
    }

    @Override
    public String setDefault(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public void start() throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public void stop() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Stopping server");
        this.mbscnx.invoke(this.j2eeServer, "stop", null, null);
        this.appendToLog("Server is stoped");
    }

    @Override
    public void undeploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public String upload(ApplicationBean application) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }
}

