/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.AbstractAction;
import org.ow2.jasmine.jadort.service.action.DummyWorkerAction;
import org.ow2.jasmine.jadort.service.action.ModJKWorkerAction;
import org.ow2.jasmine.jadort.service.action.ModProxyBalancerWorkerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkerAction
extends AbstractAction {
    private static Map<String, WorkerAction> pool = new Hashtable<String, WorkerAction>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkerAction getWorkerAction(WorkerBean worker) {
        Map<String, WorkerAction> map = pool;
        synchronized (map) {
            String key = WorkerAction.getKey(worker);
            WorkerAction workerAction = pool.get(key);
            if (workerAction == null) {
                workerAction = WorkerAction.newInstance(worker);
                try {
                    workerAction.getState();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot get WorkerAction state. Make sure the worker for server '" + worker.getServerName() + "' on balancer '" + worker.getWorkerName() + "' does exist.");
                }
                pool.put(key, workerAction);
            }
            return workerAction;
        }
    }

    private static String getKey(WorkerBean worker) {
        StringBuilder sb = new StringBuilder();
        sb.append(worker.getName());
        sb.append(worker.getType());
        sb.append(worker.getConnector().getConnectorUrl());
        if (worker.getConnector().getUsername() != null && worker.getConnector().getPassword() != null) {
            sb.append(worker.getConnector().getUsername());
            sb.append(worker.getConnector().getPassword());
        }
        return sb.toString();
    }

    protected static WorkerAction newInstance(WorkerBean worker) {
        try {
            Constructor<? extends WorkerAction> constructor;
            if (worker.getType().equals(WorkerBean.Type.MOD_JK)) {
                constructor = WorkerAction.getConstructor(ModJKWorkerAction.class);
            } else if (worker.getType().equals(WorkerBean.Type.MOD_PROXY_BALANCER)) {
                constructor = WorkerAction.getConstructor(ModProxyBalancerWorkerAction.class);
            } else if (worker.getType().equals(WorkerBean.Type.DUMMY)) {
                constructor = WorkerAction.getConstructor(DummyWorkerAction.class);
            } else {
                throw new IllegalArgumentException("Unknown worker type :" + worker.getType());
            }
            return constructor.newInstance(worker);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed creating the worker action", e);
        }
    }

    protected static Constructor<? extends WorkerAction> getConstructor(Class<? extends WorkerAction> actionType) throws Exception {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = actionType.getDeclaredConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != 1 || params[0] != WorkerBean.class) continue;
            return constructor;
        }
        return null;
    }

    public abstract void activate() throws Exception;

    public abstract void disable() throws Exception;

    public abstract void stop() throws Exception;

    public abstract State getState() throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ACTIVE,
        DISABLED,
        STOPPED;

    }
}

