/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.TopologyBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.topology.xml.Balancer;
import org.ow2.jasmine.jadort.service.topology.xml.Server;
import org.ow2.jasmine.jadort.service.topology.xml.Target;
import org.ow2.jasmine.jadort.service.topology.xml.Topology;
import org.ow2.jasmine.jadort.service.topology.xml.URLConnector;
import org.ow2.jasmine.jadort.service.topology.xml.Worker;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Local(value={IJadortService.class})
@Remote(value={IJadortService.class})
@Stateful(mappedName="ow2.jasmine.jadort.ServiceSFB")
public class JadortServiceImpl
implements IJadortService {
    private static final int BUFFER_SIZE = 16384;
    private static final String XSD_PATH_JADORT = "XMLSchema/topology_JadortSpecific.xsd";
    private static final String XSD_PATH_DEPLOYME = "xml/topology.xsd";
    static final String QUEUE_NAME = "queue/JadortServiceJMSQueue";
    static final String SERVER_PROGRESS_ID = "serverProgressId";
    static final String WORKER_PROGRESS_ID = "workerProgressId";
    static final String APPLICATION_ID = "applicationId";
    static final String ACTION_TYPE = "actionType";
    static final String GROUP_CLUSTERED = "groupClustered";
    static final String APPLICATION_NAME = "applicationName";
    static final String OPERATION_TYPE = "operationType";
    static boolean DUMMY = false;
    private OperationStateBean operation;
    @PersistenceContext
    protected EntityManager em;
    protected QueueConnection qc;
    protected QueueSession session;
    protected Queue queue;

    @PostConstruct
    protected void initialize() {
        try {
            InitialContext ctx = new InitialContext();
            this.queue = (Queue)ctx.lookup(QUEUE_NAME);
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("QCF");
            this.qc = factory.createQueueConnection();
            this.session = this.qc.createQueueSession(false, 1);
        }
        catch (Exception e) {
            IllegalStateException exception = new IllegalStateException("Failed initializing a JadortService stateful bean: " + e.getMessage(), e);
            System.out.println(exception.getMessage());
            e.printStackTrace();
            throw exception;
        }
    }

    @PreDestroy
    protected void terminate() {
        try {
            this.session.close();
            this.qc.close();
        }
        catch (Exception e) {
            IllegalStateException exception = new IllegalStateException("Failed terminating a JadortService stateful bean: " + e.getMessage(), e);
            System.out.println(exception.getMessage());
            e.printStackTrace();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperationStateBean> getOperationsList() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            ArrayList<OperationStateBean> result = new ArrayList<OperationStateBean>();
            for (OperationStateBean operation : this.em.createQuery("select o from JaDOrT_OperationStateBean o order by o.date asc").getResultList()) {
                OperationStateBean temp = new OperationStateBean();
                temp.setAimedServerProgressState(operation.getAimedServerProgressState());
                temp.setAimedServerProgressProgress(operation.getAimedServerProgressProgress());
                temp.setCurrentStep(operation.getCurrentStep());
                temp.setDate(operation.getDate());
                temp.setId(operation.getId());
                temp.setName(operation.getName());
                result.add(temp);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStateBean getCurrentOperation() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            if (this.operation == null) {
                return null;
            }
            OperationStateBean bean = new OperationStateBean();
            bean.setAimedServerProgressState(this.operation.getAimedServerProgressState());
            bean.setAimedServerProgressProgress(this.operation.getAimedServerProgressProgress());
            bean.setAimedWorkerProgressState(this.operation.getAimedWorkerProgressState());
            bean.setAimedWorkerProgressProgress(this.operation.getAimedWorkerProgressProgress());
            bean.setApplication(this.operation.getApplication());
            bean.setCurrentStep(this.operation.getCurrentStep());
            bean.setDate(this.operation.getDate());
            bean.setServerProgressList(this.fetchServerProgressList());
            bean.setWorkerProgressList(this.fetchWorkerProgressList());
            bean.setAllServerProgressList(this.fetchMigratedServerProgressList());
            bean.setAllWorkerProgressList(this.fetchMigratedWorkerProgressList());
            bean.setId(this.operation.getId());
            bean.setName(this.operation.getName());
            bean.setSelectedGroup(this.fetchSelectedGroup());
            bean.setSelectedServers(this.fetchSelectedServers());
            if (this.operation.getTopology() != null) {
                TopologyBean topology = new TopologyBean();
                topology.setGroups(this.fetchGroups());
                topology.setId(this.operation.getTopology().getId());
                bean.setTopology(topology);
            }
            return bean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTopology(File xmlTopoFile) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
            try {
                this.loadJadortSpecificTopology(xmlTopoFile);
            }
            catch (UnmarshalException e1) {
                try {
                    this.loadDeployMETopology(xmlTopoFile);
                }
                catch (UnmarshalException e2) {
                    throw new JadortServiceException(xmlTopoFile.getName() + " is not a valid topology file.\n\nHere are some potentially helpful error messages:\n\t[" + XSD_PATH_JADORT + "] " + e1.getMessage() + "\n\t[" + XSD_PATH_DEPLOYME + "] " + e2.getMessage(), null);
                }
            }
            this.mergeOperation();
        }
    }

    protected void loadJadortSpecificTopology(File xmlTopoFile) throws UnmarshalException, JadortServiceException {
        Topology xmlTopology = this.loadSchemaAndFile(XSD_PATH_JADORT, Topology.class, xmlTopoFile);
        TopologyBean topologyBean = new TopologyBean();
        this.operation.setTopology(topologyBean);
        HashMap<String, Worker> workerXMLs = new HashMap<String, Worker>();
        for (Worker workerXML : xmlTopology.getWorker()) {
            workerXMLs.put(workerXML.getName(), workerXML);
        }
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (Topology.Group groupXML : xmlTopology.getGroup()) {
            GroupBean groupBean = new GroupBean();
            groupBean.setName(groupXML.getName());
            groupBean.setClustered(groupXML.isClustered());
            ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
            ArrayList<WorkerBean> workers = new ArrayList<WorkerBean>();
            for (Server serverXML : groupXML.getServer()) {
                List<Balancer> balancerXMLs;
                ServerBean serverBean = new ServerBean();
                serverBean.setName(serverXML.getName());
                if (serverXML.getCapacity() != null) {
                    serverBean.setCapacity(serverXML.getCapacity());
                }
                serverBean.setType(ServerBean.Type.valueOf(serverXML.getType().name()));
                serverBean.setServerConnector(this.createJMXConnectorBean(serverXML.getURLConnector()));
                if (serverXML.getManager() != null) {
                    serverBean.setManagerConnector(this.createJMXConnectorBean(serverXML.getManager().getURLConnector()));
                }
                Target targetXML = serverXML.getTarget();
                ServerBean target = null;
                if (targetXML != null) {
                    target = new ServerBean();
                    target.setName(targetXML.getName());
                    target.setType(ServerBean.Type.valueOf(targetXML.getType().name()));
                    target.setServerConnector(this.createJMXConnectorBean(targetXML.getURLConnector()));
                    if (targetXML.getManager() != null) {
                        target.setManagerConnector(this.createJMXConnectorBean(targetXML.getManager().getURLConnector()));
                    }
                    serverBean.setTarget(target);
                }
                if ((balancerXMLs = serverXML.getBalancer()) != null) {
                    for (Balancer balancerXML : balancerXMLs) {
                        Worker workerXML = (Worker)workerXMLs.get(balancerXML.getWorker());
                        if (workerXML == null) {
                            throw new JadortServiceException("There is no worker named \"" + balancerXML.getWorker() + "\", please check your topology file.", null);
                        }
                        WorkerBean workerBean = new WorkerBean();
                        workerBean.setName(balancerXML.getServer());
                        workerBean.setWorkerName(workerXML.getName());
                        workerBean.setType(WorkerBean.Type.valueOf(workerXML.getType().name()));
                        workerBean.setServerName(balancerXML.getServer());
                        workerBean.setConnector(this.createJMXConnectorBean(workerXML.getURLConnector()));
                        workerBean.setServer(serverBean);
                        workers.add(workerBean);
                    }
                }
                servers.add(serverBean);
            }
            groupBean.setServers(servers);
            groupBean.setWorkers(workers);
            groups.add(groupBean);
        }
        topologyBean.setGroups(groups);
    }

    protected void loadDeployMETopology(File xmlTopoFile) throws UnmarshalException, JadortServiceException {
        org.ow2.jasmine.deployme.generated.Topology xmlTopology = this.loadSchemaAndFile(XSD_PATH_DEPLOYME, org.ow2.jasmine.deployme.generated.Topology.class, xmlTopoFile);
        TopologyBean topologyBean = new TopologyBean();
        this.operation.setTopology(topologyBean);
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (Topology.Domains.Domain domain : xmlTopology.getDomains().getDomain()) {
            Configuration conf = domain.getConfiguration();
            String defaultHost = null;
            int defaultPort = 0;
            Configuration.Protocols protocols = null;
            if (conf != null) {
                if (conf.getGlobalJonas() != null) {
                    defaultHost = conf.getGlobalJonas().getHost();
                }
                protocols = conf.getProtocols();
            }
            if (defaultHost == null) {
                defaultHost = "localhost";
            }
            String defaultProtocol = null;
            if (protocols != null) {
                defaultProtocol = protocols.getProtocolsList();
                BigInteger jrmpPort = protocols.getJrmpPort();
                if (jrmpPort != null) {
                    defaultPort = jrmpPort.intValue();
                }
            }
            defaultProtocol = defaultProtocol != null ? defaultProtocol.split(",")[0] : "jrmp";
            GroupBean groupBean = new GroupBean();
            groupBean.setName(domain.getName());
            boolean clustered = false;
            try {
                clustered = conf.getActiveServices().getWeb().isHttpReplicationActivated().booleanValue();
            }
            catch (NullPointerException ignored) {
                // empty catch block
            }
            ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
            for (Topology.Domains.Domain.Servers.Server server : domain.getServers().getServer()) {
                String transport;
                conf = server.getConfiguration();
                String host = null;
                if (conf != null) {
                    if (conf.getGlobalJonas() != null) {
                        host = conf.getGlobalJonas().getHost();
                    }
                    protocols = conf.getProtocols();
                }
                if (host == null) {
                    host = defaultHost;
                }
                String name = server.getName();
                int port = defaultPort;
                String protocol = null;
                if (protocols != null) {
                    protocol = protocols.getProtocolsList();
                    BigInteger jrmpPort = protocols.getJrmpPort();
                    if (jrmpPort != null) {
                        port = jrmpPort.intValue();
                    }
                }
                if ((protocol = protocol != null ? protocol.split(",")[0] : defaultProtocol).equals("irmi")) {
                    transport = "rmi";
                    if (port == 0) {
                        port = 1098;
                    }
                } else if (protocol.equals("jrmp")) {
                    transport = "rmi";
                    if (port == 0) {
                        port = 1099;
                    }
                } else if (protocol.equals("iiop")) {
                    transport = "iiop";
                    if (port == 0) {
                        port = 2001;
                    }
                } else {
                    throw new JadortServiceException("Unknown protocol \"" + protocol + "\" for server \"" + name + "\".", null);
                }
                String jmxURL = "service:jmx:" + transport + "://" + host + "/jndi/" + transport + "://" + host + ":" + port + "/" + protocol + "connector_" + name;
                ConnectorBean connector = new ConnectorBean();
                connector.setConnectorUrl(jmxURL);
                ServerBean serverBean = new ServerBean();
                serverBean.setName(name);
                serverBean.setServerConnector(connector);
                if (DUMMY) {
                    serverBean.setType(ServerBean.Type.DUMMY);
                } else {
                    serverBean.setType(ServerBean.Type.JONAS);
                }
                servers.add(serverBean);
                try {
                    if (conf.getActiveServices().getWeb().isHttpReplicationActivated().booleanValue()) {
                        clustered = true;
                        continue;
                    }
                    clustered = false;
                }
                catch (NullPointerException ignored) {}
            }
            if (domain.getClusterDaemons() != null) {
                for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : domain.getClusterDaemons().getClusterDaemon()) {
                    int nb = 1;
                    String prefix = cd.getServerNamePrefix();
                    for (String serverName : cd.getServers().getServerName()) {
                        boolean found = false;
                        for (ServerBean s : servers) {
                            String transport;
                            if (!s.getName().equals(serverName)) continue;
                            s.setName(prefix + nb);
                            s.getServerConnector().setConnectorUrl(s.getServerConnector().getConnectorUrl().replace("connector_" + serverName, "connector_" + s.getName()));
                            ++nb;
                            String protocol = cd.getClusterDaemonProtocol();
                            protocol = protocol != null ? protocol.split(",")[0] : defaultProtocol;
                            int port = defaultPort;
                            Integer portInteger = cd.getClusterDaemonPort();
                            if (portInteger != null) {
                                port = portInteger;
                            }
                            if (protocol.equals("irmi")) {
                                transport = "rmi";
                                if (port == 0) {
                                    port = 1098;
                                }
                            } else if (protocol.equals("jrmp")) {
                                transport = "rmi";
                                if (port == 0) {
                                    port = 1099;
                                }
                            } else if (protocol.equals("iiop")) {
                                transport = "iiop";
                                if (port == 0) {
                                    port = 2001;
                                }
                            } else {
                                throw new JadortServiceException("Unknown protocol \"" + protocol + "\" for cluster daemon \"" + cd.getName() + "\".", null);
                            }
                            String serverURL = s.getServerConnector().getConnectorUrl();
                            int hostStart = serverURL.indexOf("://") + 3;
                            String host = serverURL.substring(hostStart, serverURL.indexOf(47, hostStart));
                            String jmxURL = "service:jmx:" + transport + "://" + host + "/jndi/" + transport + "://" + host + ":" + port + "/" + protocol + "connector_" + cd.getName();
                            ConnectorBean manager = new ConnectorBean();
                            manager.setConnectorUrl(jmxURL);
                            s.setManagerConnector(manager);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new JadortServiceException("Cannot find server \"" + serverName + "\" for cluster daemon \"" + cd.getName() + "\".", null);
                    }
                }
            }
            groupBean.setServers(servers);
            groupBean.setClustered(clustered);
            groups.add(groupBean);
        }
        topologyBean.setGroups(groups);
    }

    protected <T> T loadSchemaAndFile(String xsdPath, Class<T> rootClass, File xmlFile) throws JadortServiceException, UnmarshalException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)rootClass.getPackage().getName());
            Unmarshaller unMarshaller = jc.createUnmarshaller();
            URL xsdURL = this.getClass().getClassLoader().getResource(xsdPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsdURL);
            unMarshaller.setSchema(schema);
            return (T)unMarshaller.unmarshal(xmlFile);
        }
        catch (JAXBException e) {
            if (e instanceof UnmarshalException) {
                UnmarshalException ue = (UnmarshalException)((Object)e);
                if (ue.getLinkedException() != null) {
                    throw new UnmarshalException(ue.getLinkedException().getMessage(), (Throwable)e);
                }
                throw ue;
            }
            throw new JadortServiceException("Error creating the topology parser: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new JadortServiceException("Error creating the topology parser: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectorBean createJMXConnectorBean(URLConnector urlConnector) {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            ConnectorBean jmxConnectorBean = new ConnectorBean();
            jmxConnectorBean.setConnectorUrl(urlConnector.getURL());
            if (urlConnector.getUsername() != null && urlConnector.getPassword() != null) {
                jmxConnectorBean.setUsername(urlConnector.getUsername());
                jmxConnectorBean.setPassword(urlConnector.getPassword());
            }
            return jmxConnectorBean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GroupBean> getGroups() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_GROUP, OperationStateBean.Step.SELECT_APPLICATION);
            return this.fetchGroups();
        }
    }

    private List<GroupBean> fetchGroups() {
        if (this.operation.getTopology() != null && this.operation.getTopology().getGroups() != null) {
            ArrayList<GroupBean> result = new ArrayList<GroupBean>(this.operation.getTopology().getGroups().size());
            for (GroupBean groupBean : this.operation.getTopology().getGroups()) {
                GroupBean groupBeanCopy = new GroupBean();
                groupBeanCopy.setApplications(new ArrayList<ApplicationBean>(groupBean.getApplications()));
                groupBeanCopy.setId(groupBean.getId());
                groupBeanCopy.setWorkers(new ArrayList<WorkerBean>(groupBean.getWorkers()));
                groupBeanCopy.setName(groupBean.getName());
                groupBeanCopy.setServers(new ArrayList<ServerBean>(groupBean.getServers()));
                groupBeanCopy.setClustered(groupBean.getClustered());
                result.add(groupBeanCopy);
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectGroup(GroupBean selectedGroup, IJadortService.OperationType operationType) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_GROUP);
            for (GroupBean group : this.operation.getTopology().getGroups()) {
                if (!group.getId().equals(selectedGroup.getId())) continue;
                if (operationType.equals(IJadortService.OperationType.MIGRATE)) {
                    ArrayList<ServerProgressBean> oldServerProgressList = null;
                    if (this.operation.getServerProgressList() != null) {
                        oldServerProgressList = new ArrayList<ServerProgressBean>(this.operation.getServerProgressList());
                    }
                    this.operation.setSelectedGroup(group);
                    this.operation.setType(operationType);
                    ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                    for (ServerBean server : group.getServers()) {
                        ServerProgressBean serverProgressBean = new ServerProgressBean(server);
                        serverProgressList.add(serverProgressBean);
                    }
                    this.operation.setServerProgressList(serverProgressList);
                    this.mergeOperation();
                    if (oldServerProgressList != null) {
                        for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                            this.em.remove((Object)serverProgressBean);
                        }
                        this.em.flush();
                    }
                } else if (operationType.equals(IJadortService.OperationType.MAINTAIN)) {
                    HashSet<ServerProgressBean> oldServerProgressList = new HashSet<ServerProgressBean>();
                    HashSet<WorkerProgressBean> oldWorkerProgressList = new HashSet<WorkerProgressBean>();
                    if (this.operation.getServerProgressList() != null) {
                        oldServerProgressList.addAll(this.operation.getServerProgressList());
                    }
                    if (this.operation.getAllServerProgressList() != null) {
                        oldServerProgressList.addAll(this.operation.getAllServerProgressList());
                    }
                    if (this.operation.getWorkerProgressList() != null) {
                        oldWorkerProgressList.addAll(this.operation.getWorkerProgressList());
                    }
                    if (this.operation.getAllWorkerProgressList() != null) {
                        oldWorkerProgressList.addAll(this.operation.getAllWorkerProgressList());
                    }
                    this.operation.setServerProgressList(null);
                    this.operation.setWorkerProgressList(null);
                    this.operation.setAllServerProgressList(null);
                    this.operation.setAllWorkerProgressList(null);
                    this.operation.setSelectedGroup(group);
                    this.operation.setType(operationType);
                    this.mergeOperation();
                    for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                        this.em.remove((Object)serverProgressBean);
                    }
                    for (WorkerProgressBean workerProgressBean : oldWorkerProgressList) {
                        this.em.remove((Object)workerProgressBean);
                    }
                    this.em.flush();
                } else {
                    throw new IllegalStateException("Unknown OperationType: " + operationType);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveSessions() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            this.refreshActiveSessions();
            int activeSessions = 0;
            for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                activeSessions += serverProgressBean.getServer().getActiveSessions();
            }
            return activeSessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerProgressBean> getServerProgressList() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.refreshActiveSessions();
            this.checkStep(OperationStateBean.Step.SELECT_SERVERS, OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, OperationStateBean.Step.FINISHED);
            return this.fetchServerProgressList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkerProgressBean> getWorkerProgressList() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_SERVERS, OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, OperationStateBean.Step.FINISHED);
            return this.fetchWorkerProgressList();
        }
    }

    private void refreshActiveSessions() throws JadortServiceException {
        block12: {
            try {
                IJadortService.OperationType type = this.operation.getType();
                if (type == null) break block12;
                if (type.equals(IJadortService.OperationType.MIGRATE)) {
                    if (this.operation.getServerProgressList() != null) {
                        for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                            ServerAction serverAction = ServerAction.getServerAction(serverProgressBean.getServer());
                            String oldApplication = serverProgressBean.getOldApplication();
                            if (oldApplication != null) {
                                try {
                                    serverProgressBean.getServer().setActiveSessions(serverAction.getActiveSessions(oldApplication));
                                }
                                catch (Exception ignored) {
                                    serverProgressBean.getServer().setActiveSessions(0);
                                }
                                continue;
                            }
                            serverProgressBean.getServer().setActiveSessions(0);
                        }
                    }
                    break block12;
                }
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                        ServerAction serverAction = ServerAction.getServerAction(server);
                        try {
                            server.setActiveSessions(serverAction.getActiveSessions());
                        }
                        catch (Exception ignored) {
                            server.setActiveSessions(0);
                        }
                    }
                    break block12;
                }
                throw new IllegalStateException("Unknown operation type: " + type);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot get the number of active sessions: " + e.getMessage(), e);
            }
        }
    }

    private void refreshMaintainStatus() throws JadortServiceException {
        for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
            boolean maintained = false;
            if (this.operation.getAllServerProgressList() != null) {
                for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                    if (!serverProgress.getServer().equals(server)) continue;
                    maintained = serverProgress.getProgress() == 100;
                    break;
                }
            }
            server.setMaintained(maintained);
        }
    }

    private List<ServerProgressBean> fetchServerProgressList() throws JadortServiceException {
        if (this.operation.getServerProgressList() != null) {
            return new ArrayList<ServerProgressBean>(this.operation.getServerProgressList());
        }
        return null;
    }

    private Set<ServerProgressBean> fetchMigratedServerProgressList() throws JadortServiceException {
        if (this.operation.getAllServerProgressList() != null) {
            return new HashSet<ServerProgressBean>(this.operation.getAllServerProgressList());
        }
        return null;
    }

    private List<ServerBean> fetchServers() {
        if (this.operation.getSelectedGroup().getServers() != null) {
            return new ArrayList<ServerBean>(this.operation.getSelectedGroup().getServers());
        }
        return null;
    }

    private List<WorkerProgressBean> fetchWorkerProgressList() throws JadortServiceException {
        if (this.operation.getWorkerProgressList() != null) {
            return new ArrayList<WorkerProgressBean>(this.operation.getWorkerProgressList());
        }
        return null;
    }

    private Set<WorkerProgressBean> fetchMigratedWorkerProgressList() {
        if (this.operation.getAllWorkerProgressList() != null) {
            return new HashSet<WorkerProgressBean>(this.operation.getAllWorkerProgressList());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupBean getSelectedGroup() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_APPLICATION, OperationStateBean.Step.SELECT_SERVERS);
            return this.fetchSelectedGroup();
        }
    }

    private GroupBean fetchSelectedGroup() {
        if (this.operation.getSelectedGroup() != null) {
            GroupBean bean = new GroupBean();
            bean.setApplications(new ArrayList<ApplicationBean>(this.operation.getSelectedGroup().getApplications()));
            bean.setId(this.operation.getSelectedGroup().getId());
            bean.setWorkers(new ArrayList<WorkerBean>(this.operation.getSelectedGroup().getWorkers()));
            bean.setName(this.operation.getSelectedGroup().getName());
            bean.setServers(new ArrayList<ServerBean>(this.operation.getSelectedGroup().getServers()));
            bean.setClustered(this.operation.getSelectedGroup().getClustered());
            return bean;
        }
        return null;
    }

    private List<ServerBean> fetchSelectedServers() throws JadortServiceException {
        if (this.operation.getSelectedServers() != null) {
            return new ArrayList<ServerBean>(this.operation.getSelectedServers());
        }
        return null;
    }

    private ServerProgressBean getServerProgress(ServerBean server) {
        for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
            if (!serverProgressBean.getServer().equals(server)) continue;
            return serverProgressBean;
        }
        return null;
    }

    private WorkerProgressBean getWorkerProgress(WorkerBean worker) {
        for (WorkerProgressBean workerProgressBean : this.operation.getWorkerProgressList()) {
            if (!workerProgressBean.getWorker().getId().equals(worker.getId())) continue;
            return workerProgressBean;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nextExecuteMigration() {
        if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
                    serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setWorkerProgressState(this.operation.getAimedWorkerProgressState());
                    workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                ServerProgressBean.ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
                WorkerProgressBean.WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
                if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.INITIAL)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(20);
                    this.operation.setAimedWorkerProgressProgress(20);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(20);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(40);
                    this.operation.setAimedWorkerProgressProgress(40);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(40);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedServerProgressProgress(60);
                    this.operation.setAimedWorkerProgressProgress(60);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(60);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.START_OK);
                    this.operation.setAimedServerProgressProgress(80);
                    this.operation.setAimedWorkerProgressProgress(80);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(80);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else {
                    if (!aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) throw new IllegalStateException("Unknown WorkerProgressState: " + aimedWorkerProgressState);
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.START_OK);
                    this.operation.setAimedServerProgressProgress(100);
                    this.operation.setAimedWorkerProgressProgress(100);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(100);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                }
                return;
            } else {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
                    serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setWorkerProgressState(this.operation.getAimedWorkerProgressState());
                    workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                ServerProgressBean.ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
                WorkerProgressBean.WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
                if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK);
                    this.operation.setAimedServerProgressProgress(16);
                    this.operation.setAimedWorkerProgressProgress(16);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(16);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.INITIAL)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(33);
                    this.operation.setAimedWorkerProgressProgress(33);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(33);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(50);
                    this.operation.setAimedWorkerProgressProgress(50);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(50);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedServerProgressProgress(66);
                    this.operation.setAimedWorkerProgressProgress(66);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(66);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.START_OK);
                    this.operation.setAimedServerProgressProgress(83);
                    this.operation.setAimedWorkerProgressProgress(83);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(83);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else {
                    if (!aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) throw new IllegalStateException("Unknown WorkerProgressState: " + aimedWorkerProgressState);
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.START_OK);
                    this.operation.setAimedServerProgressProgress(100);
                    this.operation.setAimedWorkerProgressProgress(100);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(100);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                }
            }
            return;
        } else {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
                serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
            ServerProgressBean.ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
            if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.UPLOAD_OK);
                this.operation.setAimedServerProgressProgress(33);
            } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UPLOAD_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.DEPLOY_OK);
                this.operation.setAimedServerProgressProgress(66);
            } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DEPLOY_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK);
                this.operation.setAimedServerProgressProgress(100);
            } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.UNDEPLOY_OK);
                this.operation.setAimedServerProgressProgress(50);
            } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UNDEPLOY_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.ERASE_OK);
                this.operation.setAimedServerProgressProgress(100);
            } else {
                if (!aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UNDEPLOY_OK)) throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.ERASE_OK);
                this.operation.setAimedServerProgressProgress(100);
            }
            this.mergeOperation();
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                this.reachAimedServerProgressState(serverProgress);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void previousExecuteMigration() {
        if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
                    serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setWorkerProgressState(this.operation.getAimedWorkerProgressState());
                    workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                ServerProgressBean.ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
                WorkerProgressBean.WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
                if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.START_OK)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(80);
                    this.operation.setAimedWorkerProgressProgress(80);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(80);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.START_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedServerProgressProgress(60);
                    this.operation.setAimedWorkerProgressProgress(60);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(60);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(40);
                    this.operation.setAimedWorkerProgressProgress(40);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(40);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.INITIAL);
                    this.operation.setAimedServerProgressProgress(20);
                    this.operation.setAimedWorkerProgressProgress(20);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(20);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else {
                    if (!aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) throw new IllegalStateException("Unknown WorkerProgressState: " + aimedWorkerProgressState);
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.INITIAL);
                    this.operation.setAimedServerProgressProgress(0);
                    this.operation.setAimedWorkerProgressProgress(0);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(0);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                }
                return;
            } else {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
                    serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setWorkerProgressState(this.operation.getAimedWorkerProgressState());
                    workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
                }
                ServerProgressBean.ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
                WorkerProgressBean.WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
                if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.START_OK)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(83);
                    this.operation.setAimedWorkerProgressProgress(83);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(83);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.START_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedServerProgressProgress(66);
                    this.operation.setAimedWorkerProgressProgress(66);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(66);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
                    this.operation.setAimedServerProgressProgress(50);
                    this.operation.setAimedWorkerProgressProgress(50);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(50);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK);
                    this.operation.setAimedServerProgressProgress(33);
                    this.operation.setAimedWorkerProgressProgress(33);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(33);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                    return;
                } else if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.INITIAL);
                    this.operation.setAimedServerProgressProgress(16);
                    this.operation.setAimedWorkerProgressProgress(16);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.setProgress(16);
                    }
                    this.mergeOperation();
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        this.reachAimedWorkerProgressState(workerProgress);
                    }
                    return;
                } else {
                    if (!aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK)) throw new IllegalStateException("Unknown WorkerProgressState: " + aimedWorkerProgressState);
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.INITIAL);
                    this.operation.setAimedServerProgressProgress(0);
                    this.operation.setAimedWorkerProgressProgress(0);
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgress.setProgress(0);
                    }
                    this.mergeOperation();
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        this.reachAimedServerProgressState(serverProgress);
                    }
                }
            }
            return;
        } else {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
                serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
            ServerProgressBean.ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
            if (!aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UPLOAD_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.INITIAL);
                    this.operation.setAimedServerProgressProgress(0);
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DEPLOY_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.UPLOAD_OK);
                    this.operation.setAimedServerProgressProgress(33);
                } else if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.DEPLOY_OK);
                    this.operation.setAimedServerProgressProgress(66);
                } else {
                    if (!aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UNDEPLOY_OK)) throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK);
                    this.operation.setAimedServerProgressProgress(100);
                }
            }
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                this.reachAimedServerProgressState(serverProgress);
            }
            this.mergeOperation();
        }
    }

    private void reachAimedServerProgressState(ServerProgressBean serverProgress) {
        ServerProgressBean.ServerProgressState aimedServerProgressState;
        ServerProgressBean.ServerProgressState currentServerProgressState;
        block46: {
            currentServerProgressState = serverProgress.getServerProgressState();
            aimedServerProgressState = this.operation.getAimedServerProgressState();
            try {
                IJadortService.OperationType type = this.operation.getType();
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    if (this.operation.getSelectedGroup().getClustered()) {
                        if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                            if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                                this.stopServer(serverProgress);
                                return;
                            }
                            break block46;
                        }
                        if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                            if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                                this.maintainServer(serverProgress);
                                return;
                            }
                            if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                                this.startServer(serverProgress);
                                return;
                            }
                            break block46;
                        }
                        if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                            if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.START_OK)) {
                                this.startServer(serverProgress);
                                return;
                            }
                            if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                                this.maintainServer(serverProgress);
                                return;
                            }
                            break block46;
                        }
                        if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.START_OK)) {
                            if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                                this.stopServer(serverProgress);
                                return;
                            }
                            break block46;
                        }
                        throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                            this.disableApplications(serverProgress);
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                            this.stopServer(serverProgress);
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                            this.enableApplications(serverProgress);
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                            this.maintainServer(serverProgress);
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                            this.startServer(serverProgress);
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.START_OK)) {
                            this.startServer(serverProgress);
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK)) {
                            this.maintainServer(serverProgress);
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.START_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) {
                            this.stopServer(serverProgress);
                            return;
                        }
                        break block46;
                    }
                    throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                }
                if (type.equals(IJadortService.OperationType.MIGRATE)) {
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UPLOAD_OK)) {
                            this.upload(serverProgress, this.operation.getApplication());
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.UPLOAD_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DEPLOY_OK)) {
                            this.deploy(serverProgress, serverProgress.getNewApplication());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                            this.erase(serverProgress, serverProgress.getNewApplication());
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.DEPLOY_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                            this.setAsDefault(serverProgress, serverProgress.getNewApplication());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UPLOAD_OK)) {
                            this.undeploy(serverProgress, serverProgress.getNewApplication());
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.UNDEPLOY_OK)) {
                            if (!serverProgress.hasOldVersion()) {
                                throw new Exception("There's no old version or the old and new versions are the same");
                            }
                            this.undeploy(serverProgress, serverProgress.getOldApplication());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.DEPLOY_OK)) {
                            if (serverProgress.getOldApplication() == null) {
                                serverProgress.appendToLog("There's no old version, ignoring step.\nThis implies that the new [and only] version will keep on being the default one.");
                                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                                serverProgress.setServerProgressState(aimedServerProgressState);
                                serverProgress.setProgress(this.operation.getAimedServerProgressProgress());
                            } else {
                                this.setAsDefault(serverProgress, serverProgress.getOldApplication());
                            }
                            return;
                        }
                        break block46;
                    }
                    if (currentServerProgressState.equals(ServerProgressBean.ServerProgressState.UNDEPLOY_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.ERASE_OK)) {
                            if (!serverProgress.hasOldVersion()) {
                                throw new Exception("There's no old version or the old and new versions are the same");
                            }
                            this.erase(serverProgress, serverProgress.getOldApplication());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                            this.deploy(serverProgress, serverProgress.getOldApplication());
                            return;
                        }
                        break block46;
                    }
                    throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                }
                throw new IllegalStateException("Unknown OperationType: " + type);
            }
            catch (Exception e) {
                serverProgress.appendToLog("Failed executing server action: " + e.getClass().getCanonicalName() + ", " + e.getMessage());
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                return;
            }
        }
        serverProgress.appendToLog("Don't know what to do: operation.getAimedServerProgressState() is " + aimedServerProgressState + ", serverProgress.getServerProgressState() is " + currentServerProgressState);
        serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
    }

    private void reachAimedWorkerProgressState(WorkerProgressBean workerProgress) {
        WorkerProgressBean.WorkerProgressState aimedWorkerProgressState;
        WorkerProgressBean.WorkerProgressState currentWorkerProgressState;
        block10: {
            currentWorkerProgressState = workerProgress.getWorkerProgressState();
            aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
            try {
                IJadortService.OperationType type = this.operation.getType();
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    if (currentWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.INITIAL)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) {
                            this.stopWorker(workerProgress);
                            return;
                        }
                        break block10;
                    }
                    if (currentWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.START_OK)) {
                            this.startWorker(workerProgress);
                            return;
                        }
                        if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.INITIAL)) {
                            this.startWorker(workerProgress);
                            return;
                        }
                        break block10;
                    }
                    if (currentWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.START_OK)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) {
                            this.stopWorker(workerProgress);
                            return;
                        }
                        break block10;
                    }
                    throw new IllegalStateException("Unknown WorkerProgressState: " + currentWorkerProgressState);
                }
                throw new IllegalStateException("Unknown OperationType: " + type);
            }
            catch (Exception e) {
                workerProgress.appendToLog("Failed executing server action: " + e.getClass().getCanonicalName() + ", " + e.getMessage());
                workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                return;
            }
        }
        workerProgress.appendToLog("Don't know what to do: operation.getAimedWorkerProgressState() is " + aimedWorkerProgressState + ", workerProgress.getAimedWorkerProgressState() is " + currentWorkerProgressState);
        workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
    }

    private void upload(ServerProgressBean serverProgress, ApplicationBean application) throws JMSException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.UPLOAD.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(APPLICATION_ID, application.getId().intValue());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void deploy(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
            serverProgress.setProgress(this.operation.getAimedServerProgressProgress());
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            serverProgress.appendToLog("The application to deploy is null !");
        } else {
            Message message = this.session.createMessage();
            message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
            message.setStringProperty(ACTION_TYPE, ActionType.DEPLOY.toString());
            message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
            message.setStringProperty(APPLICATION_NAME, applicationName);
            QueueSender sender = this.session.createSender(this.queue);
            sender.send(message);
        }
    }

    private void setAsDefault(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
            serverProgress.setProgress(this.operation.getAimedServerProgressProgress());
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            serverProgress.appendToLog("The application to set as default is null !");
        } else {
            Message message = this.session.createMessage();
            message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
            message.setStringProperty(ACTION_TYPE, ActionType.SET_DEFAULT.toString());
            message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
            message.setStringProperty(APPLICATION_NAME, applicationName);
            QueueSender sender = this.session.createSender(this.queue);
            sender.send(message);
        }
    }

    private void undeploy(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
            serverProgress.setProgress(this.operation.getAimedServerProgressProgress());
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            serverProgress.appendToLog("The application to undeploy is null !");
        } else {
            Message message = this.session.createMessage();
            message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
            message.setStringProperty(ACTION_TYPE, ActionType.UNDEPLOY.toString());
            message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
            message.setStringProperty(APPLICATION_NAME, applicationName);
            QueueSender sender = this.session.createSender(this.queue);
            sender.send(message);
        }
    }

    private void erase(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
            serverProgress.setProgress(this.operation.getAimedServerProgressProgress());
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            serverProgress.appendToLog("The application to erase is null !");
        } else {
            Message message = this.session.createMessage();
            message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
            message.setStringProperty(ACTION_TYPE, ActionType.ERASE.toString());
            message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
            message.setStringProperty(APPLICATION_NAME, applicationName);
            QueueSender sender = this.session.createSender(this.queue);
            sender.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Server state for server '" + server.getName() + "' is " + serverProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            this.mergeOperation();
            this.reachAimedServerProgressState(this.getServerProgress(server));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Server state for server '" + server.getName() + "' is " + serverProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            serverProgress.appendToLog("Error on the server has been ignored by the user");
            serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
            serverProgress.setServerProgressState(this.operation.getAimedServerProgressState());
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) {
                throw new JadortServiceException("Server state for server '" + server.getName() + "' is " + serverProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.RUNNING, null);
            }
            serverProgress.appendToLog("Action has been aborted by the user");
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            serverProgress.setProgress(this.operation.getAimedServerProgressProgress());
            this.mergeOperation();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            try {
                boolean result = true;
                ServerProgressBean serverProgress = this.getServerProgress(server);
                ServerAction serverAction = ServerAction.getServerAction(serverProgress.getServer());
                List<ApplicationBean> applications = serverAction.listOfApplications();
                ServerProgressBean.ServerProgressState serverProgressState = serverProgress.getServerProgressState();
                if (serverProgressState.equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                    IJadortService.OperationType type = this.operation.getType();
                    if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                        result = serverAction.isStarted();
                    } else {
                        if (!type.equals(IJadortService.OperationType.MIGRATE)) throw new IllegalStateException("Unknown OperationType: " + type);
                        for (ApplicationBean application : applications) {
                            if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, null, null)) {
                                result = false;
                            } else if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewApplication()), application) && !this.checkApplication(serverProgress, application, null, null)) {
                                result = false;
                            } else {
                                if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldApplication()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                                result = false;
                            }
                            break;
                        }
                    }
                } else if (serverProgressState.equals(ServerProgressBean.ServerProgressState.UPLOAD_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Present", null)) {
                            result = false;
                        } else if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewApplication()), application) && !this.checkApplication(serverProgress, application, "Present", null)) {
                            result = false;
                        } else {
                            if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldApplication()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                            result = false;
                        }
                        break;
                    }
                } else if (serverProgressState.equals(ServerProgressBean.ServerProgressState.DEPLOY_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Reserved")) {
                            result = false;
                        } else if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewApplication()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Reserved")) {
                            result = false;
                        } else {
                            if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldApplication()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                            result = false;
                        }
                        break;
                    }
                } else if (serverProgressState.equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            result = false;
                        } else if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewApplication()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            result = false;
                        } else {
                            if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldApplication()), application) || this.checkApplication(serverProgress, application, "Deployed", "Disabled")) continue;
                            result = false;
                        }
                        break;
                    }
                } else if (serverProgressState.equals(ServerProgressBean.ServerProgressState.UNDEPLOY_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            result = false;
                        } else if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewApplication()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            result = false;
                        } else {
                            if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldApplication()), application) || this.checkApplication(serverProgress, application, "Present", null)) continue;
                            result = false;
                        }
                        break;
                    }
                } else if (serverProgressState.equals(ServerProgressBean.ServerProgressState.ERASE_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            result = false;
                        } else if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewApplication()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            result = false;
                        } else {
                            if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldApplication()), application) || this.checkApplication(serverProgress, application, null, null)) continue;
                            result = false;
                        }
                        break;
                    }
                } else if (serverProgressState.equals(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK) || serverProgressState.equals(ServerProgressBean.ServerProgressState.START_OK)) {
                    result = serverAction.isStarted();
                } else {
                    if (!serverProgressState.equals(ServerProgressBean.ServerProgressState.STOP_OK) && !serverProgressState.equals(ServerProgressBean.ServerProgressState.MAINTAIN_OK)) throw new IllegalStateException("Unknown ServerProgressState: " + serverProgressState);
                    result = !serverAction.isStarted();
                }
                this.mergeOperation();
                return result;
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot check server '" + server + "': " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean checkWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            try {
                boolean result = true;
                WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
                WorkerAction workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                WorkerAction.State state = workerAction.getState();
                WorkerProgressBean.WorkerProgressState workerProgressState = workerProgress.getWorkerProgressState();
                if (workerProgressState.equals(WorkerProgressBean.WorkerProgressState.INITIAL) || workerProgressState.equals(WorkerProgressBean.WorkerProgressState.START_OK)) {
                    result = state == WorkerAction.State.ACTIVE;
                } else if (workerProgressState.equals(WorkerProgressBean.WorkerProgressState.STOP_OK)) {
                    result = state == WorkerAction.State.STOPPED;
                } else {
                    throw new IllegalStateException("Unknown WorkerProgressState: " + workerProgressState);
                }
                this.mergeOperation();
                return result;
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot check worker '" + worker + "': " + e.getMessage(), e);
            }
        }
    }

    protected boolean isSameApplication(ApplicationBean a1, ApplicationBean a2) {
        if (a1 == null || a2 == null || a1.getName() == null) {
            return false;
        }
        return a1.getName().equals(a2.getName()) && (a1.getVersion() == a2.getVersion() || a1.getVersion() != null && a1.getVersion().equals(a2.getVersion()));
    }

    protected boolean checkApplication(ServerProgressBean serverProgress, ApplicationBean application, String state, String policy) {
        if (state == null) {
            if (application != null) {
                serverProgress.appendToLog("Application " + application + " exists (it should not exist), checkServer will return false");
                return false;
            }
            return true;
        }
        if (state.equals(application.getState())) {
            if (policy == null) {
                if (application.getPolicy() != null) {
                    serverProgress.appendToLog("Application " + application + " has policy " + application.getPolicy() + " (it should not have any), checkServer will return false");
                    return false;
                }
                return true;
            }
            if (!policy.equals(application.getPolicy())) {
                serverProgress.appendToLog("Application " + application + " has policy " + application.getPolicy() + " instead of " + policy + ", checkServer will return false");
                return false;
            }
            return true;
        }
        serverProgress.appendToLog("Application " + application + " has state " + application.getState() + " instead of " + state + ", checkServer will return false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createApplication(URL url) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            ApplicationBean applicationBean;
            File file;
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_APPLICATION);
            if (url.getProtocol().equals("file")) {
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new JadortServiceException("Cannot create file for URL '" + url + "': " + e.getMessage(), e);
                }
            }
            try {
                int read;
                URLConnection connection = url.openConnection();
                InputStream reader = connection.getInputStream();
                String name = url.getPath();
                name = name.substring(name.lastIndexOf(47));
                file = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "jadort.temp." + System.currentTimeMillis());
                file.mkdirs();
                file = new File(file, name);
                FileOutputStream writer = new FileOutputStream(file);
                byte[] buffer = new byte[16384];
                while ((read = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, read);
                }
                writer.close();
                reader.close();
            }
            catch (IOException e) {
                throw new JadortServiceException("Cannot read from URL: '" + url + "'", null);
            }
            try {
                applicationBean = new ApplicationBean(file);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot create application for URL '" + url + "': " + e.getMessage(), e);
            }
            this.operation.setApplication(applicationBean);
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationBean getApplication() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            if (this.operation == null) {
                return null;
            }
            return this.operation.getApplication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStateBean.Step getCurrentStep() {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            if (this.operation == null) {
                return OperationStateBean.Step.SELECT_OPERATION;
            }
            return this.operation.getCurrentStep();
        }
    }

    private void getApplications() throws JadortServiceException {
        for (GroupBean groupBean : this.operation.getTopology().getGroups()) {
            ArrayList<ApplicationBean> applications = new ArrayList<ApplicationBean>();
            ServerBean serverBean = groupBean.getServers().iterator().next();
            try {
                for (ApplicationBean applicationBean : ServerAction.getServerAction(serverBean).listOfApplications()) {
                    applications.add(applicationBean);
                }
            }
            catch (Exception e) {
                String message = e.getClass().getName() + ": " + e.getMessage();
                throw new JadortServiceException("Failed getting the applications on the servers: " + message, e);
            }
            groupBean.setApplications(applications);
        }
    }

    private boolean hasOldVersion() {
        for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
            if (!serverProgress.hasOldVersion()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void next() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            if (!this.canGoToNextStep()) {
                throw new JadortServiceException("You are not allowed to go to the next step!", null);
            }
            if (this.getCurrentStep().equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || this.getCurrentStep().equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
                if (!this.operation.getAimedWorkerProgressState().equals(WorkerProgressBean.WorkerProgressState.START_OK)) {
                    this.nextExecuteMigration();
                } else {
                    for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                        serverProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                    for (WorkerProgressBean workerProgressBean : this.operation.getWorkerProgressList()) {
                        workerProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                    this.goToNextStep();
                }
            } else if (this.getCurrentStep().equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                    if (this.hasOldVersion()) {
                        for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                            serverProgressServer.setProgress(0);
                        }
                    } else {
                        for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                            serverProgressServer.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                        }
                        this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
                    }
                    this.goToNextStep();
                } else {
                    this.nextExecuteMigration();
                }
            } else if (this.getCurrentStep().equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressBean.ServerProgressState.ERASE_OK)) {
                    for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                        serverProgressServer.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                    this.goToNextStep();
                } else {
                    this.nextExecuteMigration();
                }
            } else {
                this.goToNextStep();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void goToNextStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION)) {
            this.operation.setCurrentStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
        } else if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            this.getApplications();
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_GROUP);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            IJadortService.OperationType operationType = this.getOperationType();
            if (operationType.equals(IJadortService.OperationType.MIGRATE)) {
                this.getApplications();
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_APPLICATION);
            } else {
                if (!operationType.equals(IJadortService.OperationType.MAINTAIN)) throw new IllegalStateException("Unknown OperationType: " + operationType);
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
            }
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            if (this.allServersHaveBeenMaintained()) {
                ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                    serverProgressList.add(serverProgress);
                }
                this.operation.setServerProgressList(serverProgressList);
                ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
                for (WorkerProgressBean workerProgress : this.operation.getAllWorkerProgressList()) {
                    workerProgressList.add(workerProgress);
                }
                this.operation.setWorkerProgressList(workerProgressList);
                this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
            } else {
                this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.INITIAL);
                this.operation.setAimedWorkerProgressProgress(0);
                this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.INITIAL);
                this.operation.setAimedServerProgressProgress(0);
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
                this.operation.setSelectedServers(null);
            }
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
        } else {
            if (!currentStep.equals(OperationStateBean.Step.FINISHED)) throw new IllegalStateException("Unknown Step: " + currentStep);
            throw new IllegalStateException("No next for Step: " + currentStep);
        }
        this.mergeOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previous() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            if (!this.canGoToPreviousStep()) {
                throw new JadortServiceException("You are not allowed to go to the previous step!", null);
            }
            OperationStateBean.Step currentStep = this.getCurrentStep();
            if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
                TopologyBean oldTopology = this.operation.getTopology();
                this.operation.setTopology(null);
                this.goToPreviousStep();
                this.em.remove((Object)oldTopology);
                this.em.flush();
            } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
                ArrayList<ServerProgressBean> oldServerProgressList = new ArrayList<ServerProgressBean>(this.operation.getServerProgressList());
                this.operation.setServerProgressList(null);
                this.operation.setSelectedGroup(null);
                ApplicationBean oldApplication = this.operation.getApplication();
                this.operation.setApplication(null);
                this.goToPreviousStep();
                for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                    this.em.remove((Object)serverProgressBean);
                }
                this.em.remove((Object)oldApplication);
                this.em.flush();
            } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
                if (this.anyMaintainedServerPresent()) {
                    this.operation.setAimedServerProgressProgress(100);
                    this.operation.setAimedServerProgressState(ServerProgressBean.ServerProgressState.START_OK);
                    this.operation.setAimedWorkerProgressProgress(100);
                    this.operation.setAimedWorkerProgressState(WorkerProgressBean.WorkerProgressState.START_OK);
                    ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                    for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                        if (serverProgress.getProgress() != 100) continue;
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgressList.add(serverProgress);
                    }
                    this.operation.setServerProgressList(serverProgressList);
                    ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
                    for (WorkerProgressBean workerProgress : this.operation.getAllWorkerProgressList()) {
                        if (workerProgress.getProgress() != 100) continue;
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgressList.add(workerProgress);
                    }
                    this.operation.setWorkerProgressList(workerProgressList);
                    if (this.operation.getSelectedGroup().getClustered()) {
                        this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                    } else {
                        this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                    }
                    this.mergeOperation();
                } else {
                    HashSet<ServerProgressBean> oldServerProgressList = new HashSet<ServerProgressBean>();
                    if (this.operation.getServerProgressList() != null) {
                        oldServerProgressList.addAll(this.operation.getServerProgressList());
                    }
                    if (this.operation.getAllServerProgressList() != null) {
                        oldServerProgressList.addAll(this.operation.getAllServerProgressList());
                    }
                    HashSet<WorkerProgressBean> oldWorkerProgressList = new HashSet<WorkerProgressBean>();
                    if (this.operation.getWorkerProgressList() != null) {
                        oldWorkerProgressList.addAll(this.operation.getWorkerProgressList());
                    }
                    if (this.operation.getAllWorkerProgressList() != null) {
                        oldWorkerProgressList.addAll(this.operation.getAllWorkerProgressList());
                    }
                    this.operation.setServerProgressList(null);
                    this.operation.setWorkerProgressList(null);
                    this.operation.setAllServerProgressList(null);
                    this.operation.setAllWorkerProgressList(null);
                    this.operation.setSelectedGroup(null);
                    this.goToPreviousStep();
                    for (WorkerProgressBean workerProgressBean : oldWorkerProgressList) {
                        this.em.remove((Object)workerProgressBean);
                    }
                    for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                        this.em.remove((Object)serverProgressBean);
                    }
                    this.em.flush();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER)) {
                if (this.operation.getAimedWorkerProgressState().equals(WorkerProgressBean.WorkerProgressState.INITIAL)) {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressBean.ServerProgressState.INITIAL)) {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK)) {
                    for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                        serverProgressServer.setProgress(100);
                    }
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                }
                this.goToPreviousStep();
            } else {
                throw new IllegalStateException("Unknown Step: " + currentStep);
            }
        }
    }

    private void goToPreviousStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION) || currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            throw new IllegalStateException("No previous for Step: " + currentStep);
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            this.operation.setCurrentStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            this.getApplications();
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_GROUP);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            this.getApplications();
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_GROUP);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
            this.operation.setSelectedServers(null);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            this.getApplications();
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_APPLICATION);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
        } else if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
                if (this.operation.getSelectedGroup().getClustered()) {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                }
            } else if (this.hasOldVersion()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
            }
        } else {
            throw new IllegalStateException("Unknown Step: " + currentStep);
        }
        this.mergeOperation();
    }

    @Override
    public boolean canGoToNextStep() {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            OperationStateBean.Step currentStep = this.getCurrentStep();
            if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION)) {
                return this.operation != null;
            }
            if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
                return this.operation.getTopology() != null;
            }
            if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
                return this.operation.getSelectedGroup() != null;
            }
            if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
                return this.operation.getApplication() != null;
            }
            if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1) || currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                    return false;
                }
                return true;
            }
            if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
                return this.operation.getSelectedServers() != null && this.operation.getSelectedServers().size() > 0;
            }
            if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                    return false;
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    if (workerProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                    return false;
                }
                return true;
            }
            if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
                return false;
            }
            throw new IllegalStateException("Unknown Step: " + currentStep);
        }
    }

    @Override
    public boolean canGoToPreviousStep() {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            OperationStateBean.Step currentStep = this.getCurrentStep();
            if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION) || currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
                return false;
            }
            if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP) || currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
                return true;
            }
            if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1) || currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressBean.ServerProgressState.ERASE_OK)) {
                    return false;
                }
                int progress = -1;
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) && !serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                        return false;
                    }
                    if (progress == -1) {
                        progress = serverProgress.getProgress();
                        continue;
                    }
                    if (serverProgress.getProgress() == progress) continue;
                    return false;
                }
                return true;
            }
            if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
                return true;
            }
            if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) || serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) continue;
                    return false;
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    if (workerProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) || workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) continue;
                    return false;
                }
                return true;
            }
            if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
                return true;
            }
            throw new IllegalStateException("Unknown Step: " + currentStep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectOperation(OperationStateBean selectedOperation) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            this.operation = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)selectedOperation.getId());
            if (this.operation == null) {
                throw new JadortServiceException("Cannot select operation: OperationStateBean with id " + selectedOperation.getId() + " not found", null);
            }
            if (this.getCurrentStep().equals(OperationStateBean.Step.SELECT_GROUP)) {
                this.getApplications();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNewOperation(String newOperationName) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            String filteredOperationName = newOperationName.trim();
            if (filteredOperationName.length() < 1) {
                throw new JadortServiceException("Operation name cannot be empty!", null);
            }
            this.operation = new OperationStateBean();
            this.operation.setName(filteredOperationName);
            this.operation.setDate(new Date());
            this.em.persist((Object)this.operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOperation(OperationStateBean selectedOperation) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            OperationStateBean toRemove = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)selectedOperation.getId());
            if (toRemove.getIsDeletable()) {
                this.em.remove((Object)toRemove);
                this.em.flush();
                if (this.operation != null && selectedOperation.getId() == this.operation.getId()) {
                    this.operation = null;
                }
            } else {
                throw new JadortServiceException("Operation could not be deleted because it currently is in the " + toRemove.getCurrentStep() + " step.", null);
            }
        }
    }

    private void checkStep(OperationStateBean.Step ... steps) throws JadortServiceException {
        String possibleSteps = null;
        OperationStateBean.Step currentStep = this.getCurrentStep();
        for (OperationStateBean.Step step : steps) {
            if (currentStep.equals(step)) {
                return;
            }
            possibleSteps = possibleSteps == null ? step.toString() : possibleSteps + " or " + step.toString();
        }
        throw new JadortServiceException("That method should only be called when step is " + possibleSteps + ". Currently, step is " + currentStep + ".", null);
    }

    private void refreshOperation() {
        if (this.operation != null) {
            this.operation = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)this.operation.getId());
        }
    }

    private void mergeOperation() {
        if (this.operation != null) {
            this.operation = (OperationStateBean)this.em.merge((Object)this.operation);
            this.em.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJadortService.OperationType getOperationType() {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            return this.operation.getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectServers(List<ServerBean> selectedServers) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_SERVERS);
            ArrayList<ServerBean> selectedServersList = new ArrayList<ServerBean>();
            ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
            block3: for (ServerBean selectedServer : selectedServers) {
                for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                    if (!server.equals(selectedServer)) continue;
                    if (selectedServersList.contains(server)) continue block3;
                    selectedServersList.add(server);
                    boolean hasProgress = false;
                    if (this.operation.getAllServerProgressList() != null) {
                        for (ServerProgressBean oldServerProgress : this.operation.getAllServerProgressList()) {
                            if (!oldServerProgress.getServer().equals(server)) continue;
                            hasProgress = true;
                            serverProgressList.add(oldServerProgress);
                            break;
                        }
                    }
                    if (hasProgress) continue block3;
                    serverProgressList.add(new ServerProgressBean(server));
                    continue block3;
                }
            }
            if (selectedServersList.size() == 0 || serverProgressList.size() == 0) {
                throw new JadortServiceException("You must select at least one server!", null);
            }
            for (ServerProgressBean serverProgress : serverProgressList) {
                if (serverProgress.getProgress() == 0) continue;
                throw new JadortServiceException("The server '" + serverProgress.getServer().getName() + "' has already been maintained!", null);
            }
            this.operation.setSelectedServers(selectedServersList);
            this.operation.setServerProgressList(serverProgressList);
            HashSet<WorkerBean> workersList = new HashSet<WorkerBean>();
            ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
            for (WorkerBean worker : this.operation.getSelectedGroup().getWorkers()) {
                for (ServerBean server : selectedServersList) {
                    if (!worker.getServer().equals(server)) continue;
                    workersList.add(worker);
                }
            }
            for (WorkerBean worker : workersList) {
                boolean hasProgress = false;
                if (this.operation.getAllWorkerProgressList() != null) {
                    for (WorkerProgressBean oldWorkerProgress : this.operation.getAllWorkerProgressList()) {
                        if (!oldWorkerProgress.getWorker().equals(worker)) continue;
                        hasProgress = true;
                        workerProgressList.add(oldWorkerProgress);
                        break;
                    }
                }
                if (hasProgress) continue;
                workerProgressList.add(new WorkerProgressBean(worker));
            }
            this.operation.setWorkerProgressList(workerProgressList);
            this.mergeOperation();
            this.operation.addAllServerProgressList(serverProgressList);
            this.operation.addAllWorkerProgressList(workerProgressList);
            this.mergeOperation();
        }
    }

    private void stopServer(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.STOP_SERVER.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setBooleanProperty(GROUP_CLUSTERED, this.operation.getSelectedGroup().getClustered());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void disableApplications(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.DISABLE_APPLICATIONS.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setBooleanProperty(GROUP_CLUSTERED, this.operation.getSelectedGroup().getClustered());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void enableApplications(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.ENABLE_APPLICATIONS.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setBooleanProperty(GROUP_CLUSTERED, this.operation.getSelectedGroup().getClustered());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void stopWorker(WorkerProgressBean workerProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.STOP_WORKER.toString());
        message.setIntProperty(WORKER_PROGRESS_ID, workerProgress.getId().intValue());
        message.setBooleanProperty(GROUP_CLUSTERED, this.operation.getSelectedGroup().getClustered());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void startWorker(WorkerProgressBean workerProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.START_WORKER.toString());
        message.setIntProperty(WORKER_PROGRESS_ID, workerProgress.getId().intValue());
        message.setBooleanProperty(GROUP_CLUSTERED, this.operation.getSelectedGroup().getClustered());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void startServer(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.START_SERVER.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setBooleanProperty(GROUP_CLUSTERED, this.operation.getSelectedGroup().getClustered());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void maintainServer(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.MAINTAIN_SERVER.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setBooleanProperty(GROUP_CLUSTERED, this.operation.getSelectedGroup().getClustered());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private boolean allServersHaveBeenMaintained() {
        for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
            boolean serverFound = false;
            for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                if (!serverProgress.getServer().equals(server)) continue;
                serverFound = true;
                if (serverProgress.getProgress() == 100) continue;
                return false;
            }
            if (serverFound) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerBean> getServers() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.refreshActiveSessions();
            this.refreshMaintainStatus();
            this.checkStep(OperationStateBean.Step.SELECT_SERVERS);
            return this.fetchServers();
        }
    }

    private boolean anyMaintainedServerPresent() {
        if (this.operation.getAllServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                if (serverProgress.getProgress() != 100) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Worker state for worker '" + worker.getName() + "' is " + workerProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            this.mergeOperation();
            this.reachAimedWorkerProgressState(this.getWorkerProgress(worker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Worker state for worker '" + worker.getName() + "' is " + workerProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            workerProgress.appendToLog("Error on the worker has been ignored by the user");
            workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
            workerProgress.setWorkerProgressState(this.operation.getAimedWorkerProgressState());
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) {
                throw new JadortServiceException("Worker state for worker '" + worker.getName() + "' is " + workerProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.RUNNING, null);
            }
            workerProgress.appendToLog("Action has been aborted by the user");
            workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            workerProgress.setProgress(this.operation.getAimedWorkerProgressProgress());
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerBean> getSelectedServers() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            return this.fetchSelectedServers();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        UPLOAD,
        DEPLOY,
        SET_DEFAULT,
        UNDEPLOY,
        ERASE,
        START_SERVER,
        MAINTAIN_SERVER,
        STOP_SERVER,
        START_WORKER,
        STOP_WORKER,
        DISABLE_APPLICATIONS,
        ENABLE_APPLICATIONS;

    }
}

