/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.implementation.JadortServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/JadortServiceJMSQueue")})
public class JadortServiceJMSActions
implements MessageListener {
    @PersistenceContext
    protected EntityManager em;

    public void onMessage(Message message) {
        block4: {
            try {
                IJadortService.OperationType operationType = IJadortService.OperationType.valueOf(message.getStringProperty("operationType"));
                JadortServiceImpl.ActionType actionType = JadortServiceImpl.ActionType.valueOf(message.getStringProperty("actionType"));
                if (operationType.equals(IJadortService.OperationType.MIGRATE)) {
                    this.processMigration(message, actionType);
                    break block4;
                }
                if (operationType.equals(IJadortService.OperationType.MAINTAIN)) {
                    boolean clustered = message.getBooleanProperty("groupClustered");
                    this.processMaintain(message, actionType, clustered);
                    break block4;
                }
                throw new IllegalArgumentException("Unknown operation type: " + operationType);
            }
            catch (Exception e) {
                System.out.println("Failed processing JMS message '" + message + "': " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void processMigration(Message message, JadortServiceImpl.ActionType actionType) throws JMSException {
        Integer serverProgressId = message.getIntProperty("serverProgressId");
        ServerProgressBean serverProgress = (ServerProgressBean)this.em.find(ServerProgressBean.class, (Object)serverProgressId);
        if (actionType == JadortServiceImpl.ActionType.UPLOAD) {
            Integer applicationId = message.getIntProperty("applicationId");
            ApplicationBean application = (ApplicationBean)this.em.find(ApplicationBean.class, (Object)applicationId);
            this.upload(serverProgress, application);
        } else if (actionType == JadortServiceImpl.ActionType.DEPLOY) {
            String deployApplicationName = message.getStringProperty("applicationName");
            this.deploy(serverProgress, deployApplicationName);
        } else if (actionType == JadortServiceImpl.ActionType.SET_DEFAULT) {
            String setDefaultApplicationName = message.getStringProperty("applicationName");
            this.setAsDefault(serverProgress, setDefaultApplicationName);
        } else if (actionType == JadortServiceImpl.ActionType.UNDEPLOY) {
            String undeployApplicationName = message.getStringProperty("applicationName");
            this.undeploy(serverProgress, undeployApplicationName);
        } else if (actionType == JadortServiceImpl.ActionType.ERASE) {
            String eraseApplicationName = message.getStringProperty("applicationName");
            this.erase(serverProgress, eraseApplicationName);
        } else {
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            serverProgress.appendToLog("Unknown ActionType: " + (Object)((Object)actionType));
        }
        this.mergeObject(serverProgress);
    }

    private void processMaintain(Message message, JadortServiceImpl.ActionType actionType, boolean clustered) throws JMSException {
        if (actionType == JadortServiceImpl.ActionType.START_WORKER || actionType == JadortServiceImpl.ActionType.STOP_WORKER) {
            Integer workerProgressId = message.getIntProperty("workerProgressId");
            WorkerProgressBean workerProgress = (WorkerProgressBean)this.em.find(WorkerProgressBean.class, (Object)workerProgressId);
            if (actionType == JadortServiceImpl.ActionType.START_WORKER) {
                this.startWorker(workerProgress, clustered);
            } else if (actionType == JadortServiceImpl.ActionType.STOP_WORKER) {
                this.stopWorker(workerProgress, clustered);
            }
            this.mergeObject(workerProgress);
        } else {
            Integer serverProgressId = message.getIntProperty("serverProgressId");
            ServerProgressBean serverProgress = (ServerProgressBean)this.em.find(ServerProgressBean.class, (Object)serverProgressId);
            if (actionType == JadortServiceImpl.ActionType.START_SERVER) {
                this.start(serverProgress, clustered);
            } else if (actionType == JadortServiceImpl.ActionType.MAINTAIN_SERVER) {
                this.maintain(serverProgress, clustered);
            } else if (actionType == JadortServiceImpl.ActionType.STOP_SERVER) {
                this.stop(serverProgress, clustered);
            } else if (actionType == JadortServiceImpl.ActionType.DISABLE_APPLICATIONS) {
                this.enableOrDisableApplications(serverProgress, false);
            } else if (actionType == JadortServiceImpl.ActionType.ENABLE_APPLICATIONS) {
                this.enableOrDisableApplications(serverProgress, true);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                serverProgress.appendToLog("Unknown ActionType: " + (Object)((Object)actionType));
            }
            this.mergeObject(serverProgress);
        }
    }

    private <T> void mergeObject(T serverProgress) {
        this.em.merge(serverProgress);
        this.em.flush();
    }

    private void upload(ServerProgressBean serverProgress, ApplicationBean application) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        String newApplication = null;
        try {
            serverAction = ServerAction.getServerAction(serverProgress.getServer());
            newApplication = serverAction.upload(application);
        }
        catch (Exception e) {
            stackTrace = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stackTrace));
        }
        if (newApplication != null) {
            serverProgress.setNewApplication(newApplication);
        }
        if (serverAction != null) {
            serverProgress.appendToLog(serverAction.flushLog());
        }
        if (stackTrace != null) {
            serverProgress.appendToLog(((Object)stackTrace).toString());
        }
        serverProgress.setProgress(33);
        if (stackTrace == null) {
            serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
            serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.UPLOAD_OK);
        } else {
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
        }
    }

    private void deploy(ServerProgressBean serverProgress, String applicationName) throws JMSException {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        try {
            serverAction = ServerAction.getServerAction(serverProgress.getServer());
            serverAction.deploy(applicationName);
        }
        catch (Exception e) {
            stackTrace = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stackTrace));
        }
        if (serverAction != null) {
            serverProgress.appendToLog(serverAction.flushLog());
        }
        if (stackTrace != null) {
            serverProgress.appendToLog(((Object)stackTrace).toString());
        }
        if (applicationName == serverProgress.getOldApplication() || applicationName.equals(serverProgress.getOldApplication())) {
            serverProgress.setProgress(0);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else {
            serverProgress.setProgress(66);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.DEPLOY_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void setAsDefault(ServerProgressBean serverProgress, String applicationName) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        String previousDefault = null;
        try {
            serverAction = ServerAction.getServerAction(serverProgress.getServer());
            previousDefault = serverAction.setDefault(applicationName);
        }
        catch (Exception e) {
            stackTrace = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stackTrace));
        }
        if (previousDefault != null && serverProgress.getOldApplication() == null) {
            serverProgress.setOldApplication(previousDefault);
        }
        if (serverAction != null) {
            serverProgress.appendToLog(serverAction.flushLog());
        }
        if (stackTrace != null) {
            serverProgress.appendToLog(((Object)stackTrace).toString());
        }
        if (applicationName == serverProgress.getOldApplication() || applicationName.equals(serverProgress.getOldApplication())) {
            serverProgress.setProgress(66);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.DEPLOY_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else {
            serverProgress.setProgress(100);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.SET_DEFAULT_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void undeploy(ServerProgressBean serverProgress, String applicationName) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        try {
            serverAction = ServerAction.getServerAction(serverProgress.getServer());
            serverAction.undeploy(applicationName);
        }
        catch (Exception e) {
            stackTrace = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stackTrace));
        }
        if (serverAction != null) {
            serverProgress.appendToLog(serverAction.flushLog());
        }
        if (stackTrace != null) {
            serverProgress.appendToLog(((Object)stackTrace).toString());
        }
        if (applicationName == serverProgress.getOldApplication() || applicationName.equals(serverProgress.getOldApplication())) {
            serverProgress.setProgress(50);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.UNDEPLOY_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else {
            serverProgress.setProgress(33);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.UPLOAD_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void erase(ServerProgressBean serverProgress, String applicationName) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        try {
            serverAction = ServerAction.getServerAction(serverProgress.getServer());
            serverAction.erase(applicationName);
        }
        catch (Exception e) {
            stackTrace = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stackTrace));
        }
        if (serverAction != null) {
            serverProgress.appendToLog(serverAction.flushLog());
        }
        if (stackTrace != null) {
            serverProgress.appendToLog(((Object)stackTrace).toString());
        }
        if (applicationName == serverProgress.getOldApplication() || applicationName.equals(serverProgress.getOldApplication())) {
            serverProgress.setProgress(100);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.ERASE_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else {
            serverProgress.setProgress(0);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.INITIAL);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void start(ServerProgressBean serverProgress, boolean clustered) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        if (clustered) {
            if (serverProgress.getProgress() == 60) {
                try {
                    serverAction = serverProgress.getServer().getTarget() == null ? ServerAction.getServerAction(serverProgress.getServer()) : ServerAction.getServerAction(serverProgress.getServer().getTarget());
                    serverAction.start();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (serverAction != null) {
                    serverProgress.appendToLog(serverAction.flushLog());
                }
                if (stackTrace != null) {
                    serverProgress.appendToLog(((Object)stackTrace).toString());
                }
                serverProgress.setProgress(80);
                if (stackTrace == null) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.START_OK);
                } else {
                    serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            } else if (serverProgress.getProgress() == 40) {
                try {
                    serverAction = ServerAction.getServerAction(serverProgress.getServer());
                    serverAction.start();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (serverAction != null) {
                    serverProgress.appendToLog(serverAction.flushLog());
                }
                if (stackTrace != null) {
                    serverProgress.appendToLog(((Object)stackTrace).toString());
                }
                serverProgress.setProgress(20);
                if (stackTrace == null) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.INITIAL);
                } else {
                    serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            }
        } else if (serverProgress.getProgress() == 66) {
            try {
                serverAction = serverProgress.getServer().getTarget() == null ? ServerAction.getServerAction(serverProgress.getServer()) : ServerAction.getServerAction(serverProgress.getServer().getTarget());
                serverAction.start();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (serverAction != null) {
                serverProgress.appendToLog(serverAction.flushLog());
            }
            if (stackTrace != null) {
                serverProgress.appendToLog(((Object)stackTrace).toString());
            }
            serverProgress.setProgress(83);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.START_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else if (serverProgress.getProgress() == 50) {
            try {
                serverAction = ServerAction.getServerAction(serverProgress.getServer());
                serverAction.start();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (serverAction != null) {
                serverProgress.appendToLog(serverAction.flushLog());
            }
            if (stackTrace != null) {
                serverProgress.appendToLog(((Object)stackTrace).toString());
            }
            serverProgress.setProgress(33);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void maintain(ServerProgressBean serverProgress, boolean clustered) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        if (clustered) {
            if (serverProgress.getProgress() == 40) {
                try {
                    serverAction = ServerAction.getServerAction(serverProgress.getServer());
                    serverAction.maintain();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (serverAction != null) {
                    serverProgress.appendToLog(serverAction.flushLog());
                }
                if (stackTrace != null) {
                    serverProgress.appendToLog(((Object)stackTrace).toString());
                }
                serverProgress.setProgress(60);
                if (stackTrace == null) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
                } else {
                    serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            } else if (serverProgress.getProgress() == 60) {
                try {
                    serverAction = ServerAction.getServerAction(serverProgress.getServer());
                    serverAction.maintain();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (serverAction != null) {
                    serverProgress.appendToLog(serverAction.flushLog());
                }
                if (stackTrace != null) {
                    serverProgress.appendToLog(((Object)stackTrace).toString());
                }
                serverProgress.setProgress(40);
                if (stackTrace == null) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
                } else {
                    serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            }
        } else if (serverProgress.getProgress() == 50) {
            try {
                serverAction = ServerAction.getServerAction(serverProgress.getServer());
                serverAction.maintain();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (serverAction != null) {
                serverProgress.appendToLog(serverAction.flushLog());
            }
            if (stackTrace != null) {
                serverProgress.appendToLog(((Object)stackTrace).toString());
            }
            serverProgress.setProgress(66);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else if (serverProgress.getProgress() == 66) {
            try {
                serverAction = ServerAction.getServerAction(serverProgress.getServer());
                serverAction.maintain();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (serverAction != null) {
                serverProgress.appendToLog(serverAction.flushLog());
            }
            if (stackTrace != null) {
                serverProgress.appendToLog(((Object)stackTrace).toString());
            }
            serverProgress.setProgress(50);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void stop(ServerProgressBean serverProgress, boolean clustered) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        if (clustered) {
            if (serverProgress.getProgress() == 20) {
                try {
                    serverAction = ServerAction.getServerAction(serverProgress.getServer());
                    serverAction.stop();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (serverAction != null) {
                    serverProgress.appendToLog(serverAction.flushLog());
                }
                if (stackTrace != null) {
                    serverProgress.appendToLog(((Object)stackTrace).toString());
                }
                serverProgress.setProgress(40);
                if (stackTrace == null) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
                } else {
                    serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            } else if (serverProgress.getProgress() == 80) {
                try {
                    serverAction = serverProgress.getServer().getTarget() == null ? ServerAction.getServerAction(serverProgress.getServer()) : ServerAction.getServerAction(serverProgress.getServer().getTarget());
                    serverAction.stop();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (serverAction != null) {
                    serverProgress.appendToLog(serverAction.flushLog());
                }
                if (stackTrace != null) {
                    serverProgress.appendToLog(((Object)stackTrace).toString());
                }
                serverProgress.setProgress(60);
                if (stackTrace == null) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
                } else {
                    serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            }
        } else if (serverProgress.getProgress() == 33) {
            try {
                serverAction = ServerAction.getServerAction(serverProgress.getServer());
                serverAction.stop();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (serverAction != null) {
                serverProgress.appendToLog(serverAction.flushLog());
            }
            if (stackTrace != null) {
                serverProgress.appendToLog(((Object)stackTrace).toString());
            }
            serverProgress.setProgress(50);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.STOP_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else if (serverProgress.getProgress() == 83) {
            try {
                serverAction = serverProgress.getServer().getTarget() == null ? ServerAction.getServerAction(serverProgress.getServer()) : ServerAction.getServerAction(serverProgress.getServer().getTarget());
                serverAction.stop();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (serverAction != null) {
                serverProgress.appendToLog(serverAction.flushLog());
            }
            if (stackTrace != null) {
                serverProgress.appendToLog(((Object)stackTrace).toString());
            }
            serverProgress.setProgress(66);
            if (stackTrace == null) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.MAINTAIN_OK);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void enableOrDisableApplications(ServerProgressBean serverProgress, boolean enable) {
        ByteArrayOutputStream stackTrace = null;
        ServerAction serverAction = null;
        boolean successful = true;
        try {
            serverAction = ServerAction.getServerAction(serverProgress.getServer());
            successful = serverAction.enableOrDisableApplications(enable);
        }
        catch (Exception e) {
            stackTrace = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stackTrace));
        }
        if (serverAction != null) {
            serverProgress.appendToLog(serverAction.flushLog());
        }
        if (stackTrace != null) {
            serverProgress.appendToLog(((Object)stackTrace).toString());
        }
        if (enable) {
            serverProgress.setProgress(0);
        } else {
            serverProgress.setProgress(16);
        }
        if (stackTrace == null) {
            if (successful) {
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
            } else {
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
            if (enable) {
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.INITIAL);
            } else {
                serverProgress.setServerProgressState(ServerProgressBean.ServerProgressState.DISABLE_APPLICATIONS_OK);
            }
        } else {
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
        }
    }

    private void startWorker(WorkerProgressBean workerProgress, boolean clustered) {
        ByteArrayOutputStream stackTrace = null;
        WorkerAction workerAction = null;
        if (clustered) {
            if (workerProgress.getProgress() == 80) {
                try {
                    workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                    workerAction.activate();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (workerAction != null) {
                    workerProgress.appendToLog(workerAction.flushLog());
                }
                if (stackTrace != null) {
                    workerProgress.appendToLog(((Object)stackTrace).toString());
                }
                workerProgress.setProgress(100);
                if (stackTrace == null) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.START_OK);
                } else {
                    workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            } else if (workerProgress.getProgress() == 20) {
                try {
                    workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                    workerAction.activate();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (workerAction != null) {
                    workerProgress.appendToLog(workerAction.flushLog());
                }
                if (stackTrace != null) {
                    workerProgress.appendToLog(((Object)stackTrace).toString());
                }
                workerProgress.setProgress(0);
                if (stackTrace == null) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.INITIAL);
                } else {
                    workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            }
        } else if (workerProgress.getProgress() == 83) {
            try {
                workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                workerAction.activate();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (workerAction != null) {
                workerProgress.appendToLog(workerAction.flushLog());
            }
            if (stackTrace != null) {
                workerProgress.appendToLog(((Object)stackTrace).toString());
            }
            workerProgress.setProgress(100);
            if (stackTrace == null) {
                workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.START_OK);
            } else {
                workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else if (workerProgress.getProgress() == 33) {
            try {
                workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                workerAction.activate();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (workerAction != null) {
                workerProgress.appendToLog(workerAction.flushLog());
            }
            if (stackTrace != null) {
                workerProgress.appendToLog(((Object)stackTrace).toString());
            }
            workerProgress.setProgress(16);
            if (stackTrace == null) {
                workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.INITIAL);
            } else {
                workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }

    private void stopWorker(WorkerProgressBean workerProgress, boolean clustered) {
        ByteArrayOutputStream stackTrace = null;
        WorkerAction workerAction = null;
        if (clustered) {
            if (workerProgress.getProgress() == 0) {
                try {
                    workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                    workerAction.stop();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (workerAction != null) {
                    workerProgress.appendToLog(workerAction.flushLog());
                }
                if (stackTrace != null) {
                    workerProgress.appendToLog(((Object)stackTrace).toString());
                }
                workerProgress.setProgress(20);
                if (stackTrace == null) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
                } else {
                    workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            } else if (workerProgress.getProgress() == 100) {
                try {
                    workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                    workerAction.stop();
                }
                catch (Exception e) {
                    stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                }
                if (workerAction != null) {
                    workerProgress.appendToLog(workerAction.flushLog());
                }
                if (stackTrace != null) {
                    workerProgress.appendToLog(((Object)stackTrace).toString());
                }
                workerProgress.setProgress(80);
                if (stackTrace == null) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
                } else {
                    workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
            }
        } else if (workerProgress.getProgress() == 16) {
            try {
                workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                workerAction.stop();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (workerAction != null) {
                workerProgress.appendToLog(workerAction.flushLog());
            }
            if (stackTrace != null) {
                workerProgress.appendToLog(((Object)stackTrace).toString());
            }
            workerProgress.setProgress(33);
            if (stackTrace == null) {
                workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
            } else {
                workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        } else if (workerProgress.getProgress() == 100) {
            try {
                workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                workerAction.stop();
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (workerAction != null) {
                workerProgress.appendToLog(workerAction.flushLog());
            }
            if (stackTrace != null) {
                workerProgress.appendToLog(((Object)stackTrace).toString());
            }
            workerProgress.setProgress(83);
            if (stackTrace == null) {
                workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                workerProgress.setWorkerProgressState(WorkerProgressBean.WorkerProgressState.STOP_OK);
            } else {
                workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            }
        }
    }
}

