/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DummyWorkerAction.java 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.service.action;

import java.util.Random;

import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;

/**
 * Dummy worker action, only does internal calls.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class DummyWorkerAction extends WorkerAction {

    private String name;

    private State state;

    // Set this to 0 before tests, otherwise tests will never pass!
    public static int CRASH_PROBA_PERCENT = 0;

    // Important: MAX_SLEEP - MIN_SLEEP must be superior to 1
    public static int MIN_SLEEP = 0;

    public static int MAX_SLEEP = 250;

    private static Random random = new Random();

    protected DummyWorkerAction(final WorkerBean worker) {
        this.name = worker.getName();
        this.state = State.ACTIVE;
        this.appendToLog("Created DummyWorkerAction for worker '" + this.name + "'");
    }

    @Override
    public void activate() throws Exception {
        this.appendToLog("Starting worker '" + this.name + "'");

        long wait = DummyWorkerAction.random.nextInt(DummyWorkerAction.MAX_SLEEP - DummyWorkerAction.MIN_SLEEP)
            + DummyWorkerAction.MIN_SLEEP;
        int crash = DummyWorkerAction.random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is "
            + DummyWorkerAction.CRASH_PROBA_PERCENT);

        Thread.sleep(wait);

        if (crash < DummyWorkerAction.CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }

        this.state = State.ACTIVE;

        this.appendToLog("Worker '" + this.name + "' has been succesuffully started");
    }

    @Override
    public void disable() throws Exception {
        this.appendToLog("Disabling worker '" + this.name + "'");

        long wait = DummyWorkerAction.random.nextInt(DummyWorkerAction.MAX_SLEEP - DummyWorkerAction.MIN_SLEEP)
            + DummyWorkerAction.MIN_SLEEP;
        int crash = DummyWorkerAction.random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is "
            + DummyWorkerAction.CRASH_PROBA_PERCENT);

        Thread.sleep(wait);

        if (crash < DummyWorkerAction.CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }

        this.state = State.DISABLED;

        this.appendToLog("Worker '" + this.name + "' has  been succesuffully disabled");
    }

    @Override
    public void stop() throws Exception {
        this.appendToLog("Stopping worker '" + this.name + "'");

        long wait = DummyWorkerAction.random.nextInt(DummyWorkerAction.MAX_SLEEP - DummyWorkerAction.MIN_SLEEP)
            + DummyWorkerAction.MIN_SLEEP;
        int crash = DummyWorkerAction.random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is "
            + DummyWorkerAction.CRASH_PROBA_PERCENT);

        Thread.sleep(wait);

        if (crash < DummyWorkerAction.CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }

        this.state = State.STOPPED;

        this.appendToLog("Worker '" + this.name + "' has  been succesuffully stopped");
    }

    @Override
    public State getState() throws Exception {
        this.appendToLog("Getting worker state");
        this.appendToLog("Worker state is " + this.state);
        return this.state;
    }
}
