/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossServerAction
extends ServerAction {
    private String name;
    private String url;
    private String username;
    private String password;
    private ObjectName j2eeServer;
    private MBeanServerConnection mbscnx = null;

    public JBossServerAction(ServerBean server) {
        this.name = server.getName();
        this.url = server.getServerConnector().getConnectorUrl();
        this.username = server.getServerConnector().getUsername();
        this.password = server.getServerConnector().getPassword();
        this.appendToLog("Created JBossAction for server '" + this.name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkJMXConnection() throws Exception {
        if (this.mbscnx != null) {
            try {
                this.mbscnx.getMBeanCount();
            }
            catch (IOException e) {
                this.mbscnx = null;
                this.appendToLog("Connection dropped, reconnecting to JMX server on URL '" + this.url + "'");
            }
        }
        if (this.mbscnx == null) {
            this.appendToLog("Trying to connect to JMX server on URL '" + this.url + "'");
            ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
            try {
                HashMap<String, String> env = new HashMap<String, String>();
                if (this.username != null && this.password != null) {
                    env.put("java.naming.security.principal", this.username);
                    env.put("java.naming.security.credentials", this.password);
                }
                JMXConnector c = JMXConnectorFactory.connect(new JMXServiceURL(this.url), env);
                this.mbscnx = c.getMBeanServerConnection();
                this.j2eeServer = this.mbscnx.queryNames(new ObjectName("*:type=Server"), null).iterator().next();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxCL);
            }
            this.appendToLog("JMX server connection OK for server '" + this.name + "', J2EEServer is '" + this.j2eeServer + "'");
        }
    }

    @Override
    public boolean canDeployApplications() throws Exception {
        return false;
    }

    @Override
    public void deploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public boolean enableOrDisableApplications(boolean enable) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Enabling or disabling all applications on this server");
        boolean failed = false;
        Set<ObjectName> managers = this.mbscnx.queryNames(new ObjectName("*:type=Manager,*"), null);
        for (ObjectName app : managers) {
            ObjectName filter;
            String path = app.getKeyProperty("path");
            try {
                filter = this.mbscnx.queryNames(new ObjectName("*:type=J2EEFilter,path=" + path), null).iterator().next();
            }
            catch (NoSuchElementException e) {
                this.appendToLog("\tApplication on path '" + path + "' doesn't have the OnlyAllowUsersWithSessionFilter filter! Please " + "import the filter JAR from the jadort-samples package and set it in the application's descriptor");
                failed = true;
                continue;
            }
            this.mbscnx.setAttribute(filter, new Attribute("active", !enable));
            this.appendToLog("\tFilter for application on path '" + path + "' has been set as " + (enable ? "in" : "") + "active, application is therefore " + (enable ? "enabled" : "disabled"));
        }
        if (failed) {
            this.appendToLog("At least one application on this server couldn't be " + (enable ? "enabled" : "disabled"));
            return false;
        }
        this.appendToLog("All applications on this server are now " + (enable ? "enabled" : "disabled"));
        return true;
    }

    @Override
    public void erase(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public int getActiveSessions(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public int getActiveSessions() throws Exception {
        this.checkJMXConnection();
        int totalActiveSessions = 0;
        Set<ObjectName> managers = this.mbscnx.queryNames(new ObjectName("*:type=Manager,*"), null);
        for (ObjectName manager : managers) {
            totalActiveSessions += ((Integer)this.mbscnx.getAttribute(manager, "activeSessions")).intValue();
        }
        return totalActiveSessions;
    }

    @Override
    public ApplicationBean getApplicationBean(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public boolean isStarted() throws Exception {
        this.appendToLog("Checking server state via JMX");
        boolean result = true;
        try {
            this.checkJMXConnection();
        }
        catch (IOException e) {
            result = false;
        }
        this.appendToLog("Server.started is '" + result + "'");
        return result;
    }

    @Override
    public List<ApplicationBean> listOfApplications() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Getting list of applications");
        ArrayList<ApplicationBean> applications = new ArrayList<ApplicationBean>();
        Set<ObjectName> managers = this.mbscnx.queryNames(new ObjectName("*:type=Manager,*"), null);
        for (ObjectName manager : managers) {
            String name = manager.getKeyProperty("path");
            if (name == null) continue;
            if ((name = name.substring(name.indexOf("/") + 1)).length() == 0) {
                name = "[ ROOT ]";
            }
            ApplicationBean applicationBean = new ApplicationBean(name, null);
            applicationBean.setState("Deployed");
            applications.add(applicationBean);
        }
        this.appendToLog("Got the list of applications");
        return applications;
    }

    @Override
    public void maintain() throws Exception {
    }

    @Override
    public String setDefault(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public void start() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Starting server");
        this.mbscnx.invoke(this.j2eeServer, "start", null, null);
        this.appendToLog("Server is started");
    }

    @Override
    public void stop() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Stopping server");
        this.mbscnx.invoke(this.j2eeServer, "shutdown", null, null);
        this.appendToLog("Server is stopped");
    }

    @Override
    public void undeploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public String upload(ApplicationBean application) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }
}

