/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicServerAction
extends ServerAction {
    private static final String WEBLOGIC_ROOT = "WL_HOME";
    private String name;
    private String url;
    private String username;
    private String password;
    private ObjectName j2eeServer;
    private MBeanServerConnection mbscnx = null;

    protected WebLogicServerAction(ServerBean server) {
        this.name = server.getName();
        this.url = server.getServerConnector().getConnectorUrl();
        this.username = server.getServerConnector().getUsername();
        this.password = server.getServerConnector().getPassword();
        this.appendToLog("Created WeblogicServerAction for server '" + this.name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkJMXConnection() throws Exception {
        if (this.mbscnx != null) {
            try {
                this.mbscnx.getMBeanCount();
            }
            catch (IOException e) {
                this.mbscnx = null;
                this.appendToLog("Connection dropped, reconnecting to JMX server on URL '" + this.url + "'");
            }
        }
        if (this.mbscnx == null) {
            this.appendToLog("Trying to connect to JMX server on URL '" + this.url + "'");
            String root = System.getenv(WEBLOGIC_ROOT);
            if (root == null) {
                root = System.getProperty(WEBLOGIC_ROOT);
            }
            File wlJMXClientJAR = null;
            if (root != null && !(wlJMXClientJAR = new File(root, "lib/wljmxclient.jar")).isFile()) {
                wlJMXClientJAR = null;
            }
            if (!this.url.contains("iiop:") && wlJMXClientJAR == null) {
                throw new Exception("You need to set the environment variable WL_HOME to a valid license in order to connect to a WebLogic server with proprietary protocols.\nCurrently, WL_HOME is set to \"" + root + "\"");
            }
            URLClassLoader cl = null;
            if (wlJMXClientJAR != null) {
                cl = new URLClassLoader(new URL[]{wlJMXClientJAR.toURI().toURL()}, this.getClass().getClassLoader());
            }
            ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
            try {
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                HashMap<String, String> env = new HashMap<String, String>();
                if (this.username != null && this.password != null) {
                    env.put("java.naming.security.principal", this.username);
                    env.put("java.naming.security.credentials", this.password);
                }
                if (wlJMXClientJAR != null) {
                    env.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
                }
                JMXConnector c = JMXConnectorFactory.connect(new JMXServiceURL(this.url), env);
                this.mbscnx = c.getMBeanServerConnection();
                this.j2eeServer = this.mbscnx.queryNames(new ObjectName("*:Type=ServerRuntime,*"), null).iterator().next();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxCL);
            }
            this.appendToLog("JMX server connection OK for server '" + this.name + "', J2EEServer is '" + this.j2eeServer + "'");
        }
    }

    @Override
    public boolean canDeployApplications() throws Exception {
        return false;
    }

    @Override
    public void deploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public boolean enableOrDisableApplications(boolean enable) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Enabling or disabling all applications on this server");
        boolean failed = false;
        for (ObjectName app : this.mbscnx.queryNames(new ObjectName("*:Type=WebAppComponentRuntime,*"), null)) {
            ObjectName filter;
            String path = (String)this.mbscnx.getAttribute(app, "ContextRoot");
            if (path == null || path.length() < 1) {
                path = "/";
            }
            try {
                filter = this.mbscnx.queryNames(new ObjectName("*:type=J2EEFilter,path=" + path), null).iterator().next();
            }
            catch (NoSuchElementException e) {
                this.appendToLog("\tApplication on path '" + path + "' doesn't have the OnlyAllowUsersWithSessionFilter filter! Please " + "import the filter JAR from the jadort-samples package and set it in the application's descriptor");
                failed = true;
                continue;
            }
            this.mbscnx.setAttribute(filter, new Attribute("active", !enable));
            this.appendToLog("\tFilter for application on path '" + path + "' has been set as " + (enable ? "in" : "") + "active, application is therefore " + (enable ? "enabled" : "disabled"));
        }
        if (failed) {
            this.appendToLog("At least one application on this server couldn't be " + (enable ? "enabled" : "disabled"));
            return false;
        }
        this.appendToLog("All applications on this server are now " + (enable ? "enabled" : "disabled"));
        return true;
    }

    @Override
    public void erase(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public int getActiveSessions(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public int getActiveSessions() throws Exception {
        this.checkJMXConnection();
        int totalActiveSessions = 0;
        for (ObjectName webAppComponentRuntime : this.mbscnx.queryNames(new ObjectName("*:Type=WebAppComponentRuntime,*"), null)) {
            totalActiveSessions += ((Integer)this.mbscnx.getAttribute(webAppComponentRuntime, "OpenSessionsCurrentCount")).intValue();
        }
        return totalActiveSessions;
    }

    @Override
    public List<ApplicationBean> listOfApplications() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Getting list of applications");
        ArrayList<ApplicationBean> applications = new ArrayList<ApplicationBean>();
        for (ObjectName app : this.mbscnx.queryNames(new ObjectName("*:Type=WebAppComponentRuntime,*"), null)) {
            String name = (String)this.mbscnx.getAttribute(app, "ModuleId");
            if (name == null) continue;
            if (name.length() == 0) {
                name = "[ ROOT ]";
            }
            ApplicationBean applicationBean = new ApplicationBean(name, null);
            applicationBean.setState("Deployed");
            applications.add(applicationBean);
        }
        this.appendToLog("Got the list of applications");
        return applications;
    }

    @Override
    public boolean isStarted() throws Exception {
        this.appendToLog("Checking server state via JMX");
        boolean result = true;
        try {
            this.checkJMXConnection();
        }
        catch (IOException e) {
            result = false;
        }
        this.appendToLog("Server.started is '" + result + "'");
        return result;
    }

    @Override
    public void maintain() throws Exception {
    }

    @Override
    public String setDefault(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public void start() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Starting server");
        this.mbscnx.invoke(this.j2eeServer, "start", null, null);
        this.appendToLog("Server is started");
    }

    @Override
    public void stop() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Stoping server");
        this.mbscnx.invoke(this.j2eeServer, "shutdown", null, null);
        this.appendToLog("Server is stoped");
    }

    @Override
    public void undeploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public String upload(ApplicationBean application) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public ApplicationBean getApplicationBean(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }
}

