/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action.modProxyBalancer;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Balancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModProxyBalancer {
    private String login;
    private String password;
    private String url;
    protected List<Balancer> balancers;
    protected String nonce;

    public ModProxyBalancer(String url, String login, String password) {
        this.url = url;
        this.login = login;
        this.password = password;
    }

    public ModProxyBalancer(String url) {
        this(url, null, null);
    }

    protected void updateBalancerInfo() throws Exception {
        String response = this.openConnection();
        this.parseAndUpdateModProxyBalancer(response);
    }

    protected void parseAndUpdateModProxyBalancer(String response) {
        this.balancers = new ArrayList<Balancer>();
        int l1 = -1;
        while ((l1 = response.indexOf("<h3>")) > -1) {
            response = response.substring(l1 + 4);
            String s = response.substring(0, response.indexOf("</h3>"));
            String balancerName = s.trim().substring(s.lastIndexOf("balancer://") + 11);
            int l2 = -1;
            ArrayList<Worker> workers = new ArrayList<Worker>();
            while ((l2 = response.indexOf("<td><a")) > -1) {
                String nonce;
                response = response.substring(l2 + 6);
                int l3 = response.indexOf("</a></td>");
                s = response.substring(0, l3);
                this.nonce = nonce = s.trim().substring(s.indexOf("&nonce=") + 6, s.indexOf("\">") - 1);
                String workerUrl = s.trim().substring(s.indexOf("\">") + 1);
                response = response.substring(l3 + 13);
                for (int i = 0; i < 4; ++i) {
                    response = response.substring(response.indexOf("</td><td>") + 9);
                }
                String status = response.trim().substring(0, response.indexOf("</td><td>"));
                workers.add(new Worker(workerUrl, status.equalsIgnoreCase("OK")));
            }
            this.balancers.add(new Balancer(balancerName, workers));
        }
    }

    protected String openConnection() throws Exception {
        return this.openConnection(null);
    }

    protected String openConnection(String param) throws Exception {
        int responseCode;
        HttpURLConnection con = null;
        String response = null;
        con = param != null ? (HttpURLConnection)new URL(this.url + "?" + param).openConnection() : (HttpURLConnection)new URL(this.url).openConnection();
        con.setRequestMethod("GET");
        if (this.login != null) {
            Base64 enc = new Base64();
            String authData = this.login + ":" + this.password;
            byte[] base64AuthData = enc.encode(authData.getBytes());
            con.setRequestProperty("Authorization", "Basic " + new String(base64AuthData, "UTF-8"));
        }
        if ((responseCode = con.getResponseCode()) != 200) {
            throw new Exception("Connection error: " + con.getResponseMessage());
        }
        InputStream is = con.getInputStream();
        byte[] b = new byte[is.available()];
        int nbOctetsLus = is.read(b);
        response = new String(b, 0, nbOctetsLus);
        return response;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<Balancer> getBalancers() throws Exception {
        this.updateBalancerInfo();
        return this.balancers;
    }

    public void activateWorker(String balancerName, String workerUrl) throws Exception {
        this.updateBalancerInfo();
        String param = "dw=Enable&nonce=" + this.nonce + "&w=" + URLEncoder.encode(workerUrl, "UTF-8") + "&b=" + balancerName;
        String response = this.openConnection(param);
        this.parseAndUpdateModProxyBalancer(response);
    }

    public void deactivateWorker(String balancerName, String workerUrl) throws Exception {
        this.updateBalancerInfo();
        String param = "dw=Disable&w=" + URLEncoder.encode(workerUrl, "UTF-8") + "&b=" + balancerName + "&nonce=" + this.nonce;
        String response = this.openConnection(param);
        this.parseAndUpdateModProxyBalancer(response);
    }
}

