/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbstractAction.java 3616 2009-05-05 08:29:09Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.service.action;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Abstract action. The JaDOrT service takes actions on all modules (be it
 * servers, workers, ...).
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public abstract class AbstractAction {

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss dd/MM/yyyy");

    private String log;

    /**
     * @return Event log for this server. This will erase all past logs.
     */
    public String flushLog() {
        synchronized (this) {
            String result = this.log;
            this.log = null;
            return result;
        }
    }

    /**
     * @param string String to append to the log. This method automatically
     *        handles new lines at end of log.
     */
    public void appendToLog(final String string) {
        synchronized (this) {
            String stringWithDate = AbstractAction.dateFormat.format(new Date()) + " - " + string;

            if (this.log == null) {
                this.log = stringWithDate;
            } else {
                this.log += '\n' + stringWithDate;
            }
        }
    }

}
