/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import org.apache.jk.status.JkBalancer;
import org.apache.jk.status.JkBalancerMember;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.action.modJK.JkConnection;
import org.ow2.jasmine.jadort.service.action.modJK.JkConnectionException;

public class ModJKWorkerAction
extends WorkerAction {
    private static final String STATE_ACTIVE = "ACT";
    private static final String STATE_DISABLED = "DIS";
    private static final String STATE_STOPPED = "STP";
    private String name;
    private String balancerName;
    private String balancerMemberName;
    private JkConnection jkc;
    private JkBalancer balancer;
    private JkBalancerMember balancerMember;

    protected ModJKWorkerAction(WorkerBean worker) {
        this.name = worker.getName();
        this.balancerName = worker.getWorkerName();
        this.balancerMemberName = worker.getServerName();
        this.jkc = new JkConnection(worker.getConnector().getConnectorUrl(), worker.getConnector().getUsername(), worker.getConnector().getPassword());
        this.appendToLog("Created ModJKWorkerAction for worker '" + this.name + "'");
    }

    protected void refreshBalancerAndMember() throws JkConnectionException {
        this.balancer = null;
        this.balancerMember = null;
        for (JkBalancer balancer : this.jkc.readStatus_Online().getBalancers()) {
            if (!balancer.getName().equals(this.balancerName)) continue;
            for (JkBalancerMember balancerMember : balancer.getBalancerMembers()) {
                if (!balancerMember.getName().equals(this.balancerMemberName)) continue;
                this.balancer = balancer;
                this.balancerMember = balancerMember;
                return;
            }
            throw new IllegalArgumentException("Cannot find balancer member named \"" + this.balancerMemberName + "\"");
        }
        throw new IllegalArgumentException("Cannot find balancer named \"" + this.balancerName + "\"");
    }

    public void activate() throws Exception {
        this.appendToLog("Starting worker '" + this.name + "'");
        this.refreshBalancerAndMember();
        this.balancerMember.setActivation(STATE_ACTIVE);
        this.jkc.updateBalancerMember(this.balancer, this.balancerMember);
        this.appendToLog("Worker '" + this.name + "' has been succesuffully started");
    }

    public void disable() throws Exception {
        this.appendToLog("Disabling worker '" + this.name + "'");
        this.refreshBalancerAndMember();
        this.balancerMember.setActivation(STATE_DISABLED);
        this.jkc.updateBalancerMember(this.balancer, this.balancerMember);
        this.appendToLog("Worker '" + this.name + "' has  been succesuffully disabled");
    }

    public void stop() throws Exception {
        this.appendToLog("Stopping worker '" + this.name + "'");
        this.refreshBalancerAndMember();
        this.balancerMember.setActivation(STATE_STOPPED);
        this.jkc.updateBalancerMember(this.balancer, this.balancerMember);
        this.appendToLog("Worker '" + this.name + "' has  been succesuffully stopped");
    }

    public WorkerAction.State getState() throws Exception {
        WorkerAction.State state;
        this.refreshBalancerAndMember();
        String activation = this.balancerMember.getActivation();
        if (STATE_ACTIVE.equals(activation)) {
            state = WorkerAction.State.ACTIVE;
        } else if (STATE_DISABLED.equals(activation)) {
            state = WorkerAction.State.DISABLED;
        } else if (STATE_STOPPED.equals(activation)) {
            state = WorkerAction.State.STOPPED;
        } else {
            throw new IllegalStateException("Unknown activation state: " + activation);
        }
        return state;
    }
}

