/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.util.List;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Balancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.ModProxyBalancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Worker;

public class ModProxyBalancerWorkerAction
extends WorkerAction {
    private String name;
    private String balancerName;
    private String balancerMemberName;
    private ModProxyBalancer modProxyBalancer;

    protected ModProxyBalancerWorkerAction(WorkerBean worker) {
        this.name = worker.getName();
        this.balancerName = worker.getWorkerName();
        this.balancerMemberName = worker.getServerName();
        this.modProxyBalancer = new ModProxyBalancer(worker.getConnector().getConnectorUrl(), worker.getConnector().getUsername(), worker.getConnector().getPassword());
        this.appendToLog("Created ModProxyBalancerWorkerAction for worker '" + this.name + "'");
    }

    public void activate() throws Exception {
        this.appendToLog("Starting worker '" + this.name + "'");
        this.modProxyBalancer.activateWorker(this.balancerName, this.balancerMemberName);
        this.appendToLog("Worker '" + this.name + "' has been succesufully started");
    }

    public void disable() throws Exception {
        this.appendToLog("Disabling worker '" + this.name + "'");
        this.modProxyBalancer.deactivateWorker(this.balancerName, this.balancerMemberName);
        this.appendToLog("Worker '" + this.name + "' has  been succesufully disabled");
    }

    public void stop() throws Exception {
        this.disable();
    }

    public WorkerAction.State getState() throws Exception {
        WorkerAction.State state = null;
        Worker currentworker = null;
        List<Worker> workersOnThisBalancer = null;
        List<Balancer> balancers = this.modProxyBalancer.getBalancers();
        for (Balancer balancer : balancers) {
            if (!balancer.getName().equals(this.balancerName)) continue;
            workersOnThisBalancer = balancer.getWorkers();
            for (Worker worker : workersOnThisBalancer) {
                if (!worker.getUrl().equals(this.balancerMemberName)) continue;
                currentworker = worker;
            }
        }
        if (currentworker == null) {
            if (workersOnThisBalancer == null) {
                throw new IllegalStateException("The balancer named '" + this.balancerMemberName + "' cannot be found on Apache mod_proxy_balancer '" + this.modProxyBalancer.getUrl() + "'");
            }
            throw new IllegalStateException("Worker '" + this.balancerName + "' not found on balancer '" + this.balancerMemberName + "'");
        }
        state = currentworker.isEnabled() ? WorkerAction.State.ACTIVE : WorkerAction.State.DISABLED;
        return state;
    }
}

