/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressState;
import org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.TopologyBean;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;
import org.ow2.jasmine.jadort.service.action.VMMAction;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.topology.xml.Balancer;
import org.ow2.jasmine.jadort.service.topology.xml.Server;
import org.ow2.jasmine.jadort.service.topology.xml.Target;
import org.ow2.jasmine.jadort.service.topology.xml.Topology;
import org.ow2.jasmine.jadort.service.topology.xml.URLConnector;
import org.ow2.jasmine.jadort.service.topology.xml.VM;
import org.ow2.jasmine.jadort.service.topology.xml.VMM;
import org.ow2.jasmine.jadort.service.topology.xml.Worker;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Local(value={IJadortService.class})
@Remote(value={IJadortService.class})
@Stateful(mappedName="ow2.jasmine.jadort.ServiceSFB")
public class JadortServiceImpl
implements IJadortService {
    private static final int BUFFER_SIZE = 16384;
    private static final String XSD_PATH_JADORT = "XMLSchema/topology_JadortSpecific.xsd";
    private static final String XSD_PATH_DEPLOYME = "xml/topology.xsd";
    static final String QUEUE_NAME = "queue/JadortServiceJMSQueue";
    static final String SERVER_PROGRESS_ID = "serverProgressId";
    static final String WORKER_PROGRESS_ID = "workerProgressId";
    static final String AIMED_PROGRESS_PERCENT = "aimedProgressPercent";
    static final String AIMED_STATE = "aimedState";
    static final String APPLICATION_ID = "applicationId";
    static final String VM_IMAGE_UUID = "vmImageUUID";
    static final String ACTION_TYPE = "actionType";
    static final String APPLICATION_NAME = "applicationName";
    static final String VM_NAME = "vmName";
    static final String CHECK_IF_HOST_HALTED = "checkIfHostHalted";
    static final String OPERATION_TYPE = "operationType";
    static boolean DUMMY = false;
    private OperationStateBean operation;
    @PersistenceContext
    protected EntityManager em;
    protected QueueConnection qc;
    protected QueueSession session;
    protected Queue queue;

    @PostConstruct
    protected void initialize() {
        try {
            InitialContext ctx = new InitialContext();
            this.queue = (Queue)ctx.lookup(QUEUE_NAME);
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("QCF");
            this.qc = factory.createQueueConnection();
            this.session = this.qc.createQueueSession(false, 1);
        }
        catch (Exception e) {
            IllegalStateException exception = new IllegalStateException("Failed initializing a JadortService stateful bean: " + e.getMessage(), e);
            System.out.println(exception.getMessage());
            e.printStackTrace();
            throw exception;
        }
    }

    @PreDestroy
    protected void terminate() {
        try {
            this.session.close();
            this.qc.close();
        }
        catch (Exception e) {
            IllegalStateException exception = new IllegalStateException("Failed terminating a JadortService stateful bean: " + e.getMessage(), e);
            System.out.println(exception.getMessage());
            e.printStackTrace();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperationStateBean> getOperationsList() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            ArrayList<OperationStateBean> result = new ArrayList<OperationStateBean>();
            for (OperationStateBean operation : this.em.createQuery("select o from JaDOrT_OperationStateBean o order by o.date asc").getResultList()) {
                OperationStateBean temp = new OperationStateBean();
                temp.setAimedServerProgressState(operation.getAimedServerProgressState());
                temp.setAimedWorkerProgressState(operation.getAimedWorkerProgressState());
                temp.setCurrentStep(operation.getCurrentStep());
                temp.setDate(operation.getDate());
                temp.setId(operation.getId());
                temp.setName(operation.getName());
                temp.setType(operation.getType());
                result.add(temp);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStateBean getCurrentOperation() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            if (this.operation == null) {
                return null;
            }
            OperationStateBean bean = new OperationStateBean();
            bean.setAimedServerProgressState(this.operation.getAimedServerProgressState());
            bean.setAimedWorkerProgressState(this.operation.getAimedWorkerProgressState());
            bean.setAimedProgressPercent(this.operation.getAimedProgressPercent());
            bean.setApplication(this.operation.getApplication());
            bean.setCurrentStep(this.operation.getCurrentStep());
            bean.setDate(this.operation.getDate());
            bean.setId(this.operation.getId());
            bean.setName(this.operation.getName());
            bean.setType(this.operation.getType());
            bean.setVmImage(this.operation.getVmImage());
            bean.setCanGoToNextStep(this.canGoToNextStep());
            bean.setCanGoToPreviousStep(this.canGoToPreviousStep());
            if (this.operation.getServerProgressList() != null) {
                bean.setServerProgressList(new ArrayList<ServerProgressBean>(this.operation.getServerProgressList()));
            }
            if (this.operation.getWorkerProgressList() != null) {
                bean.setWorkerProgressList(new ArrayList<WorkerProgressBean>(this.operation.getWorkerProgressList()));
            }
            if (this.operation.getSelectedServers() != null) {
                bean.setSelectedServers(new ArrayList<ServerBean>(this.operation.getSelectedServers()));
            }
            if (this.operation.getSelectedGroup() != null) {
                GroupBean groupBean = new GroupBean();
                groupBean.setId(this.operation.getSelectedGroup().getId());
                groupBean.setWorkers(new ArrayList<WorkerBean>(this.operation.getSelectedGroup().getWorkers()));
                groupBean.setName(this.operation.getSelectedGroup().getName());
                groupBean.setServers(new ArrayList<ServerBean>(this.operation.getSelectedGroup().getServers()));
                groupBean.setClustered(this.operation.getSelectedGroup().getClustered());
                bean.setSelectedGroup(groupBean);
            }
            if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_SERVERS) || this.operation.getCurrentStep().equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER) || this.operation.getCurrentStep().equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
                this.refreshActiveSessions();
            }
            if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_GROUP) && this.operation.getTopology() != null) {
                TopologyBean topology = new TopologyBean();
                topology.setGroups(this.fetchGroups());
                topology.setId(this.operation.getTopology().getId());
                bean.setTopology(topology);
            }
            if (bean.getSelectedGroup() != null) {
                if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_GROUP) || this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_APPLICATION)) {
                    this.fillApplications(bean.getSelectedGroup());
                }
                if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_VM_IMAGE) || this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
                    this.fillVMImages(bean.getSelectedGroup());
                }
            }
            return bean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTopology(File xmlTopoFile) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
            try {
                this.loadJadortSpecificTopology(xmlTopoFile);
            }
            catch (UnmarshalException e1) {
                try {
                    this.loadDeployMETopology(xmlTopoFile);
                }
                catch (UnmarshalException e2) {
                    throw new JadortServiceException(xmlTopoFile.getName() + " is not a valid topology file.\n\nHere are some potentially helpful error messages:\n\t[" + XSD_PATH_JADORT + "] " + e1.getMessage() + "\n\t[" + XSD_PATH_DEPLOYME + "] " + e2.getMessage(), null);
                }
            }
            this.mergeOperation();
        }
    }

    protected void loadJadortSpecificTopology(File xmlTopoFile) throws UnmarshalException, JadortServiceException {
        Topology xmlTopology = this.loadSchemaAndFile(XSD_PATH_JADORT, Topology.class, xmlTopoFile);
        TopologyBean topologyBean = new TopologyBean();
        this.operation.setTopology(topologyBean);
        HashMap<String, Worker> workerXMLs = new HashMap<String, Worker>();
        for (Worker workerXML : xmlTopology.getWorker()) {
            workerXMLs.put(workerXML.getName(), workerXML);
        }
        HashMap<String, VMM> vmmXMLs = new HashMap<String, VMM>();
        for (VMM vmmXML : xmlTopology.getVMM()) {
            vmmXMLs.put(vmmXML.getName(), vmmXML);
        }
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (Topology.Group groupXML : xmlTopology.getGroup()) {
            GroupBean groupBean = new GroupBean();
            groupBean.setName(groupXML.getName());
            groupBean.setClustered(groupXML.isClustered());
            ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
            ArrayList<WorkerBean> workers = new ArrayList<WorkerBean>();
            boolean atLeastOneServerHasVM = false;
            String VMMName = "";
            for (Server serverXML : groupXML.getServer()) {
                VM vmXML;
                List<Balancer> balancerXMLs;
                ServerBean serverBean = new ServerBean();
                serverBean.setName(serverXML.getName());
                if (serverXML.getCapacity() != null) {
                    serverBean.setCapacity(serverXML.getCapacity());
                }
                serverBean.setType(ServerBean.Type.valueOf(serverXML.getType().name()));
                serverBean.setServerConnector(this.createJMXConnectorBean(serverXML.getURLConnector()));
                if (serverXML.getManager() != null) {
                    serverBean.setManagerConnector(this.createJMXConnectorBean(serverXML.getManager().getURLConnector()));
                }
                Target targetXML = serverXML.getTarget();
                ServerBean target = null;
                if (targetXML != null) {
                    target = new ServerBean();
                    target.setName(targetXML.getName());
                    target.setType(ServerBean.Type.valueOf(targetXML.getType().name()));
                    target.setServerConnector(this.createJMXConnectorBean(targetXML.getURLConnector()));
                    if (targetXML.getManager() != null) {
                        target.setManagerConnector(this.createJMXConnectorBean(targetXML.getManager().getURLConnector()));
                    }
                    serverBean.setTarget(target);
                }
                if ((balancerXMLs = serverXML.getBalancer()) != null) {
                    for (Balancer balancerXML : balancerXMLs) {
                        Worker workerXML = (Worker)workerXMLs.get(balancerXML.getWorker());
                        if (workerXML == null) {
                            throw new JadortServiceException("There is no worker named \"" + balancerXML.getWorker() + "\", please check your topology file.", null);
                        }
                        WorkerBean workerBean = new WorkerBean();
                        workerBean.setName(balancerXML.getServer());
                        workerBean.setWorkerName(workerXML.getName());
                        workerBean.setType(WorkerBean.Type.valueOf(workerXML.getType().name()));
                        workerBean.setServerName(balancerXML.getServer());
                        workerBean.setConnector(this.createJMXConnectorBean(workerXML.getURLConnector()));
                        workerBean.setServer(serverBean);
                        workers.add(workerBean);
                    }
                }
                if ((vmXML = serverXML.getVM()) != null) {
                    atLeastOneServerHasVM = true;
                    VMM vmmXML = (VMM)vmmXMLs.get(vmXML.getVmm());
                    if (vmmXML != null) {
                        VMBean vmBean = new VMBean();
                        vmBean.setName(vmXML.getName());
                        vmBean.setVmm(vmXML.getVmm());
                        vmBean.setConnector(this.createJMXConnectorBean(vmmXML.getURLConnector()));
                        serverBean.setVm(vmBean);
                        VMMName = vmmXML.getName();
                    } else {
                        throw new JadortServiceException("VMM not defined\", please check your topology file.", null);
                    }
                }
                servers.add(serverBean);
            }
            for (ServerBean server : servers) {
                if (atLeastOneServerHasVM && server.getVm() == null || !atLeastOneServerHasVM && server.getVm() != null) {
                    throw new JadortServiceException("All servers in a group must have a VM or no server has one\", please check your topology file.", null);
                }
                if (server.getVm() == null || server.getVm().getVmm().equals(VMMName)) continue;
                throw new JadortServiceException("All servers in a group must have the same VMM\", please check your topology file.", null);
            }
            groupBean.setServers(servers);
            groupBean.setWorkers(workers);
            groups.add(groupBean);
        }
        topologyBean.setGroups(groups);
    }

    protected void loadDeployMETopology(File xmlTopoFile) throws UnmarshalException, JadortServiceException {
        org.ow2.jasmine.deployme.generated.Topology xmlTopology = this.loadSchemaAndFile(XSD_PATH_DEPLOYME, org.ow2.jasmine.deployme.generated.Topology.class, xmlTopoFile);
        TopologyBean topologyBean = new TopologyBean();
        this.operation.setTopology(topologyBean);
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (Topology.Domains.Domain domain : xmlTopology.getDomains().getDomain()) {
            Configuration conf = domain.getConfiguration();
            String defaultHost = null;
            int defaultPort = 0;
            Configuration.Protocols protocols = null;
            if (conf != null) {
                if (conf.getGlobalJonas() != null) {
                    defaultHost = conf.getGlobalJonas().getHost();
                }
                protocols = conf.getProtocols();
            }
            if (defaultHost == null) {
                defaultHost = "localhost";
            }
            String defaultProtocol = null;
            if (protocols != null) {
                defaultProtocol = protocols.getProtocolsList();
                BigInteger jrmpPort = protocols.getJrmpPort();
                if (jrmpPort != null) {
                    defaultPort = jrmpPort.intValue();
                }
            }
            defaultProtocol = defaultProtocol != null ? defaultProtocol.split(",")[0] : "jrmp";
            GroupBean groupBean = new GroupBean();
            groupBean.setName(domain.getName());
            boolean clustered = false;
            try {
                clustered = conf.getActiveServices().getWeb().isHttpReplicationActivated().booleanValue();
            }
            catch (NullPointerException ignored) {
                // empty catch block
            }
            ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
            for (Topology.Domains.Domain.Servers.Server server : domain.getServers().getServer()) {
                String transport;
                conf = server.getConfiguration();
                String host = null;
                if (conf != null) {
                    if (conf.getGlobalJonas() != null) {
                        host = conf.getGlobalJonas().getHost();
                    }
                    protocols = conf.getProtocols();
                }
                if (host == null) {
                    host = defaultHost;
                }
                String name = server.getName();
                int port = defaultPort;
                String protocol = null;
                if (protocols != null) {
                    protocol = protocols.getProtocolsList();
                    BigInteger jrmpPort = protocols.getJrmpPort();
                    if (jrmpPort != null) {
                        port = jrmpPort.intValue();
                    }
                }
                if ((protocol = protocol != null ? protocol.split(",")[0] : defaultProtocol).equals("irmi")) {
                    transport = "rmi";
                    if (port == 0) {
                        port = 1098;
                    }
                } else if (protocol.equals("jrmp")) {
                    transport = "rmi";
                    if (port == 0) {
                        port = 1099;
                    }
                } else if (protocol.equals("iiop")) {
                    transport = "iiop";
                    if (port == 0) {
                        port = 2001;
                    }
                } else {
                    throw new JadortServiceException("Unknown protocol \"" + protocol + "\" for server \"" + name + "\".", null);
                }
                String jmxURL = "service:jmx:" + transport + "://" + host + "/jndi/" + transport + "://" + host + ":" + port + "/" + protocol + "connector_" + name;
                ConnectorBean connector = new ConnectorBean();
                connector.setConnectorUrl(jmxURL);
                ServerBean serverBean = new ServerBean();
                serverBean.setName(name);
                serverBean.setServerConnector(connector);
                if (DUMMY) {
                    serverBean.setType(ServerBean.Type.DUMMY);
                } else {
                    serverBean.setType(ServerBean.Type.JONAS);
                }
                servers.add(serverBean);
                try {
                    if (conf.getActiveServices().getWeb().isHttpReplicationActivated().booleanValue()) {
                        clustered = true;
                        continue;
                    }
                    clustered = false;
                }
                catch (NullPointerException ignored) {}
            }
            if (domain.getClusterDaemons() != null) {
                for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : domain.getClusterDaemons().getClusterDaemon()) {
                    int nb = 1;
                    String prefix = cd.getServerNamePrefix();
                    for (String serverName : cd.getServers().getServerName()) {
                        boolean found = false;
                        for (ServerBean s : servers) {
                            String transport;
                            if (!s.getName().equals(serverName)) continue;
                            s.setName(prefix + nb);
                            s.getServerConnector().setConnectorUrl(s.getServerConnector().getConnectorUrl().replace("connector_" + serverName, "connector_" + s.getName()));
                            ++nb;
                            String protocol = cd.getClusterDaemonProtocol();
                            protocol = protocol != null ? protocol.split(",")[0] : defaultProtocol;
                            int port = defaultPort;
                            Integer portInteger = cd.getClusterDaemonPort();
                            if (portInteger != null) {
                                port = portInteger;
                            }
                            if (protocol.equals("irmi")) {
                                transport = "rmi";
                                if (port == 0) {
                                    port = 1098;
                                }
                            } else if (protocol.equals("jrmp")) {
                                transport = "rmi";
                                if (port == 0) {
                                    port = 1099;
                                }
                            } else if (protocol.equals("iiop")) {
                                transport = "iiop";
                                if (port == 0) {
                                    port = 2001;
                                }
                            } else {
                                throw new JadortServiceException("Unknown protocol \"" + protocol + "\" for cluster daemon \"" + cd.getName() + "\".", null);
                            }
                            String serverURL = s.getServerConnector().getConnectorUrl();
                            int hostStart = serverURL.indexOf("://") + 3;
                            String host = serverURL.substring(hostStart, serverURL.indexOf(47, hostStart));
                            String jmxURL = "service:jmx:" + transport + "://" + host + "/jndi/" + transport + "://" + host + ":" + port + "/" + protocol + "connector_" + cd.getName();
                            ConnectorBean manager = new ConnectorBean();
                            manager.setConnectorUrl(jmxURL);
                            s.setManagerConnector(manager);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new JadortServiceException("Cannot find server \"" + serverName + "\" for cluster daemon \"" + cd.getName() + "\".", null);
                    }
                }
            }
            groupBean.setServers(servers);
            groupBean.setClustered(clustered);
            groups.add(groupBean);
        }
        topologyBean.setGroups(groups);
    }

    protected <T> T loadSchemaAndFile(String xsdPath, Class<T> rootClass, File xmlFile) throws JadortServiceException, UnmarshalException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)rootClass.getPackage().getName());
            Unmarshaller unMarshaller = jc.createUnmarshaller();
            URL xsdURL = this.getClass().getClassLoader().getResource(xsdPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsdURL);
            unMarshaller.setSchema(schema);
            return (T)unMarshaller.unmarshal(xmlFile);
        }
        catch (JAXBException e) {
            if (e instanceof UnmarshalException) {
                UnmarshalException ue = (UnmarshalException)((Object)e);
                if (ue.getLinkedException() != null) {
                    throw new UnmarshalException(ue.getLinkedException().getMessage(), (Throwable)e);
                }
                throw ue;
            }
            throw new JadortServiceException("Error creating the topology parser: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new JadortServiceException("Error creating the topology parser: " + e.getMessage(), e);
        }
    }

    protected ConnectorBean createJMXConnectorBean(URLConnector urlConnector) {
        ConnectorBean jmxConnectorBean = new ConnectorBean();
        jmxConnectorBean.setConnectorUrl(urlConnector.getURL());
        if (urlConnector.getUsername() != null && urlConnector.getPassword() != null) {
            jmxConnectorBean.setUsername(urlConnector.getUsername());
            jmxConnectorBean.setPassword(urlConnector.getPassword());
        }
        return jmxConnectorBean;
    }

    private List<GroupBean> fetchGroups() throws JadortServiceException {
        if (this.operation.getTopology() != null && this.operation.getTopology().getGroups() != null) {
            ArrayList<GroupBean> result = new ArrayList<GroupBean>(this.operation.getTopology().getGroups().size());
            for (GroupBean groupBean : this.operation.getTopology().getGroups()) {
                GroupBean groupBeanCopy = new GroupBean();
                groupBeanCopy.setId(groupBean.getId());
                groupBeanCopy.setWorkers(new ArrayList<WorkerBean>(groupBean.getWorkers()));
                groupBeanCopy.setName(groupBean.getName());
                groupBeanCopy.setServers(new ArrayList<ServerBean>(groupBean.getServers()));
                groupBeanCopy.setClustered(groupBean.getClustered());
                this.fillApplications(groupBeanCopy);
                result.add(groupBeanCopy);
            }
            return result;
        }
        return null;
    }

    @Override
    public void selectGroup(GroupBean selectedGroup) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_GROUP);
            for (GroupBean group : this.operation.getTopology().getGroups()) {
                if (!group.getId().equals(selectedGroup.getId())) continue;
                this.operation.setSelectedGroup(group);
                this.em.flush();
                return;
            }
            throw new JadortServiceException("GroupBean \"" + selectedGroup + "\" not found", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectOperationType(IJadortService.OperationType operationType) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
            if (IJadortService.OperationType.MAINTAIN.equals(operationType)) {
                HashSet<ServerProgressBean> oldServerProgressList = new HashSet<ServerProgressBean>();
                HashSet<WorkerProgressBean> oldWorkerProgressList = new HashSet<WorkerProgressBean>();
                if (this.operation.getServerProgressList() != null) {
                    oldServerProgressList.addAll(this.operation.getServerProgressList());
                }
                if (this.operation.getAllServerProgressList() != null) {
                    oldServerProgressList.addAll(this.operation.getAllServerProgressList());
                }
                if (this.operation.getWorkerProgressList() != null) {
                    oldWorkerProgressList.addAll(this.operation.getWorkerProgressList());
                }
                if (this.operation.getAllWorkerProgressList() != null) {
                    oldWorkerProgressList.addAll(this.operation.getAllWorkerProgressList());
                }
                this.operation.setServerProgressList(null);
                this.operation.setWorkerProgressList(null);
                this.operation.setAllServerProgressList(null);
                this.operation.setAllWorkerProgressList(null);
                this.operation.setType(IJadortService.OperationType.MAINTAIN);
                this.mergeOperation();
                for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                    this.em.remove((Object)serverProgressBean);
                }
                for (WorkerProgressBean workerProgressBean : oldWorkerProgressList) {
                    this.em.remove((Object)workerProgressBean);
                }
                this.em.flush();
            } else if (IJadortService.OperationType.MIGRATE.equals(operationType)) {
                ArrayList<ServerProgressBean> oldServerProgressList = null;
                if (this.operation.getServerProgressList() != null) {
                    oldServerProgressList = new ArrayList<ServerProgressBean>(this.operation.getServerProgressList());
                }
                ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                    boolean canDeployApplications;
                    ServerProgressBean serverProgressBean = new ServerProgressBean(server);
                    serverProgressList.add(serverProgressBean);
                    ServerAction action = ServerAction.getServerAction(server);
                    try {
                        canDeployApplications = action.canDeployApplications();
                    }
                    catch (Exception e) {
                        throw new JadortServiceException("Cannot check if server '" + server + "' can deploy applications: " + e.getMessage(), e);
                    }
                    if (canDeployApplications) continue;
                    throw new JadortServiceException("This version of JaDOrT doesn't support the deployment of applications on the server '" + server.getName() + "'. Please use the \"Maintenance\" functions instead.", null);
                }
                this.operation.setServerProgressList(serverProgressList);
                this.operation.setType(IJadortService.OperationType.MIGRATE);
                this.mergeOperation();
                if (oldServerProgressList != null) {
                    for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                        this.em.remove((Object)serverProgressBean);
                    }
                    this.em.flush();
                }
            } else {
                throw new IllegalStateException("Unknown operation type: " + operationType);
            }
        }
    }

    private void refreshActiveSessions() throws JadortServiceException {
        block17: {
            try {
                if (this.operation == null) {
                    return;
                }
                IJadortService.OperationType type = this.operation.getType();
                if (type == null) {
                    return;
                }
                if (type.equals(IJadortService.OperationType.MIGRATE)) {
                    if (this.operation.getServerProgressList() != null) {
                        for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                            ServerAction serverAction = ServerAction.getServerAction(serverProgressBean.getServer());
                            String oldApplication = serverProgressBean.getOldDeploymentItem();
                            if (oldApplication != null) {
                                try {
                                    serverProgressBean.getServer().setActiveSessions(serverAction.getActiveSessions(oldApplication));
                                }
                                catch (Exception ignored) {
                                    serverProgressBean.getServer().setActiveSessions(0);
                                }
                                continue;
                            }
                            serverProgressBean.getServer().setActiveSessions(0);
                        }
                    }
                    break block17;
                }
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                        ServerAction serverAction;
                        int activeSessions = 0;
                        try {
                            serverAction = ServerAction.getServerAction(server);
                            activeSessions = serverAction.getActiveSessions();
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        if (activeSessions == 0 && server.getTarget() != null) {
                            try {
                                serverAction = ServerAction.getServerAction(server.getTarget());
                                activeSessions = serverAction.getActiveSessions();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        server.setActiveSessions(activeSessions);
                    }
                    break block17;
                }
                throw new IllegalStateException("Unknown operation type: " + type);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot get the number of active sessions: " + e.getMessage(), e);
            }
        }
    }

    private ServerProgressBean getServerProgress(ServerBean server) throws JadortServiceException {
        for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
            if (!serverProgressBean.getServer().equals(server)) continue;
            return serverProgressBean;
        }
        throw new JadortServiceException("ServerBean \"" + server + "\" not found", null);
    }

    private WorkerProgressBean getWorkerProgress(WorkerBean worker) throws JadortServiceException {
        for (WorkerProgressBean workerProgressBean : this.operation.getWorkerProgressList()) {
            if (!workerProgressBean.getWorker().getId().equals(worker.getId())) continue;
            return workerProgressBean;
        }
        throw new JadortServiceException("WorkerBean \"" + worker + "\" not found", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nextExecuteMigration() {
        ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
        WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
        if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                if (aimedWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(20);
                } else if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(40);
                } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedProgressPercent(60);
                } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.START_OK);
                    this.operation.setAimedProgressPercent(80);
                } else if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.START_OK);
                    this.operation.setAimedProgressPercent(100);
                } else {
                    if (!aimedServerProgressState.equals(ServerProgressState.START_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                    this.operation.setAimedServerProgressState(ServerProgressState.DESTROY_VM_HOSTS_OK);
                    this.operation.setAimedProgressPercent(100);
                }
            } else if (aimedWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(16);
            } else if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DISABLE_APPLICATIONS_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(50);
            } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                this.operation.setAimedProgressPercent(66);
            } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.START_OK);
                this.operation.setAimedProgressPercent(83);
            } else if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.START_OK);
                this.operation.setAimedProgressPercent(100);
            } else {
                if (!aimedServerProgressState.equals(ServerProgressState.START_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                this.operation.setAimedServerProgressState(ServerProgressState.DESTROY_VM_HOSTS_OK);
                this.operation.setAimedProgressPercent(100);
            }
        } else {
            if (!this.operation.getType().equals(IJadortService.OperationType.MIGRATE)) throw new IllegalStateException("Unknown OperationType: " + this.operation.getType());
            if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                this.operation.setAimedServerProgressState(ServerProgressState.UPLOAD_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DEPLOY_OK);
                this.operation.setAimedProgressPercent(66);
            } else if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.SET_DEFAULT_OK);
                this.operation.setAimedProgressPercent(100);
            } else if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.UNDEPLOY_OK);
                this.operation.setAimedProgressPercent(50);
            } else {
                if (!aimedServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                this.operation.setAimedServerProgressState(ServerProgressState.ERASE_OK);
                this.operation.setAimedProgressPercent(100);
            }
        }
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getProgressState().equals(this.operation.getAimedServerProgressState())) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        if (this.operation.getWorkerProgressList() != null) {
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getProgressState().equals(this.operation.getAimedWorkerProgressState())) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        this.mergeOperation();
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
                this.reachAimedServerProgressState(serverProgress);
            }
        }
        if (this.operation.getWorkerProgressList() == null) return;
        for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
            this.reachAimedWorkerProgressState(workerProgress);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void previousExecuteMigration() {
        ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
        WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
        if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                if (aimedWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(80);
                } else if (aimedServerProgressState.equals(ServerProgressState.START_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedProgressPercent(60);
                } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(40);
                } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                    this.operation.setAimedProgressPercent(20);
                } else {
                    if (!aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.INITIAL);
                    this.operation.setAimedProgressPercent(0);
                }
            } else if (aimedWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(83);
            } else if (aimedServerProgressState.equals(ServerProgressState.START_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                this.operation.setAimedProgressPercent(66);
            } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(50);
            } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DISABLE_APPLICATIONS_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(16);
            } else {
                if (!aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                this.operation.setAimedWorkerProgressState(WorkerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
            }
        } else {
            if (!this.operation.getType().equals(IJadortService.OperationType.MIGRATE)) throw new IllegalStateException("Unknown OperationType: " + this.operation.getType());
            if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
            } else if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.UPLOAD_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DEPLOY_OK);
                this.operation.setAimedProgressPercent(66);
            } else {
                if (!aimedServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                this.operation.setAimedServerProgressState(ServerProgressState.SET_DEFAULT_OK);
                this.operation.setAimedProgressPercent(0);
            }
        }
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getProgressState().equals(this.operation.getAimedServerProgressState())) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        if (this.operation.getWorkerProgressList() != null) {
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getProgressState().equals(this.operation.getAimedWorkerProgressState())) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        this.mergeOperation();
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
                this.reachAimedServerProgressState(serverProgress);
            }
        }
        if (this.operation.getWorkerProgressList() == null) return;
        for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
            this.reachAimedWorkerProgressState(workerProgress);
        }
    }

    private void reachAimedServerProgressState(ServerProgressBean serverProgress) {
        ServerProgressState aimedServerProgressState;
        ServerProgressState currentServerProgressState;
        block59: {
            currentServerProgressState = serverProgress.getProgressState();
            aimedServerProgressState = this.operation.getAimedServerProgressState();
            try {
                IJadortService.OperationType type = this.operation.getType();
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    if (currentServerProgressState.equals(ServerProgressState.INITIAL)) {
                        if (this.operation.getSelectedGroup().getClustered()) {
                            if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                                if (serverProgress.getServer().getVm() != null) {
                                    this.stopVM(serverProgress, serverProgress.getOldDeploymentItem());
                                } else {
                                    this.stopServer(serverProgress);
                                }
                                return;
                            }
                        } else if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                            this.disableApplications(serverProgress);
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                this.stopVM(serverProgress, serverProgress.getOldDeploymentItem());
                            } else {
                                this.stopServer(serverProgress);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                            this.enableApplications(serverProgress);
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.STOP_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                this.createVM(serverProgress, serverProgress.getOldDeploymentItem());
                            } else {
                                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                                serverProgress.setProgressState(this.operation.getAimedServerProgressState());
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                            if (serverProgress.getServer().getVm() != null) {
                                this.startVM(serverProgress, serverProgress.getOldDeploymentItem());
                            } else {
                                this.startServer(serverProgress);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                this.startVM(serverProgress, serverProgress.getOldDeploymentItem());
                            } else {
                                this.startServer(serverProgress);
                            }
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.START_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                this.startVM(serverProgress, serverProgress.getNewDeploymentItem());
                            } else {
                                this.startServer(serverProgress);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                this.destroyVM(serverProgress, serverProgress.getNewDeploymentItem(), false);
                            } else {
                                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                                serverProgress.setProgressState(this.operation.getAimedServerProgressState());
                            }
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.START_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                this.stopVM(serverProgress, serverProgress.getNewDeploymentItem());
                            } else {
                                this.stopServer(serverProgress);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.DESTROY_VM_HOSTS_OK)) {
                            this.destroyVM(serverProgress, serverProgress.getOldDeploymentItem(), true);
                            return;
                        }
                        break block59;
                    }
                    throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                }
                if (type.equals(IJadortService.OperationType.MIGRATE)) {
                    if (currentServerProgressState.equals(ServerProgressState.INITIAL)) {
                        if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                            this.upload(serverProgress, this.operation.getApplication());
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                            this.deploy(serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                            this.erase(serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                            this.setAsDefault(serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                            this.undeploy(serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) {
                            if (!serverProgress.hasOldDeploymentItem()) {
                                throw new Exception("There's no old version or the old and new versions are the same");
                            }
                            this.undeploy(serverProgress, serverProgress.getOldDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                            if (serverProgress.getOldDeploymentItem() == null) {
                                serverProgress.appendToLog("There's no old version, ignoring step.\nThis implies that the new [and only] version will keep on being the default one.");
                                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                                serverProgress.setProgressState(aimedServerProgressState);
                            } else {
                                this.setAsDefault(serverProgress, serverProgress.getOldDeploymentItem());
                            }
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.ERASE_OK)) {
                            if (!serverProgress.hasOldDeploymentItem()) {
                                throw new Exception("There's no old version or the old and new versions are the same");
                            }
                            this.erase(serverProgress, serverProgress.getOldDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                            this.deploy(serverProgress, serverProgress.getOldDeploymentItem());
                            return;
                        }
                        break block59;
                    }
                    throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                }
                throw new IllegalStateException("Unknown OperationType: " + type);
            }
            catch (Exception e) {
                serverProgress.appendToLog("Failed executing server action: " + e.getClass().getCanonicalName() + ", " + e.getMessage());
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
                BufferedReader br = new BufferedReader(new StringReader(((Object)stackTrace).toString()));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        serverProgress.appendToLog(line);
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                serverProgress.setProgressState(this.operation.getAimedServerProgressState());
                return;
            }
        }
        serverProgress.appendToLog("Don't know what to do: operation.getAimedServerProgressState() is " + aimedServerProgressState + ", serverProgress.getProgressState() is " + currentServerProgressState);
        serverProgress.setProgress(this.operation.getAimedProgressPercent());
        serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
    }

    private void reachAimedWorkerProgressState(WorkerProgressBean workerProgress) {
        WorkerProgressState aimedWorkerProgressState;
        WorkerProgressState currentWorkerProgressState;
        block13: {
            currentWorkerProgressState = workerProgress.getProgressState();
            aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
            try {
                IJadortService.OperationType type = this.operation.getType();
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    if (currentWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                            this.stopWorker(workerProgress);
                            return;
                        }
                        break block13;
                    }
                    if (currentWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                            this.startWorker(workerProgress);
                            return;
                        }
                        if (aimedWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                            this.startWorker(workerProgress);
                            return;
                        }
                        break block13;
                    }
                    if (currentWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                            this.stopWorker(workerProgress);
                            return;
                        }
                        break block13;
                    }
                    throw new IllegalStateException("Unknown WorkerProgressState: " + currentWorkerProgressState);
                }
                throw new IllegalStateException("Unknown OperationType: " + type);
            }
            catch (Exception e) {
                workerProgress.appendToLog("Failed executing worker action: " + e.getClass().getCanonicalName() + ", " + e.getMessage());
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
                BufferedReader br = new BufferedReader(new StringReader(((Object)stackTrace).toString()));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        workerProgress.appendToLog(line);
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                workerProgress.setProgress(this.operation.getAimedProgressPercent());
                workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                workerProgress.setProgressState(this.operation.getAimedWorkerProgressState());
                return;
            }
        }
        workerProgress.appendToLog("Don't know what to do: operation.getAimedWorkerProgressState() is " + aimedWorkerProgressState + ", workerProgress.getAimedWorkerProgressState() is " + currentWorkerProgressState);
        workerProgress.setProgress(this.operation.getAimedProgressPercent());
        workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
    }

    private void upload(ServerProgressBean serverProgress, ApplicationBean application) throws JMSException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.UPLOAD.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setIntProperty(APPLICATION_ID, application.getId().intValue());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void deploy(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to deploy is null!", null);
        }
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.DEPLOY.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(APPLICATION_NAME, applicationName);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void setAsDefault(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to set as default is null!", null);
        }
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.SET_DEFAULT.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(APPLICATION_NAME, applicationName);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void undeploy(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to undeploy is null!", null);
        }
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.UNDEPLOY.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(APPLICATION_NAME, applicationName);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void erase(ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to erase is null!", null);
        }
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.ERASE.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(APPLICATION_NAME, applicationName);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Server state for server '" + server.getName() + "' is " + serverProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            this.mergeOperation();
            this.reachAimedServerProgressState(this.getServerProgress(server));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Server state for server '" + server.getName() + "' is " + serverProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            serverProgress.appendToLog("Error on the server has been ignored by the user");
            serverProgress.setProgress(this.operation.getAimedProgressPercent());
            serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
            serverProgress.setProgressState(this.operation.getAimedServerProgressState());
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) {
                return;
            }
            serverProgress.appendToLog("Action has been aborted by the user");
            serverProgress.setProgress(this.operation.getAimedProgressPercent());
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            this.mergeOperation();
        }
    }

    @Override
    public boolean checkServer(ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, OperationStateBean.Step.EXECUTING_MIGRATION_PART2, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
            try {
                ServerProgressBean serverProgress = this.getServerProgress(server);
                ServerAction serverAction = ServerAction.getServerAction(serverProgress.getServer());
                List<ApplicationBean> applications = serverAction.listOfApplications();
                ServerProgressState serverProgressState = serverProgress.getProgressState();
                if (serverProgressState.equals(ServerProgressState.INITIAL)) {
                    IJadortService.OperationType type = this.operation.getType();
                    if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                        return serverAction.isStarted();
                    }
                    if (type.equals(IJadortService.OperationType.MIGRATE)) {
                        for (ApplicationBean application : applications) {
                            if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, null, null)) {
                                return false;
                            }
                            if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, null, null)) {
                                return false;
                            }
                            if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                            return false;
                        }
                        return true;
                    }
                    throw new IllegalStateException("Unknown OperationType: " + type);
                }
                if (serverProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Present", null)) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Present", null)) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Reserved")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Reserved")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Disabled")) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.UNDEPLOY_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Present", null)) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.ERASE_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, null, null)) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK) || serverProgressState.equals(ServerProgressState.START_OK)) {
                    return serverAction.isStarted();
                }
                if (serverProgressState.equals(ServerProgressState.STOP_OK) || serverProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                    return !serverAction.isStarted();
                }
                if (serverProgressState.equals(ServerProgressState.DESTROY_VM_HOSTS_OK)) {
                    return false;
                }
                throw new IllegalStateException("Unknown ServerProgressState: " + serverProgressState);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot check server '" + server + "': " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean checkWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            try {
                WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
                WorkerAction workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                WorkerAction.State state = workerAction.getState();
                WorkerProgressState workerProgressState = workerProgress.getProgressState();
                if (workerProgressState.equals(WorkerProgressState.INITIAL) || workerProgressState.equals(WorkerProgressState.START_OK)) {
                    return state == WorkerAction.State.ACTIVE;
                }
                if (workerProgressState.equals(WorkerProgressState.STOP_OK)) {
                    return state == WorkerAction.State.STOPPED;
                }
                throw new IllegalStateException("Unknown WorkerProgressState: " + workerProgressState);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot check worker '" + worker + "': " + e.getMessage(), e);
            }
        }
    }

    protected boolean isSameApplication(ApplicationBean a1, ApplicationBean a2) {
        if (a1 == null || a2 == null || a1.getName() == null) {
            return false;
        }
        return a1.getName().equals(a2.getName()) && (a1.getVersion() == a2.getVersion() || a1.getVersion() != null && a1.getVersion().equals(a2.getVersion()));
    }

    protected boolean checkApplication(ServerProgressBean serverProgress, ApplicationBean application, String state, String policy) {
        if (state == null) {
            if (application != null) {
                serverProgress.appendToLog("Application " + application + " exists (it should not exist), checkServer will return false");
                return false;
            }
            return true;
        }
        if (state.equals(application.getState())) {
            if (policy == null) {
                if (application.getPolicy() != null) {
                    serverProgress.appendToLog("Application " + application + " has policy " + application.getPolicy() + " (it should not have any), checkServer will return false");
                    return false;
                }
                return true;
            }
            if (!policy.equals(application.getPolicy())) {
                serverProgress.appendToLog("Application " + application + " has policy " + application.getPolicy() + " instead of " + policy + ", checkServer will return false");
                return false;
            }
            return true;
        }
        serverProgress.appendToLog("Application " + application + " has state " + application.getState() + " instead of " + state + ", checkServer will return false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectApplication(URL url) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            ApplicationBean applicationBean;
            File file;
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_APPLICATION);
            if (url.getProtocol().equals("file")) {
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new JadortServiceException("Cannot create file for URL '" + url + "': " + e.getMessage(), e);
                }
            }
            try {
                int read;
                URLConnection connection = url.openConnection();
                InputStream reader = connection.getInputStream();
                String name = url.getPath();
                name = name.substring(name.lastIndexOf(47));
                file = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "jadort.temp." + System.currentTimeMillis());
                file.mkdirs();
                file = new File(file, name);
                FileOutputStream writer = new FileOutputStream(file);
                byte[] buffer = new byte[16384];
                while ((read = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, read);
                }
                writer.close();
                reader.close();
            }
            catch (IOException e) {
                throw new JadortServiceException("Cannot read from URL: '" + url + "'", null);
            }
            try {
                applicationBean = new ApplicationBean(file);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot create application for URL '" + url + "': " + e.getMessage(), e);
            }
            ApplicationBean oldApplicationBean = this.operation.getApplication();
            this.operation.setApplication(applicationBean);
            this.mergeOperation();
            if (oldApplicationBean != null) {
                this.em.remove((Object)oldApplicationBean);
                this.em.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStateBean.Step getCurrentStep() {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            if (this.operation == null) {
                return OperationStateBean.Step.SELECT_OPERATION;
            }
            return this.operation.getCurrentStep();
        }
    }

    private void fillApplications(GroupBean groupBean) throws JadortServiceException {
        TreeMap<String, ApplicationBean> applications = new TreeMap<String, ApplicationBean>();
        for (ServerBean serverBean : groupBean.getServers()) {
            ServerAction serverAction = ServerAction.getServerAction(serverBean);
            try {
                for (ApplicationBean applicationBean : serverAction.listOfApplications()) {
                    applications.put(applicationBean.toString(), applicationBean);
                }
            }
            catch (Exception e) {
                String message = e.getClass().getName() + ": " + e.getMessage();
                throw new JadortServiceException("Failed getting the applications on the server " + serverBean.getName() + ": " + message, e);
            }
        }
        groupBean.setApplications(new ArrayList<ApplicationBean>(applications.values()));
    }

    private void fillVMImages(GroupBean groupBean) throws JadortServiceException {
        ServerBean serverBean = groupBean.getServers().iterator().next();
        ArrayList<VMImageBean> vmImages = new ArrayList<VMImageBean>();
        VMBean vmBean = serverBean.getVm();
        if (vmBean != null) {
            VMMAction vmAction = VMMAction.getVMMAction(vmBean);
            try {
                for (VMImageBean vmImageBean : vmAction.getVMImages()) {
                    vmImages.add(vmImageBean);
                }
            }
            catch (Exception e) {
                String message = e.getClass().getName() + ": " + e.getMessage();
                throw new JadortServiceException("Failed getting the VM images on the virtual machine manager " + vmBean.getVmm() + ": " + message, e);
            }
            groupBean.setVmImages(vmImages);
        }
    }

    private boolean hasOldVersion() {
        for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
            if (!serverProgress.hasOldDeploymentItem()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void next() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            if (!this.canGoToNextStep()) {
                throw new JadortServiceException("You are not allowed to go to the next step!", null);
            }
            OperationStateBean.Step currentStep = this.operation.getCurrentStep();
            if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
                for (GroupBean group : this.operation.getTopology().getGroups()) {
                    String message;
                    if (group.getServers() != null) {
                        for (ServerBean server : group.getServers()) {
                            ServerAction serverAction = ServerAction.getServerAction(server);
                            try {
                                serverAction.listOfApplications();
                            }
                            catch (Exception e) {
                                message = e.getClass().getName() + ": " + e.getMessage();
                                throw new JadortServiceException("Failed getting the state of the server " + server.getName() + ": " + message, e);
                            }
                            if (server.getVm() == null) continue;
                            VMMAction vmmAction = VMMAction.getVMMAction(server.getVm());
                            try {
                                String fullServerName = vmmAction.getFullVMName(server.getVm().getName());
                                vmmAction.getVMState(fullServerName);
                            }
                            catch (Exception e) {
                                String message2 = e.getClass().getName() + ": " + e.getMessage();
                                throw new JadortServiceException("Failed getting the state of the VM " + server.getVm().getName() + ": " + message2, e);
                            }
                        }
                    }
                    if (group.getWorkers() == null) continue;
                    for (WorkerBean worker : group.getWorkers()) {
                        WorkerAction workerAction = WorkerAction.getWorkerAction(worker);
                        try {
                            workerAction.getState();
                        }
                        catch (Exception e) {
                            message = e.getClass().getName() + ": " + e.getMessage();
                            throw new JadortServiceException("Failed getting the state of the worker " + worker.getName() + ": " + message, e);
                        }
                    }
                }
            }
            if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
                if (!this.operation.getAimedWorkerProgressState().equals(WorkerProgressState.START_OK)) {
                    this.nextExecuteMigration();
                } else {
                    for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                        serverProgressBean.getServer().setMaintained(true);
                    }
                    for (WorkerProgressBean workerProgressBean : this.operation.getWorkerProgressList()) {
                        workerProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                    if (this.operation.getSelectedGroup().getServers().get(0).getVm() == null) {
                        for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                            serverProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                        }
                    } else {
                        ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                        serverProgressList.addAll(this.operation.getAllServerProgressList());
                        this.operation.setServerProgressList(serverProgressList);
                        for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                            serverProgress.setProgress(0);
                        }
                    }
                    this.goToNextStep();
                }
            } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
                if (!this.operation.getAimedServerProgressState().equals(ServerProgressState.DESTROY_VM_HOSTS_OK)) {
                    this.nextExecuteMigration();
                } else {
                    for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                        serverProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                    this.goToNextStep();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressState.SET_DEFAULT_OK)) {
                    if (!this.hasOldVersion()) {
                        for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                            serverProgressServer.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                        }
                        this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
                    } else {
                        for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                            serverProgress.setProgress(0);
                        }
                    }
                    this.goToNextStep();
                } else {
                    this.nextExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressState.ERASE_OK)) {
                    for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                        serverProgressServer.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                    this.goToNextStep();
                } else {
                    this.nextExecuteMigration();
                }
            } else {
                this.goToNextStep();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void goToNextStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION)) {
            this.operation.setCurrentStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
        } else if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_GROUP);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            IJadortService.OperationType operationType = this.operation.getType();
            if (operationType.equals(IJadortService.OperationType.MIGRATE)) {
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_APPLICATION);
            } else {
                if (!operationType.equals(IJadortService.OperationType.MAINTAIN)) throw new IllegalStateException("Unknown OperationType: " + operationType);
                if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                    this.operation.setCurrentStep(OperationStateBean.Step.SELECT_VM_IMAGE);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
                }
            }
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    if (serverProgress.getVmImage() != null) continue;
                    this.operation.setCurrentStep(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER);
                    break;
                }
            }
            if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_SERVERS)) {
                if (this.operation.getSelectedGroup().getClustered()) {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                }
            }
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            if (this.allServersHaveBeenMaintained()) {
                ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                serverProgressList.addAll(this.operation.getAllServerProgressList());
                this.operation.setServerProgressList(serverProgressList);
                if (this.operation.getSelectedGroup().getServers().get(0).getVm() == null) {
                    this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
                } else {
                    ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
                    this.operation.setWorkerProgressList(workerProgressList);
                    this.operation.setCurrentStep(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
                }
            } else {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
                this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
                this.operation.setSelectedServers(null);
            }
        } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
            workerProgressList.addAll(this.operation.getAllWorkerProgressList());
            this.operation.setWorkerProgressList(workerProgressList);
            this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            this.operation.setAimedProgressPercent(0);
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            this.operation.setAimedProgressPercent(0);
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            this.operation.setAimedProgressPercent(100);
            this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
        } else {
            if (!currentStep.equals(OperationStateBean.Step.FINISHED)) throw new IllegalStateException("Unknown Step: " + currentStep);
            throw new IllegalStateException("No next for Step: " + currentStep);
        }
        this.mergeOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previous() throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            if (!this.canGoToPreviousStep()) {
                throw new JadortServiceException("You are not allowed to go to the previous step!", null);
            }
            OperationStateBean.Step currentStep = this.operation.getCurrentStep();
            if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
                TopologyBean oldTopology = this.operation.getTopology();
                this.operation.setTopology(null);
                this.goToPreviousStep();
                this.em.remove((Object)oldTopology);
                this.em.flush();
            } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
                ArrayList<ServerProgressBean> oldServerProgressList = new ArrayList<ServerProgressBean>();
                oldServerProgressList.addAll(this.operation.getServerProgressList());
                this.operation.setServerProgressList(null);
                this.operation.setType(null);
                ApplicationBean oldApplication = this.operation.getApplication();
                this.operation.setApplication(null);
                this.goToPreviousStep();
                for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                    this.em.remove((Object)serverProgressBean);
                }
                if (oldApplication != null) {
                    this.em.remove((Object)oldApplication);
                }
                this.em.flush();
            } else if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
                this.operation.setSelectedGroup(null);
                this.goToPreviousStep();
            } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
                this.operation.setType(null);
                this.goToPreviousStep();
            } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
                this.goToPreviousStep();
            } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
                if (this.anyMaintainedServerPresent()) {
                    this.operation.setAimedProgressPercent(100);
                    this.operation.setAimedServerProgressState(ServerProgressState.START_OK);
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.START_OK);
                    ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                    for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                        if (!serverProgress.getServer().getMaintained()) continue;
                        serverProgress.setProgress(this.operation.getAimedProgressPercent());
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        serverProgress.getServer().setMaintained(false);
                        serverProgressList.add(serverProgress);
                    }
                    this.operation.setServerProgressList(serverProgressList);
                    ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
                    for (WorkerProgressBean workerProgress : this.operation.getAllWorkerProgressList()) {
                        if (!WorkerProgressState.START_OK.equals(workerProgress.getProgressState())) continue;
                        workerProgress.setProgress(this.operation.getAimedProgressPercent());
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                        workerProgressList.add(workerProgress);
                    }
                    this.operation.setWorkerProgressList(workerProgressList);
                    if (this.operation.getSelectedGroup().getClustered()) {
                        this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                    } else {
                        this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                    }
                    this.mergeOperation();
                } else {
                    HashSet<ServerProgressBean> oldServerProgressList = new HashSet<ServerProgressBean>();
                    if (this.operation.getServerProgressList() != null) {
                        oldServerProgressList.addAll(this.operation.getServerProgressList());
                    }
                    if (this.operation.getAllServerProgressList() != null) {
                        oldServerProgressList.addAll(this.operation.getAllServerProgressList());
                    }
                    HashSet<WorkerProgressBean> oldWorkerProgressList = new HashSet<WorkerProgressBean>();
                    if (this.operation.getWorkerProgressList() != null) {
                        oldWorkerProgressList.addAll(this.operation.getWorkerProgressList());
                    }
                    if (this.operation.getAllWorkerProgressList() != null) {
                        oldWorkerProgressList.addAll(this.operation.getAllWorkerProgressList());
                    }
                    this.operation.setServerProgressList(null);
                    this.operation.setWorkerProgressList(null);
                    this.operation.setAllServerProgressList(null);
                    this.operation.setAllWorkerProgressList(null);
                    VMImageBean oldVMImage = this.operation.getVmImage();
                    this.operation.setVmImage(null);
                    this.goToPreviousStep();
                    for (WorkerProgressBean workerProgressBean : oldWorkerProgressList) {
                        this.em.remove((Object)workerProgressBean);
                    }
                    for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                        this.em.remove((Object)serverProgressBean);
                    }
                    if (oldVMImage != null) {
                        this.em.remove((Object)oldVMImage);
                    }
                    this.em.flush();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER)) {
                if (this.operation.getAimedWorkerProgressState().equals(WorkerProgressState.INITIAL)) {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setProgress(this.operation.getAimedProgressPercent());
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setProgress(this.operation.getAimedProgressPercent());
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
                if (this.operation.getAimedWorkerProgressState().equals(WorkerProgressState.INITIAL)) {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setProgress(this.operation.getAimedProgressPercent());
                        serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setProgress(this.operation.getAimedProgressPercent());
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
                ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
                workerProgressList.addAll(this.operation.getAllWorkerProgressList());
                this.operation.setWorkerProgressList(workerProgressList);
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    serverProgress.setProgressState(ServerProgressState.START_OK);
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    workerProgress.setProgressState(WorkerProgressState.START_OK);
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                this.goToPreviousStep();
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressState.INITIAL)) {
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
                if (this.operation.getAimedServerProgressState().equals(ServerProgressState.SET_DEFAULT_OK)) {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setProgress(100);
                    }
                    this.goToPreviousStep();
                } else {
                    this.previousExecuteMigration();
                }
            } else if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.getServer().setMaintained(false);
                    }
                    for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                        workerProgress.setProgress(this.operation.getAimedProgressPercent());
                        workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    }
                }
                this.goToPreviousStep();
            } else {
                throw new IllegalStateException("Unknown Step: " + currentStep);
            }
        }
    }

    private void goToPreviousStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        ArrayList<VMImageBean> oldVMImages = new ArrayList<VMImageBean>();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION) || currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            throw new IllegalStateException("No previous for Step: " + currentStep);
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            this.operation.setCurrentStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            this.operation.setType(null);
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_GROUP);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_VM_IMAGE);
            } else {
                this.operation.setType(null);
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
            this.operation.setSelectedServers(null);
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                serverProgress.setOldDeploymentItem(null);
                if (serverProgress.getVmImage() == null) continue;
                oldVMImages.add(serverProgress.getVmImage());
                serverProgress.setVmImage(null);
            }
        } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            this.operation.setAimedProgressPercent(0);
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_APPLICATION);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            this.operation.setAimedProgressPercent(100);
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
        } else if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            this.operation.setAimedProgressPercent(100);
            if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
                if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                    this.operation.setCurrentStep(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
                } else if (this.operation.getSelectedGroup().getClustered()) {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                }
            } else if (this.hasOldVersion()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
            }
        } else {
            throw new IllegalStateException("Unknown Step: " + currentStep);
        }
        this.mergeOperation();
        for (VMImageBean oldVMImage : oldVMImages) {
            this.em.remove((Object)oldVMImage);
            this.em.flush();
        }
    }

    private boolean canGoToNextStep() {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION)) {
            return this.operation != null;
        }
        if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            return this.operation.getTopology() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            return this.operation.getSelectedGroup() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            return this.operation.getType() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getVmImage() != null) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            return this.operation.getApplication() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1) || currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            return this.operation.getSelectedServers() != null && this.operation.getSelectedServers().size() > 0;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER) || currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                return false;
            }
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            return false;
        }
        throw new IllegalStateException("Unknown Step: " + currentStep);
    }

    private boolean canGoToPreviousStep() {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION) || currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            return false;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP) || currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION) || currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE) || currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER) || currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1) || currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            if (this.operation.getAimedServerProgressState().equals(ServerProgressState.ERASE_OK)) {
                return false;
            }
            ServerProgressState progressState = null;
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) && !serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                    return false;
                }
                if (progressState == null) {
                    progressState = serverProgress.getProgressState();
                    continue;
                }
                if (progressState.equals(serverProgress.getProgressState())) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) || serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) continue;
                return false;
            }
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) || workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING) && serverProgress.getProgress() <= 0) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            return true;
        }
        throw new IllegalStateException("Unknown Step: " + currentStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectOperation(OperationStateBean selectedOperation) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            this.operation = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)selectedOperation.getId());
            if (this.operation == null) {
                throw new JadortServiceException("OperationStateBean \"" + selectedOperation + "\" not found", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNewOperation(String newOperationName) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            String filteredOperationName = newOperationName.trim();
            if (filteredOperationName.length() < 1) {
                throw new JadortServiceException("Operation name cannot be empty!", null);
            }
            this.operation = new OperationStateBean();
            this.operation.setName(filteredOperationName);
            this.operation.setDate(new Date());
            this.em.persist((Object)this.operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOperation(OperationStateBean selectedOperation) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            OperationStateBean toRemove = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)selectedOperation.getId());
            if (toRemove.getIsDeletable()) {
                this.em.remove((Object)toRemove);
                this.em.flush();
                if (this.operation != null && selectedOperation.getId() == this.operation.getId()) {
                    this.operation = null;
                }
            } else {
                throw new JadortServiceException("Operation could not be deleted because it currently is in the " + toRemove.getCurrentStep() + " step.", null);
            }
        }
    }

    private void checkStep(OperationStateBean.Step ... steps) throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation == null ? OperationStateBean.Step.SELECT_OPERATION : this.operation.getCurrentStep();
        for (OperationStateBean.Step step : steps) {
            if (!currentStep.equals(step)) continue;
            return;
        }
        throw new JadortServiceException(currentStep, steps);
    }

    private void refreshOperation() {
        if (this.operation != null) {
            this.operation = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)this.operation.getId());
        }
    }

    private void mergeOperation() {
        if (this.operation != null) {
            this.operation = (OperationStateBean)this.em.merge((Object)this.operation);
            this.em.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectServers(List<ServerBean> selectedServers) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_SERVERS);
            ArrayList<ServerBean> selectedServersList = new ArrayList<ServerBean>();
            ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
            block5: for (ServerBean selectedServer : selectedServers) {
                for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                    if (!server.equals(selectedServer)) continue;
                    if (selectedServersList.contains(server)) continue block5;
                    selectedServersList.add(server);
                    boolean hasProgress = false;
                    if (this.operation.getAllServerProgressList() != null) {
                        for (ServerProgressBean oldServerProgress : this.operation.getAllServerProgressList()) {
                            if (!oldServerProgress.getServer().equals(server)) continue;
                            hasProgress = true;
                            serverProgressList.add(oldServerProgress);
                            break;
                        }
                    }
                    if (hasProgress) continue block5;
                    serverProgressList.add(new ServerProgressBean(server));
                    continue block5;
                }
            }
            if (selectedServersList.size() == 0 || serverProgressList.size() == 0) {
                throw new JadortServiceException("You must select at least one server!", null);
            }
            for (ServerProgressBean serverProgress : serverProgressList) {
                if (!serverProgress.getServer().getMaintained()) continue;
                throw new JadortServiceException("The server '" + serverProgress.getServer().getName() + "' has already been maintained!", null);
            }
            ArrayList<VMImageBean> oldVMImages = new ArrayList<VMImageBean>();
            for (ServerProgressBean serverProgress : serverProgressList) {
                String oldVMFullName;
                VMBean vm;
                if (serverProgress.getOldDeploymentItem() != null) {
                    throw new JadortServiceException("The VM for server '" + serverProgress.getServer().getName() + "' has already been maintained!", null);
                }
                if (serverProgress.getVmImage() != null) {
                    oldVMImages.add(serverProgress.getVmImage());
                }
                if (this.operation.getVmImage() != null) {
                    VMImageBean image = new VMImageBean();
                    image.setName(this.operation.getVmImage().getName());
                    image.setUuid(this.operation.getVmImage().getUuid());
                    serverProgress.setVmImage(image);
                } else {
                    serverProgress.setVmImage(null);
                }
                if ((vm = serverProgress.getServer().getVm()) == null) continue;
                VMMAction vmmAction = VMMAction.getVMMAction(vm);
                try {
                    oldVMFullName = vmmAction.getFullVMName(vm.getName());
                }
                catch (Exception e) {
                    throw new JadortServiceException("Failed getting the full VM name for VM '" + vm.getName() + "': " + e.getMessage(), e);
                }
                serverProgress.setOldDeploymentItem(oldVMFullName);
            }
            this.operation.setSelectedServers(selectedServersList);
            this.operation.setServerProgressList(serverProgressList);
            HashSet<WorkerBean> workersList = new HashSet<WorkerBean>();
            ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
            for (WorkerBean worker : this.operation.getSelectedGroup().getWorkers()) {
                for (ServerBean server : selectedServersList) {
                    if (!worker.getServer().equals(server)) continue;
                    workersList.add(worker);
                }
            }
            for (WorkerBean worker : workersList) {
                boolean hasProgress = false;
                if (this.operation.getAllWorkerProgressList() != null) {
                    for (WorkerProgressBean oldWorkerProgress : this.operation.getAllWorkerProgressList()) {
                        if (!oldWorkerProgress.getWorker().equals(worker)) continue;
                        hasProgress = true;
                        workerProgressList.add(oldWorkerProgress);
                        break;
                    }
                }
                if (hasProgress) continue;
                workerProgressList.add(new WorkerProgressBean(worker));
            }
            this.operation.setWorkerProgressList(workerProgressList);
            this.mergeOperation();
            this.operation.addAllServerProgressList(serverProgressList);
            this.operation.addAllWorkerProgressList(workerProgressList);
            this.mergeOperation();
            for (VMImageBean oldVMImage : oldVMImages) {
                this.em.remove((Object)oldVMImage);
                this.em.flush();
            }
        }
    }

    private void stopServer(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.STOP_SERVER.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void disableApplications(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.DISABLE_APPLICATIONS.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void enableApplications(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.ENABLE_APPLICATIONS.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void stopWorker(WorkerProgressBean workerProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.STOP_WORKER.toString());
        message.setIntProperty(WORKER_PROGRESS_ID, workerProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedWorkerProgressState().toString());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void startWorker(WorkerProgressBean workerProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.START_WORKER.toString());
        message.setIntProperty(WORKER_PROGRESS_ID, workerProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedWorkerProgressState().toString());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void startServer(ServerProgressBean serverProgress) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.START_SERVER.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private boolean allServersHaveBeenMaintained() {
        for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
            if (server.getMaintained()) continue;
            return false;
        }
        return true;
    }

    private boolean anyMaintainedServerPresent() {
        if (this.operation.getAllServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                if (!ServerProgressState.START_OK.equals(serverProgress.getProgressState())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Worker state for worker '" + worker.getName() + "' is " + workerProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            this.mergeOperation();
            this.reachAimedWorkerProgressState(this.getWorkerProgress(worker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Worker state for worker '" + worker.getName() + "' is " + workerProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            workerProgress.appendToLog("Error on the worker has been ignored by the user");
            workerProgress.setProgress(this.operation.getAimedProgressPercent());
            workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
            workerProgress.setProgressState(this.operation.getAimedWorkerProgressState());
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) {
                return;
            }
            workerProgress.appendToLog("Action has been aborted by the user");
            workerProgress.setProgress(this.operation.getAimedProgressPercent());
            workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            this.mergeOperation();
        }
    }

    private void startVM(ServerProgressBean serverProgress, String vmName) throws JMSException, JadortServiceException {
        if (vmName == null) {
            throw new JadortServiceException("The name of the VM to start is null!", null);
        }
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.START_VM.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(VM_NAME, vmName);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void stopVM(ServerProgressBean serverProgress, String vmName) throws JMSException, JadortServiceException {
        if (vmName == null) {
            throw new JadortServiceException("The name of the VM to stop is null!", null);
        }
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.STOP_VM.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(VM_NAME, vmName);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void createVM(ServerProgressBean serverProgress, String vmName) throws JMSException, JadortServiceException {
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.CREATE_VM.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(VM_IMAGE_UUID, serverProgress.getVmImage().getUuid());
        message.setStringProperty(VM_NAME, vmName);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    private void destroyVM(ServerProgressBean serverProgress, String vmName, boolean checkIfHostHalted) throws JMSException, JadortServiceException {
        if (vmName == null) {
            throw new JadortServiceException("The name of the VM to destroy is null!", null);
        }
        Message message = this.session.createMessage();
        message.setStringProperty(OPERATION_TYPE, IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty(ACTION_TYPE, ActionType.DESTROY_VM.toString());
        message.setIntProperty(SERVER_PROGRESS_ID, serverProgress.getId().intValue());
        message.setIntProperty(AIMED_PROGRESS_PERCENT, this.operation.getAimedProgressPercent());
        message.setStringProperty(AIMED_STATE, this.operation.getAimedServerProgressState().toString());
        message.setStringProperty(VM_NAME, vmName);
        message.setBooleanProperty(CHECK_IF_HOST_HALTED, checkIfHostHalted);
        QueueSender sender = this.session.createSender(this.queue);
        sender.send(message);
    }

    @Override
    public void selectVMImage(VMImageBean selectedVMImage) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_VM_IMAGE);
            this.fillVMImages(this.operation.getSelectedGroup());
            for (VMImageBean vMImage : this.operation.getSelectedGroup().getVmImages()) {
                if (!vMImage.equals(selectedVMImage)) continue;
                VMImageBean oldVMImage = this.operation.getVmImage();
                this.operation.setVmImage(vMImage);
                this.mergeOperation();
                if (oldVMImage != null) {
                    this.em.remove((Object)oldVMImage);
                    this.em.flush();
                }
                return;
            }
            throw new JadortServiceException("VMImageBean \"" + selectedVMImage + "\" not found", null);
        }
    }

    @Override
    public void selectVMImage(VMImageBean selectedVMImage, ServerBean server) throws JadortServiceException {
        JadortServiceImpl jadortServiceImpl = this;
        synchronized (jadortServiceImpl) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER);
            this.fillVMImages(this.operation.getSelectedGroup());
            ServerProgressBean serverProgress = this.getServerProgress(server);
            for (VMImageBean vMImage : this.operation.getSelectedGroup().getVmImages()) {
                if (!vMImage.equals(selectedVMImage)) continue;
                VMImageBean oldVMImage = serverProgress.getVmImage();
                serverProgress.setVmImage(vMImage);
                this.mergeOperation();
                if (oldVMImage != null) {
                    this.em.remove((Object)oldVMImage);
                    this.em.flush();
                }
                return;
            }
            throw new JadortServiceException("VMImageBean \"" + selectedVMImage + "\" not found", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ActionType {
        UPLOAD,
        DEPLOY,
        SET_DEFAULT,
        UNDEPLOY,
        ERASE,
        START_SERVER,
        STOP_SERVER,
        START_WORKER,
        STOP_WORKER,
        DISABLE_APPLICATIONS,
        ENABLE_APPLICATIONS,
        START_VM,
        CREATE_VM,
        DESTROY_VM,
        STOP_VM;

    }
}

