/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.service.implementation.JMSReceiver;

public class JMSSender {
    protected static QueueConnection qc;
    protected static QueueSession session;
    protected static Queue queue;

    public static void connect() throws NamingException, JMSException {
        InitialContext ctx = new InitialContext();
        queue = (Queue)ctx.lookup("queue/JadortServiceJMSQueue");
        QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("QCF");
        qc = factory.createQueueConnection();
        session = qc.createQueueSession(false, 1);
    }

    public static void disconnect() throws JMSException {
        session.close();
        qc.close();
    }

    public static void upload(OperationStateBean operation, ServerProgressBean serverProgress, ApplicationBean application) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.UPLOAD.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setIntProperty("applicationId", application.getId().intValue());
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void deploy(OperationStateBean operation, ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to deploy is null!", null);
        }
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.DEPLOY.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("applicationName", applicationName);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void setAsDefault(OperationStateBean operation, ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to set as default is null!", null);
        }
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.SET_DEFAULT.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("applicationName", applicationName);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void undeploy(OperationStateBean operation, ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to undeploy is null!", null);
        }
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.UNDEPLOY.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("applicationName", applicationName);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void erase(OperationStateBean operation, ServerProgressBean serverProgress, String applicationName) throws JMSException, JadortServiceException {
        if (applicationName == null) {
            throw new JadortServiceException("The application to erase is null!", null);
        }
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MIGRATE.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.ERASE.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("applicationName", applicationName);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void stopServer(OperationStateBean operation, ServerProgressBean serverProgress) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.STOP_SERVER.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void startServer(OperationStateBean operation, ServerProgressBean serverProgress) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.START_SERVER.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void disableApplications(OperationStateBean operation, ServerProgressBean serverProgress) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.DISABLE_APPLICATIONS.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void enableApplications(OperationStateBean operation, ServerProgressBean serverProgress) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.ENABLE_APPLICATIONS.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void startWorker(OperationStateBean operation, WorkerProgressBean workerProgress) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.START_WORKER.toString());
        message.setIntProperty("workerProgressId", workerProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedWorkerProgressState().toString());
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void stopWorker(OperationStateBean operation, WorkerProgressBean workerProgress) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.STOP_WORKER.toString());
        message.setIntProperty("workerProgressId", workerProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedWorkerProgressState().toString());
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void startVM(OperationStateBean operation, ServerProgressBean serverProgress, String vmName) throws JMSException, JadortServiceException {
        if (vmName == null) {
            throw new JadortServiceException("The name of the VM to start is null!", null);
        }
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.START_VM.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("vmName", vmName);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void stopVM(OperationStateBean operation, ServerProgressBean serverProgress, String vmName) throws JMSException, JadortServiceException {
        if (vmName == null) {
            throw new JadortServiceException("The name of the VM to stop is null!", null);
        }
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.STOP_VM.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("vmName", vmName);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void createVM(OperationStateBean operation, ServerProgressBean serverProgress, String vmName) throws JMSException {
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.CREATE_VM.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("vmImageUUID", serverProgress.getVmImage().getUuid());
        message.setStringProperty("vmName", vmName);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }

    public static void destroyVM(OperationStateBean operation, ServerProgressBean serverProgress, String vmName, boolean checkIfHostHalted) throws JMSException, JadortServiceException {
        if (vmName == null) {
            throw new JadortServiceException("The name of the VM to destroy is null!", null);
        }
        Message message = session.createMessage();
        message.setStringProperty("operationType", IJadortService.OperationType.MAINTAIN.toString());
        message.setStringProperty("actionType", JMSReceiver.ActionType.DESTROY_VM.toString());
        message.setIntProperty("serverProgressId", serverProgress.getId().intValue());
        message.setIntProperty("aimedProgressPercent", operation.getAimedProgressPercent());
        message.setStringProperty("aimedState", operation.getAimedServerProgressState().toString());
        message.setStringProperty("vmName", vmName);
        message.setBooleanProperty("checkIfHostHalted", checkIfHostHalted);
        QueueSender sender = session.createSender(queue);
        sender.send(message);
    }
}

