/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.util.ArrayList;
import java.util.HashSet;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.InvalidStepException;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressState;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.TopologyBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;
import org.ow2.jasmine.jadort.service.action.VMMAction;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.implementation.ActionManager;

public class StepManager
extends ActionManager {
    protected boolean canGoToNextStep() {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION)) {
            return this.operation != null;
        }
        if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            return this.operation.getTopology() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            return this.operation.getSelectedGroup() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            return this.operation.getType() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getVmImage() != null) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            return this.operation.getApplication() != null;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1) || currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            return this.operation.getSelectedServers() != null && this.operation.getSelectedServers().size() > 0;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER) || currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                return false;
            }
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getActionState().equals(OperationStateBean.ActionState.WAITING)) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            return false;
        }
        throw new IllegalStateException("Unknown Step: " + currentStep);
    }

    protected void executeNextStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            for (GroupBean group : this.operation.getTopology().getGroups()) {
                String message;
                if (group.getServers() != null) {
                    for (ServerBean server : group.getServers()) {
                        ServerAction serverAction = ServerAction.getServerAction(server);
                        try {
                            serverAction.listOfApplications();
                        }
                        catch (Exception e) {
                            message = e.getClass().getName() + ": " + e.getMessage();
                            throw new JadortServiceException("Failed getting the state of the server " + server.getName() + ": " + message, e);
                        }
                        if (server.getVm() == null) continue;
                        VMMAction vmmAction = VMMAction.getVMMAction(server.getVm());
                        try {
                            String fullServerName = vmmAction.getFullVMName(server.getVm().getName());
                            vmmAction.getVMState(fullServerName);
                        }
                        catch (Exception e) {
                            String message2 = e.getClass().getName() + ": " + e.getMessage();
                            throw new JadortServiceException("Failed getting the state of the VM " + server.getVm().getName() + ": " + message2, e);
                        }
                    }
                }
                if (group.getWorkers() == null) continue;
                for (WorkerBean worker : group.getWorkers()) {
                    WorkerAction workerAction = WorkerAction.getWorkerAction(worker);
                    try {
                        workerAction.getState();
                    }
                    catch (Exception e) {
                        message = e.getClass().getName() + ": " + e.getMessage();
                        throw new JadortServiceException("Failed getting the state of the worker " + worker.getName() + ": " + message, e);
                    }
                }
            }
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            if (!this.operation.getAimedWorkerProgressState().equals(WorkerProgressState.START_OK)) {
                this.nextExecuteMigration();
            } else {
                for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                    serverProgressBean.getServer().setMaintained(true);
                }
                for (WorkerProgressBean workerProgressBean : this.operation.getWorkerProgressList()) {
                    workerProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                }
                if (this.operation.getSelectedGroup().getServers().get(0).getVm() == null) {
                    for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                        serverProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                } else {
                    ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                    serverProgressList.addAll(this.operation.getAllServerProgressList());
                    this.operation.setServerProgressList(serverProgressList);
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setProgress(0);
                    }
                }
                this.goToNextStep();
            }
        } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            if (!this.operation.getAimedServerProgressState().equals(ServerProgressState.DESTROY_VM_HOSTS_OK)) {
                this.nextExecuteMigration();
            } else {
                for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                    serverProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                }
                this.goToNextStep();
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            if (this.operation.getAimedServerProgressState().equals(ServerProgressState.SET_DEFAULT_OK)) {
                if (!this.hasOldVersion()) {
                    for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                        serverProgressServer.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                    }
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
                } else {
                    for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                        serverProgress.setProgress(0);
                    }
                }
                this.goToNextStep();
            } else {
                this.nextExecuteMigration();
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            if (this.operation.getAimedServerProgressState().equals(ServerProgressState.ERASE_OK)) {
                for (ServerProgressBean serverProgressServer : this.operation.getServerProgressList()) {
                    serverProgressServer.setActionState(OperationStateBean.ActionState.FINISHED_OK);
                }
                this.goToNextStep();
            } else {
                this.nextExecuteMigration();
            }
        } else {
            this.goToNextStep();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void goToNextStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION)) {
            this.operation.setCurrentStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
        } else if (currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_GROUP);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            IJadortService.OperationType operationType = this.operation.getType();
            if (operationType.equals(IJadortService.OperationType.MIGRATE)) {
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_APPLICATION);
            } else {
                if (!operationType.equals(IJadortService.OperationType.MAINTAIN)) throw new IllegalStateException("Unknown OperationType: " + operationType);
                if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                    this.operation.setCurrentStep(OperationStateBean.Step.SELECT_VM_IMAGE);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
                }
            }
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    if (serverProgress.getVmImage() != null) continue;
                    this.operation.setCurrentStep(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER);
                    break;
                }
            }
            if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_SERVERS)) {
                if (this.operation.getSelectedGroup().getClustered()) {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                }
            }
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            if (this.allServersHaveBeenMaintained()) {
                ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                serverProgressList.addAll(this.operation.getAllServerProgressList());
                this.operation.setServerProgressList(serverProgressList);
                if (this.operation.getSelectedGroup().getServers().get(0).getVm() == null) {
                    this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
                } else {
                    ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
                    this.operation.setWorkerProgressList(workerProgressList);
                    this.operation.setCurrentStep(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
                }
            } else {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
                this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
                this.operation.setSelectedServers(null);
            }
        } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
            workerProgressList.addAll(this.operation.getAllWorkerProgressList());
            this.operation.setWorkerProgressList(workerProgressList);
            this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            this.operation.setAimedProgressPercent(0);
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            this.operation.setAimedProgressPercent(0);
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            this.operation.setAimedProgressPercent(100);
            this.operation.setCurrentStep(OperationStateBean.Step.FINISHED);
        } else {
            if (!currentStep.equals(OperationStateBean.Step.FINISHED)) throw new IllegalStateException("Unknown Step: " + currentStep);
            throw new IllegalStateException("No next for Step: " + currentStep);
        }
        this.mergeOperation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nextExecuteMigration() {
        ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
        WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
        if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                if (aimedWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(20);
                } else if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(40);
                } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedProgressPercent(60);
                } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.START_OK);
                    this.operation.setAimedProgressPercent(80);
                } else if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.START_OK);
                    this.operation.setAimedProgressPercent(100);
                } else {
                    if (!aimedServerProgressState.equals(ServerProgressState.START_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                    this.operation.setAimedServerProgressState(ServerProgressState.DESTROY_VM_HOSTS_OK);
                    this.operation.setAimedProgressPercent(100);
                }
            } else if (aimedWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(16);
            } else if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DISABLE_APPLICATIONS_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(50);
            } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                this.operation.setAimedProgressPercent(66);
            } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.START_OK);
                this.operation.setAimedProgressPercent(83);
            } else if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.START_OK);
                this.operation.setAimedProgressPercent(100);
            } else {
                if (!aimedServerProgressState.equals(ServerProgressState.START_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                this.operation.setAimedServerProgressState(ServerProgressState.DESTROY_VM_HOSTS_OK);
                this.operation.setAimedProgressPercent(100);
            }
        } else {
            if (!this.operation.getType().equals(IJadortService.OperationType.MIGRATE)) throw new IllegalStateException("Unknown OperationType: " + this.operation.getType());
            if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                this.operation.setAimedServerProgressState(ServerProgressState.UPLOAD_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DEPLOY_OK);
                this.operation.setAimedProgressPercent(66);
            } else if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.SET_DEFAULT_OK);
                this.operation.setAimedProgressPercent(100);
            } else if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.UNDEPLOY_OK);
                this.operation.setAimedProgressPercent(50);
            } else {
                if (!aimedServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                this.operation.setAimedServerProgressState(ServerProgressState.ERASE_OK);
                this.operation.setAimedProgressPercent(100);
            }
        }
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getProgressState().equals(this.operation.getAimedServerProgressState())) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        if (this.operation.getWorkerProgressList() != null) {
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getProgressState().equals(this.operation.getAimedWorkerProgressState())) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        this.mergeOperation();
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
                this.reachAimedServerProgressState(serverProgress);
            }
        }
        if (this.operation.getWorkerProgressList() == null) return;
        for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
            this.reachAimedWorkerProgressState(workerProgress);
        }
    }

    protected boolean canGoToPreviousStep() {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION) || currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            return false;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP) || currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION) || currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE) || currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER) || currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1) || currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            if (this.operation.getAimedServerProgressState().equals(ServerProgressState.ERASE_OK)) {
                return false;
            }
            ServerProgressState progressState = null;
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) && !serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                    return false;
                }
                if (progressState == null) {
                    progressState = serverProgress.getProgressState();
                    continue;
                }
                if (progressState.equals(serverProgress.getProgressState())) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) || serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) continue;
                return false;
            }
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getActionState().equals(OperationStateBean.ActionState.WAITING) || workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING) && serverProgress.getProgress() <= 0) continue;
                return false;
            }
            return true;
        }
        if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            return true;
        }
        throw new IllegalStateException("Unknown Step: " + currentStep);
    }

    protected void executePreviousStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            TopologyBean oldTopology = this.operation.getTopology();
            this.operation.setTopology(null);
            this.goToPreviousStep();
            this.em.remove((Object)oldTopology);
            this.em.flush();
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            ArrayList<ServerProgressBean> oldServerProgressList = new ArrayList<ServerProgressBean>();
            oldServerProgressList.addAll(this.operation.getServerProgressList());
            this.operation.setServerProgressList(null);
            this.operation.setType(null);
            ApplicationBean oldApplication = this.operation.getApplication();
            this.operation.setApplication(null);
            this.goToPreviousStep();
            for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                this.em.remove((Object)serverProgressBean);
            }
            if (oldApplication != null) {
                this.em.remove((Object)oldApplication);
            }
            this.em.flush();
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            this.operation.setSelectedGroup(null);
            this.goToPreviousStep();
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
            this.operation.setType(null);
            this.goToPreviousStep();
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
            this.goToPreviousStep();
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            if (this.anyMaintainedServerPresent()) {
                this.operation.setAimedProgressPercent(100);
                this.operation.setAimedServerProgressState(ServerProgressState.START_OK);
                this.operation.setAimedWorkerProgressState(WorkerProgressState.START_OK);
                ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
                for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                    if (!serverProgress.getServer().getMaintained()) continue;
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.getServer().setMaintained(false);
                    serverProgressList.add(serverProgress);
                }
                this.operation.setServerProgressList(serverProgressList);
                ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
                for (WorkerProgressBean workerProgress : this.operation.getAllWorkerProgressList()) {
                    if (!WorkerProgressState.START_OK.equals(workerProgress.getProgressState())) continue;
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgressList.add(workerProgress);
                }
                this.operation.setWorkerProgressList(workerProgressList);
                if (this.operation.getSelectedGroup().getClustered()) {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                }
                this.mergeOperation();
            } else {
                HashSet<ServerProgressBean> oldServerProgressList = new HashSet<ServerProgressBean>();
                if (this.operation.getServerProgressList() != null) {
                    oldServerProgressList.addAll(this.operation.getServerProgressList());
                }
                if (this.operation.getAllServerProgressList() != null) {
                    oldServerProgressList.addAll(this.operation.getAllServerProgressList());
                }
                HashSet<WorkerProgressBean> oldWorkerProgressList = new HashSet<WorkerProgressBean>();
                if (this.operation.getWorkerProgressList() != null) {
                    oldWorkerProgressList.addAll(this.operation.getWorkerProgressList());
                }
                if (this.operation.getAllWorkerProgressList() != null) {
                    oldWorkerProgressList.addAll(this.operation.getAllWorkerProgressList());
                }
                this.operation.setServerProgressList(null);
                this.operation.setWorkerProgressList(null);
                this.operation.setAllServerProgressList(null);
                this.operation.setAllWorkerProgressList(null);
                VMImageBean oldVMImage = this.operation.getVmImage();
                this.operation.setVmImage(null);
                this.goToPreviousStep();
                for (WorkerProgressBean workerProgressBean : oldWorkerProgressList) {
                    this.em.remove((Object)workerProgressBean);
                }
                for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                    this.em.remove((Object)serverProgressBean);
                }
                if (oldVMImage != null) {
                    this.em.remove((Object)oldVMImage);
                }
                this.em.flush();
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER)) {
            if (this.operation.getAimedWorkerProgressState().equals(WorkerProgressState.INITIAL)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                this.goToPreviousStep();
            } else {
                this.previousExecuteMigration();
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            if (this.operation.getAimedWorkerProgressState().equals(WorkerProgressState.INITIAL)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
                this.goToPreviousStep();
            } else {
                this.previousExecuteMigration();
            }
        } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
            workerProgressList.addAll(this.operation.getAllWorkerProgressList());
            this.operation.setWorkerProgressList(workerProgressList);
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                serverProgress.setProgressState(ServerProgressState.START_OK);
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
            }
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                workerProgress.setProgress(this.operation.getAimedProgressPercent());
                workerProgress.setProgressState(WorkerProgressState.START_OK);
                workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
            }
            this.goToPreviousStep();
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            if (this.operation.getAimedServerProgressState().equals(ServerProgressState.INITIAL)) {
                this.goToPreviousStep();
            } else {
                this.previousExecuteMigration();
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            if (this.operation.getAimedServerProgressState().equals(ServerProgressState.SET_DEFAULT_OK)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.setProgress(100);
                }
                this.goToPreviousStep();
            } else {
                this.previousExecuteMigration();
            }
        } else if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
            }
            if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
                for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                    serverProgress.getServer().setMaintained(false);
                }
                for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                }
            }
            this.goToPreviousStep();
        } else {
            throw new IllegalStateException("Unknown Step: " + currentStep);
        }
    }

    private void goToPreviousStep() throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation.getCurrentStep();
        ArrayList<VMImageBean> oldVMImages = new ArrayList<VMImageBean>();
        if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION) || currentStep.equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY)) {
            throw new IllegalStateException("No previous for Step: " + currentStep);
        }
        if (currentStep.equals(OperationStateBean.Step.SELECT_GROUP)) {
            this.operation.setCurrentStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_APPLICATION)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_OPERATION_TYPE)) {
            this.operation.setType(null);
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_GROUP);
        } else if (currentStep.equals(OperationStateBean.Step.SELECT_SERVERS)) {
            if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_VM_IMAGE);
            } else {
                this.operation.setType(null);
                this.operation.setCurrentStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER) || currentStep.equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER)) {
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_SERVERS);
            this.operation.setSelectedServers(null);
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                serverProgress.setOldDeploymentItem(null);
                if (serverProgress.getVmImage() == null) continue;
                oldVMImages.add(serverProgress.getVmImage());
                serverProgress.setVmImage(null);
            }
        } else if (currentStep.equals(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            }
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART1)) {
            this.operation.setAimedProgressPercent(0);
            this.operation.setCurrentStep(OperationStateBean.Step.SELECT_APPLICATION);
        } else if (currentStep.equals(OperationStateBean.Step.EXECUTING_MIGRATION_PART2)) {
            this.operation.setAimedProgressPercent(100);
            this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
        } else if (currentStep.equals(OperationStateBean.Step.FINISHED)) {
            this.operation.setAimedProgressPercent(100);
            if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
                if (this.operation.getSelectedGroup().getServers().get(0).getVm() != null) {
                    this.operation.setCurrentStep(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
                } else if (this.operation.getSelectedGroup().getClustered()) {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER);
                } else {
                    this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
                }
            } else if (this.hasOldVersion()) {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART2);
            } else {
                this.operation.setCurrentStep(OperationStateBean.Step.EXECUTING_MIGRATION_PART1);
            }
        } else {
            throw new IllegalStateException("Unknown Step: " + currentStep);
        }
        this.mergeOperation();
        for (VMImageBean oldVMImage : oldVMImages) {
            this.em.remove((Object)oldVMImage);
            this.em.flush();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void previousExecuteMigration() {
        ServerProgressState aimedServerProgressState = this.operation.getAimedServerProgressState();
        WorkerProgressState aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
        if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
            if (this.operation.getSelectedGroup().getClustered()) {
                if (aimedWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(80);
                } else if (aimedServerProgressState.equals(ServerProgressState.START_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                    this.operation.setAimedProgressPercent(60);
                } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                    this.operation.setAimedProgressPercent(40);
                } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                    this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                    this.operation.setAimedProgressPercent(20);
                } else {
                    if (!aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                    this.operation.setAimedWorkerProgressState(WorkerProgressState.INITIAL);
                    this.operation.setAimedProgressPercent(0);
                }
            } else if (aimedWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                this.operation.setAimedWorkerProgressState(WorkerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(83);
            } else if (aimedServerProgressState.equals(ServerProgressState.START_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.MAINTAIN_OK);
                this.operation.setAimedProgressPercent(66);
            } else if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.STOP_OK);
                this.operation.setAimedProgressPercent(50);
            } else if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DISABLE_APPLICATIONS_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(16);
            } else {
                if (!aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) throw new IllegalStateException("Unknown ServerProgressState or WorkerProgressState: " + aimedServerProgressState + ", " + aimedWorkerProgressState);
                this.operation.setAimedWorkerProgressState(WorkerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
            }
        } else {
            if (!this.operation.getType().equals(IJadortService.OperationType.MIGRATE)) throw new IllegalStateException("Unknown OperationType: " + this.operation.getType());
            if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.INITIAL);
                this.operation.setAimedProgressPercent(0);
            } else if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.UPLOAD_OK);
                this.operation.setAimedProgressPercent(33);
            } else if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                this.operation.setAimedServerProgressState(ServerProgressState.DEPLOY_OK);
                this.operation.setAimedProgressPercent(66);
            } else {
                if (!aimedServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                this.operation.setAimedServerProgressState(ServerProgressState.SET_DEFAULT_OK);
                this.operation.setAimedProgressPercent(0);
            }
        }
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (serverProgress.getProgressState().equals(this.operation.getAimedServerProgressState())) {
                    serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    serverProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        if (this.operation.getWorkerProgressList() != null) {
            for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
                if (workerProgress.getProgressState().equals(this.operation.getAimedWorkerProgressState())) {
                    workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
                    workerProgress.setProgress(this.operation.getAimedProgressPercent());
                    continue;
                }
                workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            }
        }
        this.mergeOperation();
        if (this.operation.getServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
                this.reachAimedServerProgressState(serverProgress);
            }
        }
        if (this.operation.getWorkerProgressList() == null) return;
        for (WorkerProgressBean workerProgress : this.operation.getWorkerProgressList()) {
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) continue;
            this.reachAimedWorkerProgressState(workerProgress);
        }
    }

    private boolean hasOldVersion() {
        for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
            if (!serverProgress.hasOldDeploymentItem()) continue;
            return true;
        }
        return false;
    }

    private boolean allServersHaveBeenMaintained() {
        for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
            if (server.getMaintained()) continue;
            return false;
        }
        return true;
    }

    private boolean anyMaintainedServerPresent() {
        if (this.operation.getAllServerProgressList() != null) {
            for (ServerProgressBean serverProgress : this.operation.getAllServerProgressList()) {
                if (!ServerProgressState.START_OK.equals(serverProgress.getProgressState())) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkStep(OperationStateBean.Step ... steps) throws JadortServiceException {
        OperationStateBean.Step currentStep = this.operation == null ? OperationStateBean.Step.SELECT_OPERATION : this.operation.getCurrentStep();
        for (OperationStateBean.Step step : steps) {
            if (!currentStep.equals(step)) continue;
            return;
        }
        throw new InvalidStepException(currentStep, steps);
    }
}

