/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;
import org.ow2.jasmine.jadort.service.action.VMMAction;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasmineVMMAction
extends VMMAction {
    private String url;

    public JasmineVMMAction(VMBean vm) {
        this.url = vm.getConnector().getConnectorUrl();
        this.appendToLog("Created JasmineVMMAction for JASMINe VMM Agent on URL \"" + this.url + "\"");
    }

    @Override
    protected void connectViaJMX() throws Exception {
        this.establishJMXConnection(new JMXServiceURL(this.url), null);
    }

    protected ObjectName getObjectNameForVMHost(String vmName) throws Exception {
        this.checkJMXConnection();
        Set<ObjectName> vms = this.mbscnx.queryNames(new ObjectName("*:type=VirtualMachine,name=" + vmName + ",*"), null);
        if (vms.size() < 1) {
            throw new Exception("There are no VirtualMachines named '" + vmName + "' on this VM Manager!");
        }
        if (vms.size() > 1) {
            throw new Exception("There are more than one VirtualMachines named '" + vmName + "' on this VM Manager!");
        }
        return vms.iterator().next();
    }

    @Override
    public String getFullVMName(String vmName) throws Exception {
        this.checkJMXConnection();
        HashMap<String, VirtualMachineMXBean.PowerState> matchingVMs = new HashMap<String, VirtualMachineMXBean.PowerState>();
        ArrayList<String> runningVMs = new ArrayList<String>();
        Set<ObjectName> vms = this.mbscnx.queryNames(new ObjectName("*:type=VirtualMachine,*"), null);
        for (ObjectName vmsItem : vms) {
            ObjectName vm = vmsItem;
            String name = vm.getKeyProperty("name");
            if ((name == null || !name.equals(vmName)) && !name.startsWith(vmName + '_')) continue;
            VirtualMachineMXBean.PowerState powerState = this.getVMState(name);
            matchingVMs.put(name, powerState);
            if (!powerState.equals((Object)VirtualMachineMXBean.PowerState.RUNNING)) continue;
            runningVMs.add(name);
        }
        if (runningVMs.size() == 0) {
            if (matchingVMs.size() == 0) {
                throw new IllegalStateException("There are no VM hosts with a name matching \"" + vmName + "\"" + "\"");
            }
            throw new IllegalStateException("There are no running VM hosts with a name matching \"" + vmName + "\"" + ". Non-running hosts are as follows: " + ((Object)matchingVMs).toString());
        }
        if (runningVMs.size() == 1) {
            return (String)runningVMs.get(0);
        }
        throw new IllegalStateException("There are " + runningVMs.size() + " running VM hosts with a name matching \"" + vmName + "\", whereas JaDOrT is expecting only one.");
    }

    @Override
    public void startVM(String vmName) throws Exception {
        this.appendToLog("Starting VM " + vmName);
        ObjectName vm = this.getObjectNameForVMHost(vmName);
        this.mbscnx.invoke(vm, "start", null, null);
        this.appendToLog("VM " + vmName + " signaled for start");
    }

    @Override
    public void stopVM(String vmName) throws Exception {
        this.appendToLog("Stopping VM " + vmName);
        ObjectName vm = this.getObjectNameForVMHost(vmName);
        this.mbscnx.invoke(vm, "shutdown", null, null);
        this.appendToLog("VM " + vmName + " signaled for stop");
    }

    @Override
    public VirtualMachineMXBean.PowerState getVMState(String vmName) throws Exception {
        ObjectName vm = this.getObjectNameForVMHost(vmName);
        String state = this.mbscnx.getAttribute(vm, "State").toString();
        return VirtualMachineMXBean.PowerState.valueOf((String)state);
    }

    @Override
    public void waitForVMState(String vmName, VirtualMachineMXBean.PowerState state, long timeout) throws Exception {
        this.appendToLog("Waiting for VM " + vmName + " to reach state " + state);
        ObjectName vm = this.getObjectNameForVMHost(vmName);
        VirtualMachineMXBean.PowerState currentState = null;
        long stopTime = System.currentTimeMillis() + timeout * 1000L;
        while (currentState != state && System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000L);
            String currentStateString = this.mbscnx.getAttribute(vm, "State").toString();
            currentState = VirtualMachineMXBean.PowerState.valueOf((String)currentStateString);
        }
        if (currentState == state) {
            this.appendToLog("VM " + vmName + " has reached state " + state);
            if (VirtualMachineMXBean.PowerState.RUNNING.equals((Object)state)) {
                String guestIpAddress = this.mbscnx.getAttribute(vm, "GuestIpAddress").toString();
                this.appendToLog("VM guest has IP address " + guestIpAddress);
            }
        } else {
            throw new Exception("VM " + vmName + " did not reach state " + state + " after " + timeout + " seconds! Try retrying manually using the \"Retry server\" button...");
        }
    }

    @Override
    public void deployImageOnVM(String copyVM, String newVMName, String vmImageUUID) throws Exception {
        this.checkJMXConnection();
        String newVmName = newVMName.substring(newVMName.lastIndexOf(47) + 1);
        this.appendToLog("Creating VM " + newVmName + " based on VM " + copyVM + " and VM image with UUID" + vmImageUUID);
        ObjectName vm = null;
        Set<ObjectName> vms = this.mbscnx.queryNames(new ObjectName("*:type=VirtualMachine,name=" + copyVM + ",*"), null);
        if (vms == null || vms.size() < 1) {
            this.mbscnx = null;
            throw new Exception("There are no VirtualMachines named '" + copyVM + "' on this VM Manager!");
        }
        if (vms.size() > 1) {
            this.mbscnx = null;
            throw new Exception("There are more than one VirtualMachines named '" + copyVM + "' on this VM Manager!");
        }
        vm = vms.iterator().next();
        ObjectName hostMBean = (ObjectName)this.mbscnx.getAttribute(vm, "HostMBean");
        Long memorySizeMB = (Long)this.mbscnx.getAttribute(vm, "MemorySizeMB");
        Integer numVCPUs = (Integer)this.mbscnx.getAttribute(vm, "NumVCPUs");
        Integer diskSizeMB = 1;
        String[] fields = new String[]{"name", "memorySizeMB", "numVCPU", "diskSizeMB", "vmImageUUID"};
        OpenType[] types = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING};
        CompositeType compositeType = new CompositeType("VMConfigSpec", "VMConfigSpec", fields, fields, types);
        CompositeDataSupport compositeData = new CompositeDataSupport(compositeType, fields, new Object[]{newVmName, memorySizeMB, numVCPUs, diskSizeMB, vmImageUUID});
        Object[] opParams = new Object[]{compositeData, true};
        String[] opSignature = new String[]{CompositeData.class.getName(), "boolean"};
        this.mbscnx.invoke(hostMBean, "createVM", opParams, opSignature);
        this.appendToLog("VM " + newVmName + " created based on VM " + copyVM + " and VM image with UUID" + vmImageUUID);
    }

    @Override
    public void destroyVM(String vmName) throws Exception {
        this.appendToLog("Destroying VM " + vmName);
        ObjectName vm = this.getObjectNameForVMHost(vmName);
        this.mbscnx.invoke(vm, "destroy", null, null);
        this.appendToLog("VM " + vmName + " destroyed");
    }

    @Override
    public List<VMImageBean> getVMImages() throws Exception {
        this.checkJMXConnection();
        ArrayList<VMImageBean> vmImages = new ArrayList<VMImageBean>();
        Iterator<ObjectName> i$ = this.mbscnx.queryNames(new ObjectName("*:type=VirtualMachineImage,*"), null).iterator();
        while (i$.hasNext()) {
            ObjectName mBean;
            ObjectName vmImage = mBean = i$.next();
            String name = this.mbscnx.getAttribute(vmImage, "Name").toString();
            String uuid = this.mbscnx.getAttribute(vmImage, "UUID").toString();
            vmImages.add(new VMImageBean(name, uuid));
        }
        return vmImages;
    }
}

